/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.gui.ButtonAlignment;
import com.mrcrayfish.backpacked.client.gui.screen.CustomiseBackpackScreen;
import com.mrcrayfish.backpacked.client.gui.screen.widget.MiniButton;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;

public class BackpackScreen
extends AbstractContainerScreen<BackpackContainerMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("backpacked", "textures/gui/backpack.png");
    private static final Component CUSTOMISE_TOOLTIP = Component.m_237115_((String)"backpacked.button.customise.tooltip");
    private static final Component CONFIG_TOOLTIP = Component.m_237115_((String)"backpacked.button.config.tooltip");
    private final int cols;
    private final int rows;
    private final boolean owner;
    private boolean opened;

    public BackpackScreen(BackpackContainerMenu backpackContainerMenu, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)backpackContainerMenu, playerInventory, titleIn);
        this.cols = backpackContainerMenu.getCols();
        this.rows = backpackContainerMenu.getRows();
        this.owner = backpackContainerMenu.isOwner();
        this.f_97726_ = 14 + Math.max(this.cols, 9) * 18;
        this.f_97727_ = 114 + this.rows * 18;
        this.f_97730_ = Math.max((this.cols * 18 - 162) / 2, 0) + 7;
        this.f_97731_ = this.rows * 18 + 17 + 4;
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.opened) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)0.75f, (float)1.0f));
            this.opened = true;
        }
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    int titleWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_);
                    button.f_93620_ = this.f_97735_ + titleWidth + 8 + 3 + i * 13;
                    break;
                }
                case RIGHT: {
                    button.f_93620_ = this.f_97735_ + this.f_97726_ - 7 - 10 - (buttons.size() - 1 - i) * 13;
                }
            }
            button.f_93621_ = this.f_97736_ + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        boolean canCustomise;
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        boolean bl = canCustomise = this.owner && (Boolean)Config.SERVER.disableCustomisation.get() == false;
        if (canCustomise) {
            buttons.add(new MiniButton(0, 0, 225, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> Network.getPlayChannel().sendToServer((Object)new MessageRequestCustomisation()), (button, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, CUSTOMISE_TOOLTIP, mouseX, mouseY)));
        }
        if (!((Boolean)Config.CLIENT.hideConfigButton.get()).booleanValue()) {
            buttons.add(new MiniButton(0, 0, 235, 0, CustomiseBackpackScreen.GUI_TEXTURE, onPress -> this.openConfigScreen(), (button, matrixStack, mouseX, mouseY) -> this.m_96602_(matrixStack, CONFIG_TOOLTIP, mouseX, mouseY)));
        }
        return buttons;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.m_6702_().forEach(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).m_198029_()) {
                button.m_7428_(matrixStack, mouseX, mouseY);
            }
        });
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.drawBackgroundWindow(matrixStack, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    private void drawBackgroundWindow(PoseStack poseStack, int x, int y, int width, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int backpackHeight = 17 + this.rows * 18;
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)7, (int)backpackHeight, (float)0.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(x + width - 7), (int)y, (int)7, (int)backpackHeight, (float)8.0f, (float)0.0f, (int)7, (int)backpackHeight, (int)256, (int)256);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(x + 7), (int)y, (int)(width - 14), (int)backpackHeight, (float)7.0f, (float)0.0f, (int)1, (int)backpackHeight, (int)256, (int)256);
        int slotWidth = this.cols * 18;
        int slotHeight = this.rows * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - slotWidth) / 2, 0);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(backpackStartX + x + 7), (int)(y + 17), (int)slotWidth, (int)slotHeight, (float)15.0f, (float)0.0f, (int)slotWidth, (int)slotHeight, (int)256, (int)256);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)x, (int)(y + backpackHeight), (int)7, (int)97, (float)0.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(x + width - 7), (int)(y + backpackHeight), (int)7, (int)97, (float)8.0f, (float)143.0f, (int)7, (int)97, (int)256, (int)256);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(x + 7), (int)(y + backpackHeight), (int)(width - 14), (int)97, (float)7.0f, (float)143.0f, (int)1, (int)97, (int)256, (int)256);
        int inventoryStartX = Math.max((slotWidth - minSlotWidth) / 2, 0);
        BackpackScreen.m_93160_((PoseStack)poseStack, (int)(x + inventoryStartX + 7), (int)(y + backpackHeight + 14), (int)163, (int)76, (float)15.0f, (float)157.0f, (int)163, (int)76, (int)256, (int)256);
    }

    private void openConfigScreen() {
        ModList.get().getModContainerById("backpacked").ifPresent(container -> {
            Screen screen = container.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).map(function -> (Screen)function.screenFunction().apply(this.f_96541_, null)).orElse(null);
            if (screen != null) {
                this.f_96541_.m_91152_(screen);
            } else if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                MutableComponent modName = Component.m_237113_((String)"Configured");
                modName.m_6270_(modName.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131162_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"backpacked.chat.open_curseforge_page"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")));
                MutableComponent message = Component.m_237110_((String)"backpacked.chat.install_configured", (Object[])new Object[]{modName});
                this.f_96541_.f_91074_.m_5661_((Component)message, false);
            }
        });
    }
}

