/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.client.model.backpack.BackpackModel;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BackpackLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, Supplier<BackpackModel>> VARIANTS = new HashMap<String, Supplier<BackpackModel>>();
    private static final Supplier<BackpackModel> DEFAULT_SUPPLIER = () -> ModelInstances.get().getStandardModel();

    public BackpackLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack stack, MultiBufferSource renderTypeBuffer, int p_225628_3_, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)player);
        Item item = backpack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
            if (chestStack.m_41720_() == Items.f_42741_ && !BackpackLayer.canRenderWithElytra(backpack)) {
                return;
            }
            if (Services.BACKPACK.isUsingThirdPartySlot() && !Services.BACKPACK.isBackpackVisible((Player)player)) {
                return;
            }
            String modelName = backpack.m_41784_().m_128461_("BackpackModel");
            BackpackModel model = VARIANTS.getOrDefault(modelName, DEFAULT_SUPPLIER).get();
            if (model == null) {
                return;
            }
            stack.m_85836_();
            model.transformToPlayerBody(((PlayerModel)this.m_117386_()).f_102810_, !chestStack.m_41619_());
            model.setupAngles((Player)player, ((Player)player).f_19797_, partialTick);
            VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)renderTypeBuffer, (RenderType)model.m_103119_(model.getTextureLocation()), (boolean)false, (backpack.m_41790_() && BackpackLayer.canShowEnchantmentGlint(backpack) ? 1 : 0) != 0);
            model.m_7695_(stack, builder, p_225628_3_, OverlayTexture.f_118083_, 1.0f, 2.0f, 2.0f, 2.0f);
            stack.m_85849_();
        }
    }

    public static boolean canRenderWithElytra(ItemStack stack) {
        return stack.m_41784_().m_128471_(ModelProperty.SHOW_WITH_ELYTRA.getTagName());
    }

    public static boolean canShowEnchantmentGlint(ItemStack stack) {
        return stack.m_41784_().m_128471_(ModelProperty.SHOW_GLINT.getTagName());
    }

    public static synchronized void registerModel(ResourceLocation id, Supplier<BackpackModel> model) {
        VARIANTS.putIfAbsent(id.toString(), model);
    }

    public static Supplier<BackpackModel> getModel(String id) {
        return VARIANTS.getOrDefault(id, DEFAULT_SUPPLIER);
    }
}

