/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.impl;

import com.mrcrayfish.backpacked.client.model.ModelInstances;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.tracker.ProgressFormatters;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.Panda;

public class BambooBasketBackpack
extends Backpack {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "bamboo_basket");

    public BambooBasketBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ModelInstances.get()::getBambooBasketModel;
    }

    @Override
    @Nullable
    public IProgressTracker createProgressTracker() {
        return new ProgressTracker();
    }

    public static class ProgressTracker
    implements IProgressTracker {
        private static final int COUNT = 10;
        private final Set<UUID> fedPandas = new HashSet<UUID>();

        public void addPanda(Panda panda, ServerPlayer player) {
            this.fedPandas.add(panda.m_20148_());
            this.markForCompletionTest(player);
        }

        @Override
        public boolean isComplete() {
            return this.fedPandas.size() >= 10;
        }

        @Override
        public void read(CompoundTag tag) {
            this.fedPandas.clear();
            ListTag list = tag.m_128437_("FedPandas", 10);
            list.forEach(t -> {
                CompoundTag uuidTag = (CompoundTag)t;
                long mostBits = uuidTag.m_128454_("Most");
                long leastBits = uuidTag.m_128454_("Least");
                this.fedPandas.add(new UUID(mostBits, leastBits));
            });
        }

        @Override
        public void write(CompoundTag tag) {
            ListTag list = new ListTag();
            this.fedPandas.forEach(uuid -> {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.m_128356_("Most", uuid.getMostSignificantBits());
                uuidTag.m_128356_("Least", uuid.getLeastSignificantBits());
                list.add((Object)uuidTag);
            });
            tag.m_128365_("FedPandas", (Tag)list);
        }

        @Override
        public Component getDisplayComponent() {
            return ProgressFormatters.FED_X_OF_X.apply(this.fedPandas.size(), 10);
        }
    }
}

