/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker.impl;

import com.mrcrayfish.backpacked.data.tracker.impl.CraftingProgressTracker;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class UniqueCraftingProgressTracker
extends CraftingProgressTracker {
    protected Set<ResourceLocation> craftedItems = new HashSet<ResourceLocation>();

    public UniqueCraftingProgressTracker(int totalCount, Predicate<ItemStack> predicate) {
        super(totalCount, predicate);
    }

    @Override
    public void processCrafted(ItemStack stack, ServerPlayer player) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (!this.craftedItems.contains(id) && this.predicate.test(stack)) {
            ++this.count;
            this.craftedItems.add(id);
            this.markForCompletionTest(player);
        }
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        this.craftedItems.clear();
        ListTag list = tag.m_128437_("CraftedItems", 8);
        list.forEach(inbt -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)inbt.m_7916_());
            if (id != null) {
                this.craftedItems.add(id);
            }
        });
    }

    @Override
    public void write(CompoundTag tag) {
        super.write(tag);
        ListTag list = new ListTag();
        this.craftedItems.forEach(location -> list.add((Object)StringTag.m_129297_((String)location.toString())));
        tag.m_128365_("CraftedItems", (Tag)list);
    }
}

