/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.authlib.GameProfile;
import commoble.bagofyurting.BlockRemovalSorter;
import commoble.bagofyurting.BlockUnloadSorter;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import commoble.bagofyurting.OptionalSpawnParticlePacket;
import commoble.bagofyurting.ServerConfig;
import commoble.bagofyurting.TagWrappers;
import commoble.bagofyurting.TransientPlayerData;
import commoble.bagofyurting.api.BagOfYurtingAPI;
import commoble.bagofyurting.api.BlockDataDeserializer;
import commoble.bagofyurting.api.BlockDataSerializer;
import commoble.bagofyurting.api.RotationUtil;
import commoble.bagofyurting.api.internal.DataTransformers;
import commoble.bagofyurting.util.NBTMapHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class BagOfYurtingData {
    public static final String NBT_KEY = "yurtdata";
    public static final Direction BASE_DIRECTION = Direction.SOUTH;
    private static final NBTMapHelper<BlockPos, CompoundTag, StateData, CompoundTag> mapper = new NBTMapHelper<BlockPos, CompoundTag, StateData, CompoundTag>("yurtdata", NbtUtils::m_129224_, NbtUtils::m_129239_, StateData::write, StateData::read);
    private final Map<BlockPos, StateData> map;
    public static final AABB EMPTY_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BagOfYurtingData(Map<BlockPos, StateData> map) {
        this.map = map;
    }

    public static BagOfYurtingData yurtBlocksAndConvertToData(UseOnContext context, int radius) {
        Object object;
        Player player = context.m_43723_();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        BlockPos origin = context.m_8083_();
        Direction orientation = context.m_8125_();
        Level level = context.m_43725_();
        Rotation rotation = RotationUtil.getTransformRotation(orientation);
        BlockPos minYurt = origin.m_142082_(-radius, 0, -radius);
        BlockPos maxYurt = origin.m_142082_(radius, 2 * radius, radius);
        List<Pair> transformPairs = BlockPos.m_121990_((BlockPos)minYurt, (BlockPos)maxYurt).filter(pos -> BagOfYurtingData.canBlockBeStored(canPlayerOverrideSafetyLists, context, pos)).map(BlockPos::m_7949_).sorted(new BlockRemovalSorter(level)).map(pos -> BagOfYurtingData.getTransformedPosAndStateData((LevelAccessor)level, pos, rotation, minYurt, maxYurt, origin)).collect(Collectors.toList());
        BlockState air = Blocks.f_50016_.m_49966_();
        transformPairs.forEach(pair -> {
            BlockPos pos = (BlockPos)pair.getLeft();
            level.m_46747_(pos);
            level.m_7731_(pos, air, 0);
        });
        List<BlockPos> removedPositions = transformPairs.stream().map(Pair::getLeft).collect(Collectors.toList());
        Map<BlockPos, StateData> transformedData = transformPairs.stream().map(Pair::getRight).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (transformPairs.size() > 0 && (object = level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            BagOfYurtingData.doPoofEffects(serverLevel, removedPositions);
            for (Pair entry : transformPairs) {
                BlockPos pos2 = (BlockPos)entry.getKey();
                BlockState oldState = ((StateData)((Pair)entry.getValue()).getRight()).state;
                BagOfYurtingData.sendBlockUpdateAfterRemoval(level, pos2, oldState);
            }
        }
        return new BagOfYurtingData(transformedData);
    }

    private static void sendBlockUpdateAfterRemoval(Level level, BlockPos pos, BlockState oldState) {
        level.m_7260_(pos, oldState, Blocks.f_50016_.m_49966_(), 3);
        level.m_46672_(pos, oldState.m_60734_());
    }

    public boolean attemptUnloadIntoLevel(UseOnContext context, int radius) {
        boolean success;
        BlockPos hitPos;
        Level level = context.m_43725_();
        boolean hitBlockReplaceable = level.m_8055_(hitPos = context.m_8083_()).m_60767_().m_76336_();
        BlockPos origin = hitBlockReplaceable ? hitPos : hitPos.m_142300_(context.m_43719_());
        Direction orientation = context.m_8125_();
        Rotation unrotation = RotationUtil.getUntransformRotation(orientation);
        Player player = context.m_43723_();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        Map<BlockPos, StateData> LevelPositions = this.map.entrySet().stream().collect(Collectors.toMap(entry -> RotationUtil.untransformBlockPos(unrotation, (BlockPos)entry.getKey(), origin), entry -> (StateData)entry.getValue()));
        boolean bl = success = LevelPositions.entrySet().stream().allMatch(entry -> BagOfYurtingData.canBlockBeUnloadedAt(canPlayerOverrideSafetyLists, (BlockPos)entry.getKey(), level)) && BagOfYurtingData.doesPlaceEventSucceed(context, level, player, LevelPositions);
        if (success) {
            BlockPos minYurt = origin.m_142082_(-radius, 0, -radius);
            BlockPos maxYurt = origin.m_142082_(radius, 2 * radius, radius);
            List<Map.Entry> LevelPositionList = LevelPositions.entrySet().stream().sorted(BlockUnloadSorter.INSTANCE).collect(Collectors.toList());
            LevelPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockIntoLevel(level, (BlockPos)entry.getKey(), unrotation));
            LevelPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockEntityData(level, (BlockPos)entry.getKey(), unrotation, minYurt, maxYurt, origin));
            if (level instanceof ServerLevel) {
                BagOfYurtingData.doPoofEffects((ServerLevel)level, LevelPositions.keySet());
            }
        }
        return success;
    }

    private static void doPoofEffects(ServerLevel Level2, Collection<BlockPos> changedPositions) {
        AABB aabb = changedPositions.stream().map(AABB::new).reduce(AABB::m_82367_).orElse(EMPTY_AABB);
        if (aabb.m_82309_() > 0.5) {
            Vec3 center = aabb.m_82399_();
            double xRadius = aabb.m_82362_() * 0.5;
            double yRadius = aabb.m_82376_() * 0.5;
            double zRadius = aabb.m_82385_() * 0.5;
            double volume = xRadius * yRadius * zRadius * 8.0;
            int particles = Math.max(5000, (int)volume * 5);
            Level2.m_5594_(null, new BlockPos(center), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            OptionalSpawnParticlePacket.spawnParticlesFromServer(Level2, ParticleTypes.f_123813_, center.m_7096_(), center.m_7098_(), center.m_7094_(), particles, xRadius, yRadius, zRadius, 0.0);
        }
    }

    private static boolean canPlayerOverrideSafetyLists(@Nullable Player player) {
        if (player != null && (player.m_7500_() || player.m_20310_(ServerConfig.INSTANCE.minPermissionToYurtUnyurtableBlocks.get().intValue()))) {
            return TransientPlayerData.isPlayerOverridingSafetyList(Player.m_36198_((GameProfile)player.m_36316_()));
        }
        return false;
    }

    private static boolean canBlockBeStored(boolean canPlayerOverrideSafetyLists, UseOnContext context, BlockPos pos) {
        Level Level2 = context.m_43725_();
        BlockState state = Level2.m_8055_(pos);
        Player player = context.m_43723_();
        return !state.m_60795_() && !Level2.m_151570_(pos) && BagOfYurtingData.isBlockYurtingAllowedByTags(canPlayerOverrideSafetyLists, state, pos) && BagOfYurtingData.doesBreakEventSucceed(Level2, pos, state, player);
    }

    private static boolean isBlockYurtingAllowedByTags(boolean canPlayerOverrideSafetyLists, BlockState state, BlockPos pos) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        Block block = state.m_60734_();
        return !TagWrappers.blacklist.m_8110_((Object)block) && (TagWrappers.whitelist.m_6497_().isEmpty() || TagWrappers.whitelist.m_8110_((Object)block));
    }

    private static boolean doesBreakEventSucceed(Level Level2, BlockPos pos, BlockState state, Player player) {
        if (!(Level2 instanceof ServerLevel)) {
            return false;
        }
        Player eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)Level2));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(Level2, pos, state, eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static boolean doesPlaceEventSucceed(UseOnContext context, Level level, Player player, Map<BlockPos, StateData> levelPositions) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        Player eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
        List snapshots = levelPositions.keySet().stream().map(pos -> BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos)).collect(Collectors.toList());
        BlockState statePlacedAgainst = level.m_8055_(context.m_8083_());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, statePlacedAgainst, (Entity)eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static Pair<BlockPos, Pair<BlockPos, StateData>> getTransformedPosAndStateData(LevelAccessor Level2, BlockPos absolutePos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
        BlockPos transformedPos = RotationUtil.transformBlockPos(rotation, absolutePos, origin);
        StateData stateData = BagOfYurtingData.getYurtedStateData(Level2, absolutePos, rotation, minYurt, maxYurt, origin, transformedPos);
        return Pair.of((Object)absolutePos, (Object)Pair.of((Object)transformedPos, (Object)stateData));
    }

    private static StateData getYurtedStateData(LevelAccessor Level2, BlockPos pos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin, BlockPos transformedPos) {
        CompoundTag nbt = new CompoundTag();
        BlockState state = Level2.m_8055_(pos);
        BlockState rotatedState = state.rotate(Level2, pos, rotation);
        BlockEntity te = Level2.m_7702_(pos);
        if (te != null) {
            BlockDataSerializer<?> serializer = DataTransformers.transformers.getOrDefault(te.m_58903_(), BagOfYurtingAPI.DEFAULT_TRANSFORMER).getSerializer();
            serializer.writeWithYurtContext(te, nbt, rotation, minYurt, maxYurt, origin, transformedPos);
        }
        return new StateData(rotatedState, nbt);
    }

    private static boolean canBlockBeUnloadedAt(boolean canPlayerOverrideSafetyLists, BlockPos pos, Level Level2) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        BlockState oldState = Level2.m_8055_(pos);
        return oldState.m_60795_() || TagWrappers.replaceable.m_8110_((Object)oldState.m_60734_()) || oldState.m_60767_().m_76336_();
    }

    public static boolean doesNBTContainYurtData(CompoundTag nbt) {
        return !nbt.m_128437_(NBT_KEY, 10).isEmpty();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public CompoundTag writeIntoNBT(CompoundTag nbt) {
        mapper.write(this.map, nbt);
        return nbt;
    }

    public static BagOfYurtingData read(CompoundTag nbt) {
        return new BagOfYurtingData(mapper.read(nbt));
    }

    public CompressedBagOfYurtingData compress() {
        Object2IntOpenHashMap indexMap = new Object2IntOpenHashMap();
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        ArrayList<CompressedBagOfYurtingData.CompressedStateData> data = new ArrayList<CompressedBagOfYurtingData.CompressedStateData>();
        this.map.forEach((arg_0, arg_1) -> BagOfYurtingData.lambda$compress$10((Object2IntMap)indexMap, states, data, arg_0, arg_1));
        return new CompressedBagOfYurtingData(states, data);
    }

    private static /* synthetic */ void lambda$compress$10(Object2IntMap indexMap, List states, List data, BlockPos pos, StateData stateData) {
        BlockState state = stateData.state;
        CompoundTag nbt = stateData.BlockEntityData;
        Optional<CompoundTag> optionalNBT = nbt == null || nbt.m_128456_() ? Optional.empty() : Optional.of(nbt);
        int index = (Integer)indexMap.computeIfAbsent((Object)state, newState -> {
            int newIndex = states.size();
            states.add(state);
            return newIndex;
        });
        CompressedBagOfYurtingData.CompressedStateData compressedData = new CompressedBagOfYurtingData.CompressedStateData(pos, index, optionalNBT);
        data.add(compressedData);
    }

    public static class StateData {
        public static final String BLOCKSTATE = "state";
        public static final String TILE = "te";
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final CompoundTag BlockEntityData;

        public StateData(@Nonnull BlockState state, @Nonnull CompoundTag BlockEntityData) {
            this.state = state;
            this.BlockEntityData = BlockEntityData;
        }

        public BlockState getState() {
            return this.state;
        }

        public void setBlockIntoLevel(Level level, BlockPos pos, Rotation unrotation) {
            level.m_46597_(pos, this.state.m_60717_(unrotation));
        }

        public void setBlockEntityData(Level level, BlockPos pos, Rotation unrotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
            BlockEntity te;
            if (!this.BlockEntityData.m_128456_() && (te = level.m_7702_(pos)) != null) {
                BlockDataDeserializer<?> x = DataTransformers.transformers.getOrDefault(te.m_58903_(), BagOfYurtingAPI.DEFAULT_TRANSFORMER).getDeserializer();
                x.readWithYurtContext(te, this.BlockEntityData, level, pos, this.state, unrotation, minYurt, maxYurt, origin);
                te.m_142339_(level);
            }
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_(BLOCKSTATE, (Tag)NbtUtils.m_129202_((BlockState)this.state));
            nbt.m_128365_(TILE, (Tag)this.BlockEntityData);
            return nbt;
        }

        public static StateData read(CompoundTag nbt) {
            BlockState state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_(BLOCKSTATE));
            CompoundTag te = nbt.m_128469_(TILE);
            return new StateData(state, te);
        }
    }
}

