/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.IsWasSprintPacket;
import commoble.bagofyurting.OptionalSpawnParticlePacket;
import commoble.bagofyurting.ServerConfig;
import commoble.bagofyurting.ShapedBagUpgradeRecipe;
import commoble.bagofyurting.ShapelessBagUpgradeRecipe;
import commoble.bagofyurting.api.internal.DataTransformers;
import commoble.bagofyurting.client.ClientEvents;
import commoble.bagofyurting.storage.StorageManager;
import commoble.bagofyurting.util.ConfigHelper;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="bagofyurting")
public class BagOfYurtingMod {
    public static final String MODID = "bagofyurting";
    public static BagOfYurtingMod INSTANCE;
    public static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel CHANNEL;
    public final RegistryObject<BagOfYurtingItem> bagOfYurtingItem;
    public final RegistryObject<RecipeSerializer<ShapedRecipe>> shapedUpgradeRecipeSerializer;
    public final RegistryObject<RecipeSerializer<ShapelessRecipe>> shapelessUpgradeRecipeSerializer;

    public BagOfYurtingMod() {
        INSTANCE = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DeferredRegister items = BagOfYurtingMod.makeDeferredRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister recipeSerializers = BagOfYurtingMod.makeDeferredRegister(modBus, ForgeRegistries.RECIPE_SERIALIZERS);
        this.bagOfYurtingItem = items.register("bag_of_yurting", () -> new BagOfYurtingItem(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1)));
        this.shapedUpgradeRecipeSerializer = recipeSerializers.register("shaped_bag_of_yurting_upgrade", () -> new ShapedBagUpgradeRecipe.Serializer());
        this.shapelessUpgradeRecipeSerializer = recipeSerializers.register("shapeless_bag_of_yurting_upgrade", () -> new ShapelessBagUpgradeRecipe.Serializer());
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onModloadingComplete);
        forgeBus.addListener(this::onLevelSave);
        ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::new);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.subscribeClientEvents(modBus, forgeBus);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    void onCommonSetup(FMLCommonSetupEvent event) {
        int packetID = 0;
        CHANNEL.registerMessage(packetID++, IsWasSprintPacket.class, IsWasSprintPacket::write, IsWasSprintPacket::read, IsWasSprintPacket::handle);
        CHANNEL.registerMessage(packetID++, OptionalSpawnParticlePacket.class, ClientboundLevelParticlesPacket::m_5779_, OptionalSpawnParticlePacket::read, OptionalSpawnParticlePacket::handle);
    }

    void onModloadingComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(this::afterModloadingComplete);
    }

    void afterModloadingComplete() {
        DataTransformers.freezeRegistries();
    }

    void onLevelSave(WorldEvent.Save event) {
        LevelAccessor Level2 = event.getWorld();
        if (Level2 instanceof ServerLevel) {
            StorageManager.onSave((ServerLevel)Level2);
        }
    }

    static {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }
}

