/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.storage;

import commoble.bagofyurting.BagOfYurtingData;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageManager {
    private static final Logger LOGGER = LogManager.getLogger(StorageManager.class);
    private static final Queue<Pair<String, BagOfYurtingData>> dataToSave = new LinkedBlockingQueue<Pair<String, BagOfYurtingData>>();
    private static final Map<String, BagOfYurtingData> dirtyMap = new HashMap<String, BagOfYurtingData>();
    private static final Queue<String> dataToRemove = new LinkedBlockingQueue<String>();

    public static void save(String id, BagOfYurtingData data) {
        dataToSave.add((Pair<String, BagOfYurtingData>)Pair.of((Object)id, (Object)data));
        dirtyMap.put(id, data);
        dataToRemove.remove(id);
    }

    public static void remove(String id) {
        dirtyMap.remove(id);
        if (!dataToSave.removeIf(pair -> ((String)pair.getLeft()).equals(id))) {
            dataToRemove.add(id);
        }
    }

    @Nullable
    public static BagOfYurtingData load(MinecraftServer server, String id) {
        CompoundTag nbt;
        if (dirtyMap.containsKey(id)) {
            return dirtyMap.get(id);
        }
        Path directory = StorageManager.getSaveDirectory(server);
        if (directory == null) {
            return null;
        }
        Path file = directory.resolve(id + ".dat");
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            nbt = NbtIo.m_128937_((File)file.toFile());
        }
        catch (IOException e) {
            LOGGER.error("Unable to load save data for Bag of Yurting:", (Throwable)e);
            return null;
        }
        return CompressedBagOfYurtingData.fromNBT(nbt).uncompress();
    }

    public static boolean has(MinecraftServer server, String id) {
        if (dirtyMap.containsKey(id)) {
            return true;
        }
        Path directory = StorageManager.getSaveDirectory(server);
        if (directory == null) {
            return false;
        }
        return Files.exists(directory.resolve(id + ".dat"), new LinkOption[0]);
    }

    public static void onSave(ServerLevel Level2) {
        StorageManager.profile(Level2, "onSave", () -> {
            Path saveDirectory = StorageManager.getSaveDirectory(Level2.m_142572_());
            if (saveDirectory == null) {
                return;
            }
            StorageManager.profile(Level2, "saveQueued", () -> StorageManager.saveQueued(saveDirectory));
            StorageManager.profile(Level2, "removeQueued", () -> StorageManager.removeQueued(saveDirectory));
        });
    }

    private static void saveQueued(Path saveDirectory) {
        ArrayList<Pair<String, BagOfYurtingData>> toReSave = new ArrayList<Pair<String, BagOfYurtingData>>(dataToSave.size());
        while (!dataToSave.isEmpty()) {
            Pair<String, BagOfYurtingData> pair = dataToSave.poll();
            Path file = saveDirectory.resolve((String)pair.getLeft() + ".dat");
            CompressedBagOfYurtingData data = ((BagOfYurtingData)pair.getRight()).compress();
            CompoundTag nbt = data.toNBT();
            try {
                NbtIo.m_128944_((CompoundTag)nbt, (File)file.toFile());
                dirtyMap.remove(pair.getLeft());
            }
            catch (IOException e) {
                LOGGER.error("Could not save Bag of Yurting data with id: " + (String)pair.getLeft());
                toReSave.add(pair);
            }
        }
        dataToSave.addAll(toReSave);
    }

    private static void removeQueued(Path saveDirectory) {
        ArrayList<String> failedRemove = new ArrayList<String>(dataToRemove.size());
        while (!dataToRemove.isEmpty()) {
            String id = dataToRemove.poll();
            Path file = saveDirectory.resolve(id + ".dat").toAbsolutePath();
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete Bag of Yurting data with id: " + id, (Throwable)e);
                failedRemove.add(id);
            }
        }
        dataToRemove.addAll(failedRemove);
    }

    @Nullable
    private static Path getSaveDirectory(MinecraftServer server) {
        Path dir = server.m_129843_(new LevelResource("bagofyurting"));
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create Bag of Yurting mod folder: " + dir, (Throwable)e);
                return null;
            }
        }
        return dir;
    }

    private static void profile(ServerLevel Level2, String name, Runnable runnable) {
        Level2.m_46473_().m_6180_("bagofyurting#" + name);
        runnable.run();
        Level2.m_46473_().m_7238_();
    }
}

