/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BiomeColor;
import fionathemortal.betterbiomeblend.mixin.AccessorDoubleOptionSliderWidget;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_316;
import net.minecraft.class_353;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4067;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_5321;

public final class BetterBiomeBlendClient {
    public static final int BIOME_BLEND_RADIUS_MAX = 14;
    public static final int BIOME_BLEND_RADIUS_MIN = 0;
    public static final class_4067 BIOME_BLEND_RADIUS = new class_4067("options.biomeBlendRadius", 0.0, 14.0, 1.0f, BetterBiomeBlendClient::biomeBlendRadiusOptionGetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionSetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionGetDisplayText);
    public static class_315 gameOptions;
    public static final class_5321<class_1959> PLAINS;

    public static void postInitGUIEvent(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_446) {
            class_446 optionsScreen = (class_446)screen;
            BetterBiomeBlendClient.replaceBiomeBlendRadiusOption((class_437)optionsScreen);
        }
    }

    public static void replaceBiomeBlendRadiusOption(class_437 screen) {
        List children = screen.method_25396();
        block0: for (class_364 child : children) {
            if (!(child instanceof class_353)) continue;
            class_353 rowList = (class_353)child;
            List rowListEntries = rowList.method_25396();
            boolean replacedOption = false;
            for (int index = 0; index < rowListEntries.size(); ++index) {
                class_353.class_354 row = (class_353.class_354)rowListEntries.get(index);
                List rowChildren = row.method_25396();
                for (class_364 rowChild : rowChildren) {
                    AccessorDoubleOptionSliderWidget accessor;
                    if (!(rowChild instanceof AccessorDoubleOptionSliderWidget) || (accessor = (AccessorDoubleOptionSliderWidget)rowChild).getOption() != class_316.field_18189) continue;
                    class_353.class_354 newRow = class_353.class_354.method_20409((class_315)class_310.method_1551().field_1690, (int)screen.field_22789, (class_316)BIOME_BLEND_RADIUS);
                    rowListEntries.set(index, newRow);
                    replacedOption = true;
                }
                if (replacedOption) continue block0;
            }
        }
    }

    public static Double biomeBlendRadiusOptionGetValue(class_315 settings) {
        double result = settings.field_1878;
        return result;
    }

    public static void biomeBlendRadiusOptionSetValue(class_315 settings, Double optionValues) {
        int currentValue = (int)optionValues.doubleValue();
        int newSetting = class_3532.method_15340((int)currentValue, (int)0, (int)14);
        if (settings.field_1878 != newSetting) {
            settings.field_1878 = newSetting;
            BiomeColor.clearBlendCaches();
            class_310.method_1551().field_1769.method_3279();
        }
    }

    public static class_2561 biomeBlendRadiusOptionGetDisplayText(class_315 settings, class_4067 optionValues) {
        int currentValue = (int)optionValues.method_18613(settings);
        int blendDiameter = 2 * currentValue + 1;
        class_2588 result = new class_2588("options.generic_value", new Object[]{new class_2588("options.biomeBlendRadius"), new class_2588("options.biomeBlendRadius." + blendDiameter)});
        return result;
    }

    public static void overwriteOptifineGUIBlendRadiusOption() {
        boolean success = false;
        try {
            Class<?> guiDetailSettingsOFClass = Class.forName("net.optifine.gui.GuiDetailSettingsOF");
            try {
                Field enumOptionsField = guiDetailSettingsOFClass.getDeclaredField("enumOptions");
                enumOptionsField.setAccessible(true);
                class_316[] enumOptions = (class_316[])enumOptionsField.get(null);
                boolean found = false;
                for (int index = 0; index < enumOptions.length; ++index) {
                    class_316 option = enumOptions[index];
                    if (option != class_316.field_18189) continue;
                    enumOptions[index] = BIOME_BLEND_RADIUS;
                    found = true;
                    break;
                }
                if (found) {
                    success = true;
                }
            }
            catch (Exception exception) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (success) {
            // empty if block
        }
    }

    public static int getBlendRadiusSetting() {
        int result = 0;
        if (gameOptions == null) {
            gameOptions = class_310.method_1551().field_1690;
        }
        if (gameOptions != null) {
            result = BetterBiomeBlendClient.gameOptions.field_1878;
        }
        return result;
    }

    static {
        PLAINS = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)new class_2960("minecraft", "plains"));
    }
}

