/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BetterBiomeBlend;
import fionathemortal.betterbiomeblend.BiomeColor;
import fionathemortal.betterbiomeblend.mixin.AccessorOptionSlider;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class BetterBiomeBlendClient {
    public static final int BIOME_BLEND_RADIUS_MAX = 14;
    public static final int BIOME_BLEND_RADIUS_MIN = 0;
    public static final SliderPercentageOption BIOME_BLEND_RADIUS = new SliderPercentageOption("options.biomeBlendRadius", 0.0, 14.0, 1.0f, BetterBiomeBlendClient::biomeBlendRadiusOptionGetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionSetValue, BetterBiomeBlendClient::biomeBlendRadiusOptionGetDisplayText);
    public static final GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
    public static final RegistryObject<Biome> PLAINS = RegistryObject.of((ResourceLocation)new ResourceLocation("minecraft:plains"), (IForgeRegistry)ForgeRegistries.BIOMES);

    @SubscribeEvent
    public static void postInitGUIEvent(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (screen instanceof VideoSettingsScreen) {
            VideoSettingsScreen videoSettingsScreen = (VideoSettingsScreen)screen;
            BetterBiomeBlendClient.replaceBiomeBlendRadiusOption(videoSettingsScreen);
        }
    }

    public static int getBlendRadiusSetting() {
        int result = BetterBiomeBlendClient.gameSettings.field_205217_U;
        return result;
    }

    public static void replaceBiomeBlendRadiusOption(VideoSettingsScreen screen) {
        List children = screen.func_231039_at__();
        block0: for (IGuiEventListener child : children) {
            if (!(child instanceof OptionsRowList)) continue;
            OptionsRowList rowList = (OptionsRowList)child;
            List rowListEntries = rowList.func_231039_at__();
            boolean replacedOption = false;
            for (int index = 0; index < rowListEntries.size(); ++index) {
                OptionsRowList.Row row = (OptionsRowList.Row)rowListEntries.get(index);
                List rowChildren = row.func_231039_at__();
                for (IGuiEventListener rowChild : rowChildren) {
                    AccessorOptionSlider accessor;
                    if (!(rowChild instanceof AccessorOptionSlider) || (accessor = (AccessorOptionSlider)rowChild).getOption() != AbstractOption.field_216694_a) continue;
                    OptionsRowList.Row newRow = OptionsRowList.Row.func_214384_a((GameSettings)screen.getMinecraft().field_71474_y, (int)screen.field_230708_k_, (AbstractOption)BIOME_BLEND_RADIUS);
                    rowListEntries.set(index, newRow);
                    replacedOption = true;
                }
                if (replacedOption) continue block0;
            }
        }
    }

    public static Double biomeBlendRadiusOptionGetValue(GameSettings settings) {
        double result = settings.field_205217_U;
        return result;
    }

    public static void biomeBlendRadiusOptionSetValue(GameSettings settings, Double optionValues) {
        int currentValue = (int)optionValues.doubleValue();
        int newSetting = MathHelper.func_76125_a((int)currentValue, (int)0, (int)14);
        if (settings.field_205217_U != newSetting) {
            settings.field_205217_U = newSetting;
            BiomeColor.clearBlendCaches();
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    public static ITextComponent biomeBlendRadiusOptionGetDisplayText(GameSettings settings, SliderPercentageOption optionValues) {
        int currentValue = (int)optionValues.func_216729_a(settings);
        int blendDiameter = 2 * currentValue + 1;
        TranslationTextComponent result = new TranslationTextComponent("options.generic_value", new Object[]{new TranslationTextComponent("options.biomeBlendRadius"), new TranslationTextComponent("options.biomeBlendRadius." + blendDiameter)});
        return result;
    }

    public static void overwriteOptifineGUIBlendRadiusOption() {
        boolean success;
        block7: {
            success = false;
            try {
                Class<?> guiDetailSettingsOFClass = Class.forName("net.optifine.gui.GuiDetailSettingsOF");
                try {
                    Field enumOptionsField = guiDetailSettingsOFClass.getDeclaredField("enumOptions");
                    enumOptionsField.setAccessible(true);
                    AbstractOption[] enumOptions = (AbstractOption[])enumOptionsField.get(null);
                    boolean found = false;
                    for (int index = 0; index < enumOptions.length; ++index) {
                        AbstractOption option = enumOptions[index];
                        if (option != AbstractOption.field_216694_a) continue;
                        enumOptions[index] = BIOME_BLEND_RADIUS;
                        found = true;
                        break;
                    }
                    if (found) {
                        success = true;
                        break block7;
                    }
                    BetterBiomeBlend.LOGGER.warn("Optifine GUI option was not found.");
                }
                catch (Exception e) {
                    BetterBiomeBlend.LOGGER.warn((Object)e);
                }
            }
            catch (ClassNotFoundException e) {
                BetterBiomeBlend.LOGGER.info("Otifine does not seem to be loaded, so no need to overwrite anything.");
            }
        }
        if (success) {
            BetterBiomeBlend.LOGGER.info("Optifine GUI option was successfully replaced.");
        }
    }
}

