/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BiomeColor;
import fionathemortal.betterbiomeblend.ColorChunk;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ColorChunkCache {
    public final Lock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<ColorChunk> hash;
    public final Stack<ColorChunk> freeStack;
    public int invalidationCounter;

    public static long getChunkKey(int chunkX, int chunkZ, int colorType) {
        long result = ((long)chunkZ & Integer.MAX_VALUE) << 31 | (long)chunkX & Integer.MAX_VALUE | (long)colorType << 62;
        return result;
    }

    public ColorChunkCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.freeStack = new Stack();
        for (int index = 0; index < count; ++index) {
            this.freeStack.add(new ColorChunk());
        }
    }

    public void releaseChunkWithoutLock(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.freeStack.push(chunk);
        }
    }

    public void releaseChunk(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.freeStack.push(chunk);
            this.lock.unlock();
        }
    }

    public void invalidateChunk(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int colorType = 0; colorType <= 2; ++colorType) {
            long key = ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType);
            ColorChunk chunk = (ColorChunk)this.hash.remove(key);
            if (chunk == null) continue;
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.lock.unlock();
    }

    public void invalidateNeighbourhood(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int colorType = 0; colorType <= 2; ++colorType) {
                    long key = ColorChunkCache.getChunkKey(chunkX + x, chunkZ + z, colorType);
                    ColorChunk chunk = (ColorChunk)this.hash.remove(key);
                    if (chunk == null) continue;
                    this.releaseChunkWithoutLock(chunk);
                    chunk.markAsInvalid();
                }
            }
        }
        this.lock.unlock();
    }

    public void invalidateSmallNeighbourhood(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int chunkIndex = 0; chunkIndex < 9; ++chunkIndex) {
            if (chunkIndex == 4) continue;
            int offsetX = BiomeColor.getNeighbourOffsetX(chunkIndex);
            int offsetZ = BiomeColor.getNeighbourOffsetZ(chunkIndex);
            for (int colorType = 0; colorType <= 2; ++colorType) {
                long key = ColorChunkCache.getChunkKey(chunkX + offsetX, chunkZ + offsetZ, colorType);
                ColorChunk chunk = (ColorChunk)this.hash.get(key);
                if (chunk == null) continue;
                int minX = BiomeColor.getNeighbourRectMinX(chunkIndex, 2);
                int minZ = BiomeColor.getNeighbourRectMinZ(chunkIndex, 2);
                int maxX = BiomeColor.getNeighbourRectMaxX(chunkIndex, 2);
                int maxZ = BiomeColor.getNeighbourRectMaxZ(chunkIndex, 2);
                for (int z1 = minZ; z1 < maxZ; ++z1) {
                    for (int x1 = minX; x1 < maxX; ++x1) {
                        chunk.data[3 * (16 * z1 + x1) + 0] = -1;
                        chunk.data[3 * (16 * z1 + x1) + 1] = -1;
                        chunk.data[3 * (16 * z1 + x1) + 2] = -1;
                    }
                }
            }
        }
        for (int colorType = 0; colorType <= 2; ++colorType) {
            long key = ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType);
            ColorChunk chunk = (ColorChunk)this.hash.remove(key);
            if (chunk == null) continue;
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.lock.unlock();
    }

    public void invalidateAll() {
        this.lock.lock();
        ++this.invalidationCounter;
        for (ColorChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.lock.unlock();
    }

    public ColorChunk getChunk(int chunkX, int chunkZ, int colorType) {
        long key = ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        ColorChunk result = (ColorChunk)this.hash.getAndMoveToFirst(key);
        if (result != null) {
            result.acquire();
        }
        this.lock.unlock();
        return result;
    }

    public void putChunk(ColorChunk chunk) {
        chunk.acquire();
        this.lock.lock();
        ColorChunk prev = (ColorChunk)this.hash.getAndMoveToFirst(chunk.key);
        if (prev != null) {
            ColorChunk olderChunk;
            if (chunk.invalidationCounter >= prev.invalidationCounter) {
                olderChunk = prev;
                this.hash.put(chunk.key, (Object)chunk);
            } else {
                olderChunk = chunk;
            }
            this.releaseChunkWithoutLock(olderChunk);
            olderChunk.markAsInvalid();
        } else {
            this.hash.putAndMoveToFirst(chunk.key, (Object)chunk);
        }
        this.lock.unlock();
    }

    public ColorChunk newChunk(int chunkX, int chunkZ, int colorType) {
        ColorChunk result;
        long key = ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        if (!this.freeStack.empty()) {
            result = this.freeStack.pop();
        } else {
            while (true) {
                long lastKey = this.hash.lastLongKey();
                result = (ColorChunk)this.hash.removeLast();
                if (result.getReferenceCount() == 1) {
                    result.release();
                    break;
                }
                this.hash.putAndMoveToFirst(lastKey, (Object)result);
            }
        }
        this.lock.unlock();
        result.key = key;
        result.invalidationCounter = this.invalidationCounter;
        result.acquire();
        return result;
    }

    public ColorChunk getOrDefaultInitializeChunk(int chunkX, int chunkZ, int colorType) {
        long key = ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        ColorChunk result = (ColorChunk)this.hash.getAndMoveToFirst(key);
        if (result == null) {
            if (!this.freeStack.empty()) {
                result = this.freeStack.pop();
            } else {
                while (true) {
                    long lastKey = this.hash.lastLongKey();
                    result = (ColorChunk)this.hash.removeLast();
                    if (result.getReferenceCount() == 1) {
                        result.release();
                        break;
                    }
                    this.hash.putAndMoveToFirst(lastKey, (Object)result);
                }
            }
            result.key = key;
            result.invalidationCounter = this.invalidationCounter;
            Arrays.fill(result.data, (byte)-1);
            result.acquire();
            ColorChunk prev = (ColorChunk)this.hash.putAndMoveToFirst(result.key, (Object)result);
            if (prev != null) {
                this.releaseChunkWithoutLock(prev);
                prev.markAsInvalid();
            }
        }
        result.acquire();
        this.lock.unlock();
        return result;
    }
}

