/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.BiomeColor;
import fionathemortal.betterbiomeblend.ColorChunk;
import fionathemortal.betterbiomeblend.ColorChunkCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.client.renderer.color.ColorCache;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld
extends World {
    @Shadow
    private final Object2ObjectArrayMap<ColorResolver, ColorCache> field_228315_B_ = new Object2ObjectArrayMap();
    private final ColorChunkCache colorCache = new ColorChunkCache(2048);
    private final ColorChunkCache rawColorCache = new ColorChunkCache(512);
    private final ThreadLocal<ColorChunk> threadLocalWaterChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    private final ThreadLocal<ColorChunk> threadLocalGrassChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    private final ThreadLocal<ColorChunk> threadLocalFoliageChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });

    protected MixinClientWorld(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Inject(method={"clearColorCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.colorCache.invalidateAll();
        this.rawColorCache.invalidateAll();
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(int chunkX, int chunkZ, CallbackInfo ci) {
        this.colorCache.invalidateNeighbourhood(chunkX, chunkZ);
        this.rawColorCache.invalidateSmallNeighbourhood(chunkX, chunkZ);
    }

    @Overwrite
    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        ThreadLocal<ColorChunk> threadLocalChunk;
        int colorType;
        if (colorResolverIn == BiomeColors.field_180291_a) {
            colorType = 0;
            threadLocalChunk = this.threadLocalGrassChunk;
        } else if (colorResolverIn == BiomeColors.field_180290_c) {
            colorType = 1;
            threadLocalChunk = this.threadLocalWaterChunk;
        } else {
            colorType = 2;
            threadLocalChunk = this.threadLocalFoliageChunk;
        }
        int x = blockPosIn.func_177958_n();
        int z = blockPosIn.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocalChunk, chunkX, chunkZ, colorType);
        if (chunk == null) {
            chunk = BiomeColor.getBlendedColorChunk(this, colorType, chunkX, chunkZ, this.colorCache, this.rawColorCache, colorResolverIn);
            BiomeColor.setThreadLocalChunk(threadLocalChunk, chunk, this.colorCache);
        }
        int result = chunk.getColor(x, z);
        return result;
    }
}

