/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.BiomeColor;
import fionathemortal.betterbiomeblend.ColorChunk;
import fionathemortal.betterbiomeblend.ColorChunkCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.class_1163;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_3695;
import net.minecraft.class_4700;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.world.level.ColorResolver;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_638.class})
public abstract class MixinClientWorld
extends class_1937 {
    @Shadow
    private Object2ObjectArrayMap<ColorResolver, class_4700> field_21527 = new Object2ObjectArrayMap();
    private final ColorChunkCache blendColorCache = new ColorChunkCache(2048);
    private final ColorChunkCache rawColorCache = new ColorChunkCache(512);
    private final ThreadLocal<ColorChunk> threadLocalWaterChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    private final ThreadLocal<ColorChunk> threadLocalGrassChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });
    private final ThreadLocal<ColorChunk> threadLocalFoliageChunk = ThreadLocal.withInitial(() -> {
        ColorChunk chunk = new ColorChunk();
        chunk.acquire();
        return chunk;
    });

    protected MixinClientWorld(class_5269 worldInfo, class_5321<class_1937> dimension, class_2874 dimensionType, Supplier<class_3695> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Inject(method={"reloadColor"}, at={@At(value="HEAD")})
    public void onReloadColor(CallbackInfo ci) {
        this.blendColorCache.invalidateAll();
        this.rawColorCache.invalidateAll();
    }

    @Inject(method={"resetChunkColor"}, at={@At(value="HEAD")})
    public void onResetChunkColor(class_1923 position, CallbackInfo ci) {
        this.blendColorCache.invalidateNeighbourhood(position.field_9181, position.field_9180);
        this.rawColorCache.invalidateSmallNeighbourhood(position.field_9181, position.field_9180);
    }

    @Overwrite
    public int method_23752(class_2338 blockPosIn, ColorResolver colorResolverIn) {
        ThreadLocal<ColorChunk> threadLocalChunk;
        int colorType;
        if (colorResolverIn == class_1163.field_5665) {
            colorType = 0;
            threadLocalChunk = this.threadLocalGrassChunk;
        } else if (colorResolverIn == class_1163.field_5666) {
            colorType = 1;
            threadLocalChunk = this.threadLocalWaterChunk;
        } else {
            colorType = 2;
            threadLocalChunk = this.threadLocalFoliageChunk;
        }
        int x = blockPosIn.method_10263();
        int z = blockPosIn.method_10260();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocalChunk, chunkX, chunkZ, colorType);
        if (chunk == null) {
            chunk = BiomeColor.getBlendedColorChunk(this, colorType, chunkX, chunkZ, this.blendColorCache, this.rawColorCache, colorResolverIn);
            BiomeColor.setThreadLocalChunk(threadLocalChunk, chunk, this.blendColorCache);
        }
        int result = chunk.getColor(x, z);
        return result;
    }
}

