/*
 * Decompiled with CFR 0.152.
 */
package amymialee.blackpowder.guns;

import amymialee.blackpowder.BlackPowder;
import amymialee.blackpowder.items.BulletItem;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1761;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3745;
import org.jetbrains.annotations.Nullable;

public class GunItem
extends class_1764 {
    public int bulletCount;
    public float inaccuracy;
    public int chargeTime;
    public int quickChargeChange;
    public class_3414 START;
    public class_3414 MIDDLE;
    public class_3414 END;
    public class_3414 SHOOT;
    public class_3414 HIT;
    public float velocity;
    public class_1792 ammo;
    public int damage;
    public int piercing;
    public String damageType;
    private boolean charged = false;
    private boolean loaded = false;

    public GunItem(int bulletCount, float inaccuracy, int chargeTime, int quickChargeChange, class_3414[] soundEvents, float velocity, class_1792 ammo, int damage, int piercing, String damageType) {
        super((class_1792.class_1793)new FabricItemSettings().group(class_1761.field_7916).maxCount(1).fireproof());
        this.bulletCount = bulletCount;
        this.inaccuracy = inaccuracy;
        this.chargeTime = chargeTime;
        this.quickChargeChange = quickChargeChange;
        this.START = soundEvents[0];
        this.MIDDLE = soundEvents[1];
        this.END = soundEvents[2];
        this.SHOOT = soundEvents[3];
        this.HIT = soundEvents[4];
        this.velocity = velocity;
        this.ammo = ammo;
        this.damage = damage;
        this.piercing = piercing;
        this.damageType = damageType;
    }

    public static int getChargeTime(GunItem item) {
        return item.chargeTime;
    }

    public static int getQuickChargeChange(GunItem item) {
        return item.quickChargeChange;
    }

    public static int getBulletCount(GunItem item) {
        return item.bulletCount;
    }

    public static class_3414 getShootSound(GunItem item) {
        return item.SHOOT;
    }

    public static class_3414 getHitSound(GunItem item) {
        return item.HIT;
    }

    public Predicate<class_1799> method_20310() {
        return this.method_19268().or(stack -> stack.method_7909() == class_1802.field_8107);
    }

    public Predicate<class_1799> method_19268() {
        return stack -> stack.method_7909() == this.ammo;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (GunItem.isCharged(itemStack)) {
            GunItem.shootAll(world, (class_1309)user, itemStack, this.getSpeed(), this.inaccuracy);
            GunItem.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            if (!GunItem.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack) - remainingUseTicks;
        float f = GunItem.getPullProgress(i, stack);
        if (f >= 1.0f && !GunItem.isCharged(stack) && GunItem.loadProjectiles(user, stack)) {
            GunItem.setCharged(stack, true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_8465(null, user.method_23317(), user.method_23318(), user.method_23321(), this.END, soundCategory, 1.0f, 1.0f / (field_8005.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean loadProjectiles(class_1309 shooter, class_1799 projectile) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)projectile);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).field_7503.field_7477;
        class_1799 itemStack = shooter.method_18808(projectile);
        class_1799 itemStack2 = itemStack.method_7972();
        for (int k = 0; k < j; ++k) {
            if (bl) {
                itemStack = new class_1799((class_1935)((GunItem)projectile.method_7909()).ammo);
            }
            if (k > 0) {
                itemStack = itemStack2.method_7972();
            }
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)((GunItem)projectile.method_7909()).ammo);
                itemStack2 = itemStack.method_7972();
            }
            if (GunItem.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack2;
        boolean bl;
        if (projectile.method_7960()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.method_7909() instanceof BulletItem;
        if (!(bl || creative || simulated)) {
            itemStack2 = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).field_7514.method_7378(projectile);
            }
        } else {
            itemStack2 = projectile.method_7972();
        }
        GunItem.putProjectile(crossbow, itemStack2);
        return true;
    }

    public static boolean isCharged(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10577("Charged");
    }

    public static void setCharged(class_1799 stack, boolean charged) {
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10556("Charged", charged);
    }

    private static void putProjectile(class_1799 gun, class_1799 projectile) {
        class_2487 compoundTag = gun.method_7948();
        class_2499 listTag2 = compoundTag.method_10573("ChargedProjectiles", 9) ? compoundTag.method_10554("ChargedProjectiles", 10) : new class_2499();
        class_2487 compoundTag2 = new class_2487();
        projectile.method_7953(compoundTag2);
        listTag2.add((Object)compoundTag2);
        compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag2);
    }

    private static List<class_1799> getProjectiles(class_1799 gun) {
        class_2499 listTag;
        ArrayList list = Lists.newArrayList();
        class_2487 compoundTag = gun.method_7969();
        if (compoundTag != null && compoundTag.method_10573("ChargedProjectiles", 9) && (listTag = compoundTag.method_10554("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                list.add(class_1799.method_7915((class_2487)compoundTag2));
            }
        }
        return list;
    }

    private static void clearProjectiles(class_1799 gun) {
        class_2487 compoundTag = gun.method_7969();
        if (compoundTag != null) {
            class_2499 listTag = compoundTag.method_10554("ChargedProjectiles", 9);
            listTag.clear();
            compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag);
        }
    }

    private static void shoot(class_1937 world, class_1309 shooter, class_1799 gun, class_1799 projectile, float soundPitch, float speed, float divergence, float simulated) {
        if (!world.field_9236) {
            for (int b = 0; b < GunItem.getBulletCount((GunItem)gun.method_7909()); ++b) {
                class_1665 projectileEntity2 = GunItem.createBullet(world, shooter, gun, projectile);
                if (projectileEntity2 == null) continue;
                projectileEntity2.field_7572 = class_1665.class_1666.field_7594;
                if (shooter instanceof class_3745) {
                    class_3745 crossbowUser = (class_3745)shooter;
                    crossbowUser.method_18811(crossbowUser.method_5968(), gun, (class_1676)projectileEntity2, simulated);
                } else {
                    class_243 vec3d = shooter.method_18864(1.0f);
                    class_1158 quaternion = new class_1158(new class_1160(vec3d), simulated, true);
                    class_243 vec3d2 = shooter.method_5828(1.0f);
                    class_1160 vector3f = new class_1160(vec3d2);
                    vector3f.method_19262(quaternion);
                    projectileEntity2.method_7485((double)vector3f.method_4943(), (double)vector3f.method_4945(), (double)vector3f.method_4947(), speed, divergence);
                }
                world.method_8649((class_1297)projectileEntity2);
            }
            world.method_8465(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), GunItem.getShootSound((GunItem)gun.method_7909()), class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    private static class_1665 createBullet(class_1937 world, class_1309 entity, class_1799 gun, class_1799 bullet) {
        class_1665 persistentProjectileEntity = null;
        if (bullet.method_7909() instanceof BulletItem) {
            persistentProjectileEntity = ((BulletItem)bullet.method_7909()).createBullet(world, bullet, entity, ((GunItem)gun.method_7909()).damage, 0, ((GunItem)gun.method_7909()).HIT, ((GunItem)gun.method_7909()).damageType);
        }
        if (entity instanceof class_1657 && persistentProjectileEntity != null) {
            persistentProjectileEntity.method_7439(true);
        }
        if (persistentProjectileEntity != null) {
            persistentProjectileEntity.method_7444(GunItem.getHitSound((GunItem)gun.method_7909()));
            persistentProjectileEntity.method_7442(true);
            int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)gun) + ((GunItem)gun.method_7909()).piercing;
            if (i > 0) {
                persistentProjectileEntity.method_7451((byte)i);
            }
            persistentProjectileEntity.method_7438(2.0);
        }
        return persistentProjectileEntity;
    }

    public static void shootAll(class_1937 world, class_1309 entity, class_1799 stack, float speed, float divergence) {
        List<class_1799> list = GunItem.getProjectiles(stack);
        float[] fs = GunItem.getSoundPitches(entity.method_6051());
        if (!entity.method_5770().field_9236) {
            ((class_3218)entity.method_5770()).method_14199((class_2394)class_2398.field_11203, entity.method_23317(), entity.method_23318() + 1.4, entity.method_23321(), 24, 0.2, 0.2, 0.2, 0.01);
        }
        for (int i = 0; i < list.size(); ++i) {
            class_1799 itemStack = list.get(i);
            if (itemStack.method_7960()) continue;
            if (i == 0) {
                GunItem.shoot(world, entity, stack, itemStack, fs[i], speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                GunItem.shoot(world, entity, stack, itemStack, fs[i], speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            GunItem.shoot(world, entity, stack, itemStack, fs[i], speed, divergence, 10.0f);
        }
        GunItem.postShoot(world, entity, stack);
        Random random = new Random();
        if (BlackPowder.config.funMode && random.nextInt(1001) == 1000) {
            List nearbyEntities = world.method_8335(null, new class_238(entity.method_23317() - 1000.0, entity.method_23318() - 1000.0, entity.method_23321() - 1000.0, entity.method_23317() + 1000.0, entity.method_23318() + 1000.0, entity.method_23321() + 1000.0));
            for (class_1297 entity2 : nearbyEntities) {
                if (!(entity2 instanceof class_1657)) continue;
                entity2.method_5643(class_1282.method_5512((class_1309)entity), 5000.0f);
            }
        }
    }

    private static float[] getSoundPitches(Random random) {
        boolean bl = random.nextBoolean();
        return new float[]{1.0f, GunItem.getSoundPitch(bl), GunItem.getSoundPitch(!bl)};
    }

    private static float getSoundPitch(boolean flag) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (field_8005.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            if (!world.field_9236) {
                class_174.field_1196.method_9115(serverPlayerEntity, stack);
            }
            serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
        GunItem.clearProjectiles(stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            class_3414 soundEvent = this.getQuickChargeSound();
            class_3414 soundEvent2 = this.MIDDLE;
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)GunItem.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.method_8465(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.method_8465(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return GunItem.getPullTime(stack) + 3;
    }

    public static int getPullTime(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return i == 0 ? GunItem.getChargeTime((GunItem)stack.method_7909()) : GunItem.getChargeTime((GunItem)stack.method_7909()) - GunItem.getQuickChargeChange((GunItem)stack.method_7909()) * i;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    private class_3414 getQuickChargeSound() {
        return this.START;
    }

    private static float getPullProgress(int useTicks, class_1799 stack) {
        float f = (float)useTicks / (float)GunItem.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<class_1799> list = GunItem.getProjectiles(stack);
        if (GunItem.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltip.add((class_2561)new class_2588("item.minecraft.crossbow.projectile").method_27693(" ").method_10852(itemStack.method_7954()));
            if (context.method_8035() && itemStack.method_7909() == class_1802.field_8639) {
                ArrayList list2 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, new class_2585("  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    private float getSpeed() {
        return this.velocity;
    }

    public int method_24792() {
        return 8;
    }

    public boolean method_7838(class_1799 stack) {
        return stack.method_7909() instanceof GunItem;
    }
}

