/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameTileEntity;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ChestBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(ChestFrameTileEntity.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null && (model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location)) != null) {
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(ChestFrameTileEntity.MIMIC);
        int tex = (Integer)extraData.getData(ChestFrameTileEntity.TEXTURE);
        if (mimic != null && state != null) {
            List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
            ArrayList<TextureAtlasSprite> designTextureList = new ArrayList<TextureAtlasSprite>(TextureHelper.getMetalTextures());
            if (textureList.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            designTextureList.add((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/shulker_box")));
            TextureAtlasSprite chestFront = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chest_front"));
            TextureAtlasSprite chestSide = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chest_side"));
            TextureAtlasSprite chestTop = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("blockcarpentry", "block/chest_top"));
            if (textureList.size() <= tex) {
                extraData.setData(ChestFrameTileEntity.TEXTURE, (Object)0);
                tex = 0;
            }
            TextureAtlasSprite texture = textureList.get(tex);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int design = (Integer)extraData.getData(ChestFrameTileEntity.DESIGN);
            int desTex = (Integer)extraData.getData(ChestFrameTileEntity.DESIGN_TEXTURE);
            TextureAtlasSprite designTexture = (TextureAtlasSprite)designTextureList.get(desTex);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (design == 0) {
                return new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex));
            }
            if (design == 1 || design == 2) {
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.875f, texture, tintIndex));
            }
            if (design == 3) {
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.125f, 0.875f, 0.125f, 0.875f, designTexture, tintIndex));
            }
            if (design == 1 || design == 3 || design == 4) {
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.0f, 0.125f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.0f, 0.125f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.875f, 1.0f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.0f, 0.125f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.875f, 1.0f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.125f, 0.875f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.125f, 0.875f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.0f, 0.125f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.875f, 1.0f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.125f, 0.875f, texture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.125f, 0.875f, texture, tintIndex));
            }
            if (design == 2) {
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.0f, 0.125f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.0f, 0.125f, 0.875f, 1.0f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.0f, 0.125f, 0.125f, 0.875f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.0f, 0.125f, 0.125f, 0.875f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.0f, 0.125f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.125f, 0.875f, 0.875f, 1.0f, 0.875f, 1.0f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.875f, 1.0f, 0.125f, 0.875f, designTexture, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.875f, 1.0f, 0.125f, 0.875f, designTexture, tintIndex));
            }
            if (design == 4) {
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.125f, 0.0625f, 0.9375f, chestTop, tintIndex));
                quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.875f, 0.9375f, 0.0625f, 0.9375f, chestTop, tintIndex));
                int[] ulow = new int[]{7, 7, 7, 9, 8, 9};
                int[] uhigh = new int[]{9, 9, 8, 7, 9, 7};
                int[] vlow = new int[]{4, 7, 4, 4, 4, 4};
                int[] vhigh = new int[]{5, 8, 8, 8, 8, 8};
                switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestFront, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.5f, 0.75f, 0.0f, 0.0625f, chestFront, tintIndex, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case EAST: {
                        ulow = new int[]{7, 8, 9, 8, 9, 7};
                        uhigh = new int[]{8, 9, 7, 9, 7, 8};
                        vlow = new int[]{6, 4, 4, 4, 4, 4};
                        vhigh = new int[]{4, 6, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestFront, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.5f, 0.75f, 0.4375f, 0.5625f, chestFront, tintIndex, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case SOUTH: {
                        ulow = new int[]{9, 9, 8, 9, 7, 9};
                        uhigh = new int[]{7, 7, 9, 7, 8, 7};
                        vlow = new int[]{4, 8, 4, 4, 4, 4};
                        vhigh = new int[]{5, 7, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestFront, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.4375f, 0.5625f, 0.5f, 0.75f, 0.9375f, 1.0f, chestFront, tintIndex, ulow, uhigh, vlow, vhigh));
                        break;
                    }
                    case WEST: {
                        ulow = new int[]{7, 7, 9, 7, 9, 8};
                        uhigh = new int[]{8, 8, 7, 8, 7, 9};
                        vlow = new int[]{4, 6, 4, 4, 4, 4};
                        vhigh = new int[]{6, 4, 8, 8, 8, 8};
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.125f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.0625f, 0.9375f, 0.875f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestFront, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.875f, 0.9375f, 0.0625f, 0.9375f, 0.0625f, 0.9375f, chestSide, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.5f, 0.75f, 0.4375f, 0.5625f, chestFront, tintIndex, ulow, uhigh, vlow, vhigh));
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

