/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.BedFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class IllusionBedBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(BedFrameTile.MIMIC);
        if (mimic != null && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null && (model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location)) != null) {
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData, IBakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.getData(BedFrameTile.MIMIC);
        if (mimic != null && state != null) {
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int rotation = (Integer)extraData.getData(BedFrameTile.ROTATION);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.3125f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
            TextureAtlasSprite pillow = TextureHelper.getWoolTextures().get((Integer)extraData.getData(BedFrameTile.PILLOW));
            TextureAtlasSprite blanket = TextureHelper.getWoolTextures().get((Integer)extraData.getData(BedFrameTile.BLANKET));
            Integer design = (Integer)extraData.getData(BedFrameTile.DESIGN);
            if (design == null) {
                return quads;
            }
            List<TextureAtlasSprite> planksList = TextureHelper.getPlanksTextures();
            Integer desTex = (Integer)extraData.getData(BedFrameTile.DESIGN_TEXTURE);
            if (desTex == null || desTex < 0 || desTex > 7) {
                return quads;
            }
            TextureAtlasSprite planks = planksList.get(desTex);
            if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                    case SOUTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, mimic, model, extraData, rand, tintIndex, rotation));
                        quads.addAll(ModelHelper.createSixFaceCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                    }
                }
            }
            if (design == 0 || design == 1) {
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                        }
                    }
                }
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.5f, 1.0f, pillow, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.5f, pillow, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, tintIndex));
                        }
                    }
                }
            }
            if (design == 1) {
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                }
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                }
            }
            if (design == 2) {
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.0f, 0.875f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.125f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                }
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.5f, 0.875f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 0.5f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.125f, 0.5f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 0.875f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                }
            }
            if (design == 3) {
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.0f, 0.875f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, planks, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.125f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, planks, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, tintIndex));
                        }
                    }
                }
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.5f, 0.875f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, planks, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 0.5f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.125f, 0.5f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, planks, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 0.875f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, tintIndex));
                        }
                    }
                }
            }
            if (design == 4) {
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, -0.5f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, -0.5f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, -0.5f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, -0.5625f, -0.5f, blanket, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.5f, 1.5625f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 1.0f, 1.5f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 1.0f, 1.5f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 1.0f, 1.5f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 1.5f, 1.5625f, blanket, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.5625f, -0.5f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, tintIndex));
                        }
                    }
                }
                if (state.func_177229_b(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.5625f, 1.0f, pillow, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.4375f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.4375f, pillow, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5625f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, tintIndex));
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

