/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.FrameBlock;
import mod.pianomanu.blockcarpentry.block.WallFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallHeight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class WallBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel model;
        ModelResourceLocation location;
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        if (mimic != null && !(mimic.func_177230_c() instanceof FrameBlock) && (location = BlockModelShapes.func_209554_c((BlockState)mimic)) != null && state != null && (model = Minecraft.func_71410_x().func_209506_al().func_174953_a(location)) != null) {
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, IModelData extraData, IBakedModel model) {
        BlockState mimic = (BlockState)extraData.getData(FrameBlockTile.MIMIC);
        Integer design = (Integer)extraData.getData(FrameBlockTile.DESIGN);
        if (side != null) {
            return Collections.emptyList();
        }
        if (mimic != null && state != null) {
            int overlayIndex;
            int index = (Integer)extraData.getData(FrameBlockTile.TEXTURE);
            List<TextureAtlasSprite> texture = TextureHelper.getTextureFromModel(model, extraData, rand);
            if (texture.size() <= index) {
                extraData.setData(FrameBlockTile.TEXTURE, (Object)0);
                index = 0;
            }
            if (texture.size() == 0) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.blockcarpentry.block_not_available"), true);
                }
                return Collections.emptyList();
            }
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (((Boolean)state.func_177229_b((Property)WallFrameBlock.field_176256_a)).booleanValue()) {
                quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 1.0f, 0.25f, 0.75f, texture.get(index), tintIndex));
            } else {
                quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.875f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
            }
            if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL && state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL && state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 1.0f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
            } else if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.NONE && state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.NONE || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.NONE && state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.NONE) {
                quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.875f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
            }
            float height_north = 1.0f;
            float height_east = 1.0f;
            float height_south = 1.0f;
            float height_west = 1.0f;
            if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW) {
                height_north = 0.875f;
            }
            if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW) {
                height_east = 0.875f;
            }
            if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW) {
                height_south = 0.875f;
            }
            if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW) {
                height_west = 0.875f;
            }
            if (design == 0) {
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_north, 0.0f, 0.3125f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 1.0f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
            }
            if (design == 1) {
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.25f, 0.0f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_north, 0.0f, 0.3125f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, 0.25f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.625f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.25f, 0.6875f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_south, 0.6875f, 1.0f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, 0.25f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.625f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
            }
            if (design == 2) {
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.1875f, 0.4375f, 0.0f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_north, 0.0f, 0.3125f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.1875f, 0.4375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.625f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.1875f, 0.4375f, 0.6875f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, height_south, 0.6875f, 1.0f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.1875f, 0.4375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.625f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
            }
            if (design == 3) {
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_north, 0.0f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.1875f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.0f, 0.0625f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.5625f, 0.1875f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.4375f, 0.5f, 0.125f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.4375f, 0.0625f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.375f, 0.0f, 0.25f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_north, 0.25f, 0.3125f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.75f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.8125f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.8125f, 0.5f, 0.5625f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.875f, 0.4375f, 0.5f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 0.9375f, 0.375f, 0.4375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.75f, 1.0f, 0.0f, 0.375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.75f, 0.0f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_south, 0.75f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.9375f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.6875f, 0.75f, 0.75f, 0.8125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.5625f, 0.75f, 0.8125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.4375f, 0.5f, 0.75f, 0.875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.375f, 0.4375f, 0.75f, 0.9375f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.375f, 0.75f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 0.75f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.75f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.25f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.6875f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.25f, 0.5f, 0.5625f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.125f, 0.25f, 0.4375f, 0.5f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.25f, 0.375f, 0.4375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.25f, 0.0f, 0.375f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
            }
            if (design == 4) {
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_north, 0.0f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, 0.75f, 0.0625f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.625f, 0.1875f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.125f, 0.5f, 0.0625f, 0.3125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.125f, 0.0f, 0.3125f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.75f, height_east, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.9375f, 0.625f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.8125f, 0.5f, 0.625f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 0.9375f, 0.125f, 0.5f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.6875f, 1.0f, 0.0f, 0.125f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.75f, height_south, 0.6875f, 1.0f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.625f, 0.75f, 0.6875f, 0.9375f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.5f, 0.625f, 0.6875f, 0.8125f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.125f, 0.5f, 0.6875f, 0.9375f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.3125f, 0.6875f, 0.0f, 0.125f, 0.6875f, 1.0f, texture.get(index), tintIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.75f, height_west, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.3125f, 0.625f, 0.75f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.1875f, 0.3125f, 0.5f, 0.625f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0625f, 0.3125f, 0.125f, 0.5f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.3125f, 0.0f, 0.125f, 0.3125f, 0.6875f, texture.get(index), tintIndex));
                }
            }
            if ((overlayIndex = ((Integer)extraData.getData(FrameBlockTile.OVERLAY)).intValue()) != 0) {
                if (((Boolean)state.func_177229_b((Property)WallFrameBlock.field_176256_a)).booleanValue() && state.func_177229_b((Property)WallFrameBlock.field_235613_c_) != WallHeight.TALL && state.func_177229_b((Property)WallFrameBlock.field_235612_b_) != WallHeight.TALL && state.func_177229_b((Property)WallFrameBlock.field_235614_d_) != WallHeight.TALL && state.func_177229_b((Property)WallFrameBlock.field_235615_e_) != WallHeight.TALL) {
                    quads.addAll(ModelHelper.createCuboid(0.25f, 0.75f, 0.0f, 1.0f, 0.25f, 0.75f, texture.get(index), tintIndex));
                    quads.addAll(ModelHelper.createOverlay(0.25f, 0.75f, 0.0f, 1.0f, 0.25f, 0.75f, overlayIndex));
                } else if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW || state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, 0.875f, 0.3125f, 0.6875f, overlayIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235613_c_) == WallHeight.LOW) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, height_north, 0.0f, 0.3125f, overlayIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235612_b_) == WallHeight.LOW) {
                    quads.addAll(ModelHelper.createOverlay(0.6875f, 1.0f, 0.0f, height_east, 0.3125f, 0.6875f, overlayIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235614_d_) == WallHeight.LOW) {
                    quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.0f, height_south, 0.6875f, 1.0f, overlayIndex));
                }
                if (state.func_177229_b((Property)WallFrameBlock.field_235615_e_) == WallHeight.LOW) {
                    quads.addAll(ModelHelper.createOverlay(0.0f, 0.3125f, 0.0f, height_west, 0.3125f, 0.6875f, overlayIndex));
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getTexture();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

