/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels.helper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class DoorKnobBakedModel {
    private static void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
        builder.setApplyDiffuseLighting(true);
    }

    private static BakedQuad createSquareQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, int flag) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 7.0f;
        float uh = 9.0f;
        float vl = 7.0f;
        float vh = 9.0f;
        DoorKnobBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x4Quad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, int flag) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 4.0f;
        float vl = 0.0f;
        float vh = 1.0f;
        if (flag == 3) {
            uh = 5.0f;
            vh = 1.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 5.0f;
        } else if (flag == 2) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            uh = 1.0f;
            vh = 5.0f;
        }
        DoorKnobBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static BakedQuad create1x5Quad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, int flag) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        builder.setApplyDiffuseLighting(true);
        float ul = 0.0f;
        float uh = 1.0f;
        float vl = 0.0f;
        float vh = 5.0f;
        if (flag == 3) {
            vh = 4.0f;
        } else if (flag == 1) {
            uh = 4.0f;
            vh = 1.0f;
        } else if (flag == 0) {
            vh = 4.0f;
            uh = 5.0f;
        }
        DoorKnobBakedModel.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, ul, vl, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, ul, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uh, vh, sprite, 1.0f, 1.0f, 1.0f);
        DoorKnobBakedModel.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uh, vl, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    public static List<BakedQuad> createDoorKnob(float xl, float xh, float yl, float yh, float zl, float zh, int flag, int design_texture) {
        TextureAtlasSprite texture = design_texture == 0 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/iron_block")) : (design_texture == 1 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/obsidian")) : (design_texture == 2 ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/stone")) : (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("minecraft", "block/gold_block"))));
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3d NWU = DoorKnobBakedModel.v(xl, yh, zl);
        Vector3d NEU = DoorKnobBakedModel.v(xl, yh, zh);
        Vector3d NWD = DoorKnobBakedModel.v(xl, yl, zl);
        Vector3d NED = DoorKnobBakedModel.v(xl, yl, zh);
        Vector3d SWU = DoorKnobBakedModel.v(xh, yh, zl);
        Vector3d SEU = DoorKnobBakedModel.v(xh, yh, zh);
        Vector3d SWD = DoorKnobBakedModel.v(xh, yl, zl);
        Vector3d SED = DoorKnobBakedModel.v(xh, yl, zh);
        quads.add(DoorKnobBakedModel.createSquareQuad(NWU, NEU, SEU, SWU, texture, flag));
        quads.add(DoorKnobBakedModel.createSquareQuad(SWD, SED, NED, NWD, texture, flag));
        quads.add(DoorKnobBakedModel.createSquareQuad(NWD, NWU, SWU, SWD, texture, flag));
        quads.add(DoorKnobBakedModel.createSquareQuad(SED, SEU, NEU, NED, texture, flag));
        quads.add(DoorKnobBakedModel.createSquareQuad(NWD, NED, NEU, NWU, texture, flag));
        quads.add(DoorKnobBakedModel.createSquareQuad(SWU, SEU, SED, SWD, texture, flag));
        return quads;
    }

    private static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }
}

