/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class BedFrameBlock
extends BedBlock {
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;

    public BedFrameBlock(DyeColor colorIn, AbstractBlock.Properties properties) {
        super(colorIn, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONTAINS_BLOCK, LIGHT_LEVEL, PART, OCCUPIED, HORIZONTAL_FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BedFrameTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue() && !item.func_77973_b().func_206844_a((ITag)Tags.Items.DYES) && !item.func_77973_b().getRegistryName().func_110624_b().equals("blockcarpentry") || item.func_190926_b()) {
                if (state.func_177229_b(PART) != BedPart.HEAD && !(state = world.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)))).func_203425_a((Block)this)) {
                    return ActionResultType.CONSUME;
                }
                if (!BedFrameBlock.func_235330_a_((World)world)) {
                    world.func_217377_a(pos, false);
                    BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176734_d());
                    if (world.func_180495_p(blockpos).func_203425_a((Block)this)) {
                        world.func_217377_a(blockpos, false);
                    }
                    world.func_230546_a_((Entity)null, DamageSource.func_233546_a_(), (ExplosionContext)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
                    return ActionResultType.SUCCESS;
                }
                if (((Boolean)state.func_177229_b((Property)OCCUPIED)).booleanValue()) {
                    if (!this.func_226861_a_(world, pos)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
                    }
                    return ActionResultType.SUCCESS;
                }
                player.func_213819_a(pos).ifLeft(p_220173_1_ -> {
                    if (p_220173_1_ != null) {
                        player.func_146105_b(p_220173_1_.func_221259_a(), true);
                    }
                });
                return ActionResultType.SUCCESS;
            }
            if (((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue() && player.func_225608_bj_()) {
                this.dropContainedBlock(world, pos);
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            } else if (item.func_77973_b() instanceof BlockItem) {
                if (Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof BedFrameTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setWoolColor(world, pos, player, hand);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean func_226861_a_(World world, BlockPos pos) {
        List list = world.func_175647_a(VillagerEntity.class, new AxisAlignedBB(pos), LivingEntity::func_70608_bn);
        if (list.isEmpty()) {
            return false;
        }
        ((VillagerEntity)list.get(0)).func_213366_dy();
        return true;
    }

    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof BedFrameTile) {
            BedFrameTile frameTileEntity = (BedFrameTile)tileentity;
            BlockState blockState = frameTileEntity.getMimic();
            if (blockState != null) {
                worldIn.func_217379_c(1010, pos, 0);
                frameTileEntity.clear();
                float f = 0.7f;
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                ItemStack itemstack1 = blockState.func_177230_c().func_199767_j().func_190903_i();
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
            frameTileEntity.clear();
        }
    }

    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BedFrameTile) {
            BedFrameTile frameTileEntity = (BedFrameTile)tileentity;
            frameTileEntity.clear();
            frameTileEntity.setMimic(handBlock);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

