/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.AbstractSixWayFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SixWaySlabFrameBlock
extends AbstractSixWayFrameBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final BooleanProperty CONTAINS_2ND_BLOCK = BCBlockStateProperties.CONTAINS_2ND_BLOCK;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final BooleanProperty DOUBLE_SLAB = BCBlockStateProperties.DOUBLE;
    protected static final VoxelShape BOTTOM = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CUBE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SixWaySlabFrameBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y, DOUBLE_SLAB, CONTAINS_2ND_BLOCK});
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)DOUBLE_SLAB)).booleanValue()) {
            return CUBE;
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return TOP;
            }
        }
        return BOTTOM;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockState = context.func_195991_k().func_180495_p(blockpos);
        if (blockState.func_177230_c() instanceof SixWaySlabFrameBlock) {
            return (BlockState)blockState.func_206870_a((Property)DOUBLE_SLAB, (Comparable)Boolean.valueOf(true));
        }
        if (Objects.requireNonNull(context.func_195999_j()).func_225608_bj_() && ((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue() || !Objects.requireNonNull(context.func_195999_j()).func_225608_bj_() && !((Boolean)BCModConfig.SNEAK_FOR_VERTICAL_SLABS.get()).booleanValue()) {
            if (fluidstate.func_206886_c() == Fluids.field_204546_a) {
                return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206889_d()));
            }
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
        }
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        boolean isDouble = (Boolean)state.func_177229_b((Property)DOUBLE_SLAB);
        if (!isDouble && itemstack.func_77973_b() == this.func_199767_j()) {
            if (useContext.func_196012_c()) {
                Direction direction = useContext.func_196000_l();
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case EAST: {
                        return direction == Direction.EAST;
                    }
                    case SOUTH: {
                        return direction == Direction.SOUTH;
                    }
                    case WEST: {
                        return direction == Direction.WEST;
                    }
                    case NORTH: {
                        return direction == Direction.NORTH;
                    }
                    case UP: {
                        return direction == Direction.UP;
                    }
                }
                return direction == Direction.DOWN;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TwoBlocksFrameBlockTile();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockAppearanceHelper.setLightLevel(item, state, world, pos, player, hand);
            BlockAppearanceHelper.setTexture(item, state, world, player, pos);
            BlockAppearanceHelper.setDesign(world, pos, player, item);
            BlockAppearanceHelper.setDesignTexture(world, pos, player, item);
            BlockAppearanceHelper.setOverlay(world, pos, player, item);
            BlockAppearanceHelper.setRotation(world, pos, player, item);
            if (item.func_77973_b() instanceof BlockItem) {
                if (((Boolean)state.func_177229_b((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() && !((Boolean)state.func_177229_b((Property)DOUBLE_SLAB)).booleanValue() || ((Boolean)state.func_177229_b((Property)BCBlockStateProperties.CONTAINS_2ND_BLOCK)).booleanValue() || Objects.requireNonNull(item.func_77973_b().getRegistryName()).func_110624_b().equals("blockcarpentry")) {
                    return ActionResultType.PASS;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                int count = player.func_184586_b(hand).func_190916_E();
                Block heldBlock = ((BlockItem)item.func_77973_b()).func_179223_d();
                if (tileEntity instanceof TwoBlocksFrameBlockTile && !item.func_190926_b() && BlockSavingHelper.isValidBlock(heldBlock) && !((Boolean)state.func_177229_b((Property)CONTAINS_2ND_BLOCK)).booleanValue()) {
                    BlockState handBlockState = ((BlockItem)item.func_77973_b()).func_179223_d().func_176223_P();
                    this.insertBlock((IWorld)world, pos, state, handBlockState);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190920_e(count - 1);
                    }
                    this.checkForVisibility(state, world, pos, (TwoBlocksFrameBlockTile)tileEntity);
                }
            }
            if (player.func_184586_b(hand).func_77973_b() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.func_225608_bj_()) {
                if (!player.func_184812_l_()) {
                    this.dropContainedBlock(world, pos);
                }
                state = (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
                state = (BlockState)state.func_206870_a((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.FALSE);
                world.func_180501_a(pos, state, 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void dropContainedBlock(World worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof TwoBlocksFrameBlockTile) {
            ItemEntity itementity;
            ItemStack itemstack1;
            double d2;
            double d1;
            double d0;
            float f;
            TwoBlocksFrameBlockTile frameTileEntity = (TwoBlocksFrameBlockTile)tileentity;
            BlockState blockState = frameTileEntity.getMimic_1();
            if (blockState != null) {
                worldIn.func_217379_c(1010, pos, 0);
                f = 0.7f;
                d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
                itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
            if ((blockState = frameTileEntity.getMimic_2()) != null) {
                worldIn.func_217379_c(1010, pos, 0);
                f = 0.7f;
                d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                itemstack1 = new ItemStack((IItemProvider)blockState.func_177230_c());
                itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemstack1);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
            frameTileEntity.clear();
        }
    }

    @Override
    public void insertBlock(IWorld worldIn, BlockPos pos, BlockState state, BlockState handBlock) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TwoBlocksFrameBlockTile) {
            if (!((Boolean)state.func_177229_b((Property)CONTAINS_BLOCK)).booleanValue()) {
                TwoBlocksFrameBlockTile frameTileEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameTileEntity.clear();
                frameTileEntity.setMimic_1(handBlock);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
            } else if (((Boolean)state.func_177229_b((Property)DOUBLE_SLAB)).booleanValue()) {
                TwoBlocksFrameBlockTile frameTileEntity = (TwoBlocksFrameBlockTile)tileentity;
                frameTileEntity.setMimic_2(handBlock);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CONTAINS_2ND_BLOCK, (Comparable)Boolean.TRUE), 2);
            }
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropContainedBlock(worldIn, pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_203425_a((Block)this) || super.func_200122_a(state, adjacentBlockState, side);
    }

    private void checkForVisibility(BlockState state, World world, BlockPos pos, TwoBlocksFrameBlockTile tileEntity) {
        for (Direction d : Direction.values()) {
            BlockPos.Mutable mutablePos = pos.func_239590_i_();
            BlockState adjacentBlockState = world.func_180495_p((BlockPos)mutablePos.func_189536_c(d));
            tileEntity.setVisibileSides(d, !adjacentBlockState.func_200132_m() && !this.func_200122_a(state, adjacentBlockState, d));
        }
    }
}

