/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.container;

import java.util.Objects;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChestFrameContainer
extends Container {
    public final ChestFrameTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public ChestFrameContainer(int windowId, PlayerInventory playerInventory, ChestFrameTileEntity tileEntity) {
        super((ContainerType)Registration.CHEST_FRAME_CONTAINER.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        int startX = 8;
        int startY = 18;
        int slotSizePlus2 = 18;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.func_75146_a(new Slot((IInventory)tileEntity, row * 9 + column2, startX + column2 * slotSizePlus2, startY + row * slotSizePlus2));
            }
        }
        int startPlayerInvY = startY * 4 + 13;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + row * 9 + column, startX + column * slotSizePlus2, startPlayerInvY + row * slotSizePlus2));
            }
        }
        int hotbarY = startPlayerInvY + startPlayerInvY / 2 + 16;
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)playerInventory, column, startX + column * slotSizePlus2, hotbarY));
        }
    }

    public ChestFrameContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, ChestFrameContainer.getTileEntity(playerInventory, data));
    }

    private static ChestFrameTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof ChestFrameTileEntity) {
            return (ChestFrameTileEntity)tileAtPos;
        }
        throw new IllegalStateException("TileEntity should be of type ChestFrameTileEntity but is " + tileAtPos);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ChestFrameContainer.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)playerIn, (Block)((Block)Registration.CHEST_FRAMEBLOCK.get())) || ChestFrameContainer.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)playerIn, (Block)((Block)Registration.CHEST_ILLUSIONBLOCK.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemStack = itemStack1.func_77946_l();
            if (index < 27 ? this.func_75135_a(itemStack1, 27, this.field_75151_b.size(), true) : !this.func_75135_a(itemStack1, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }
}

