/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignFrameTile
extends SignTileEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    private static final Logger LOGGER = LogManager.getLogger();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer glassColor = 0;

    public SignFrameTile() {
        System.out.println("new sign tile");
    }

    private static CompoundNBT writeInteger(Integer tag) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("number", tag.toString());
        return compoundnbt;
    }

    private static Integer readInteger(CompoundNBT tag) {
        if (!tag.func_150297_b("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.func_74779_i("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.func_74779_i("number"));
            return 0;
        }
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public Integer getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(Integer colorNumber) {
        this.glassColor = colorNumber;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)SignFrameTile.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)SignFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)SignFrameTile.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.func_218657_a("glass_color", (INBT)SignFrameTile.writeInteger(this.glassColor));
        }
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldGlassColor = this.glassColor;
        CompoundNBT tag = pkt.func_148857_g();
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("texture")) {
            this.texture = SignFrameTile.readInteger(tag.func_74775_l("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design")) {
            this.design = SignFrameTile.readInteger(tag.func_74775_l("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = SignFrameTile.readInteger(tag.func_74775_l("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
        if (tag.func_74764_b("glass_color")) {
            this.glassColor = SignFrameTile.readInteger(tag.func_74775_l("glass_color"));
            if (!Objects.equals(oldGlassColor, this.glassColor)) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MIMIC, (Object)this.mimic).withInitial(TEXTURE, (Object)this.texture).withInitial(DESIGN, (Object)this.design).withInitial(DESIGN_TEXTURE, (Object)this.designTexture).withInitial(GLASS_COLOR, (Object)this.glassColor).build();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("mimic")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("mimic"));
        }
        if (tag.func_74764_b("texture")) {
            this.texture = SignFrameTile.readInteger(tag.func_74775_l("texture"));
        }
        if (tag.func_74764_b("design")) {
            this.design = SignFrameTile.readInteger(tag.func_74775_l("design"));
        }
        if (tag.func_74764_b("design_texture")) {
            this.designTexture = SignFrameTile.readInteger(tag.func_74775_l("design_texture"));
        }
        if (tag.func_74764_b("glass_color")) {
            this.glassColor = SignFrameTile.readInteger(tag.func_74775_l("glass_color"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.mimic != null) {
            tag.func_218657_a("mimic", (INBT)NBTUtil.func_190009_a((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.func_218657_a("texture", (INBT)SignFrameTile.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.func_218657_a("design", (INBT)SignFrameTile.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.func_218657_a("design_texture", (INBT)SignFrameTile.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.func_218657_a("glass_color", (INBT)SignFrameTile.writeInteger(this.glassColor));
        }
        return super.func_189515_b(tag);
    }

    public void clear() {
        this.setMimic(null);
        this.setDesign(0);
        this.setDesign(0);
        this.setDesign(0);
        this.setGlassColor(0);
    }
}

