/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.config.BlurConfig;
import java.util.ArrayList;
import java.util.List;
import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class Blur
implements ClientModInitializer {
    public static final String MODID = "blur";
    public static List<String> defaultExclusions = new ArrayList<String>();
    private long start;
    public int colorFirst;
    public int colorSecond;
    private final ManagedShaderEffect blur = ShaderEffectManager.getInstance().manage(new class_2960("blur", "shaders/post/fade_in_blur.json"), shader -> shader.setUniformValue("Radius", (float)BlurConfig.radius));
    private final Uniform1f blurProgress = this.blur.findUniform1f("Progress");
    public static final Blur INSTANCE = new Blur();
    private boolean doFade = false;

    public void onInitializeClient() {
        defaultExclusions.add(class_408.class.getName());
        defaultExclusions.add("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay$UserInputGuiScreen");
        defaultExclusions.add("ai.arcblroth.projectInception.client.InceptionInterfaceScreen");
        BlurConfig.init((String)MODID, BlurConfig.class);
        ShaderEffectRenderCallback.EVENT.register(deltaTick -> {
            if (this.start > 0L) {
                this.blurProgress.set(this.getProgress());
                this.blur.render(deltaTick);
            }
        });
    }

    public void onScreenChange(class_437 newGui) {
        if (class_310.method_1551().field_1687 != null) {
            boolean excluded;
            boolean bl = excluded = newGui == null || BlurConfig.blurExclusions.contains(newGui.getClass().getName());
            if (!excluded) {
                this.blur.setUniformValue("Radius", (float)BlurConfig.radius);
                this.colorFirst = Integer.parseUnsignedInt(String.valueOf(BlurConfig.gradientStartColor), 16);
                this.colorSecond = Integer.parseUnsignedInt(String.valueOf(BlurConfig.gradientEndColor), 16);
                if (this.doFade) {
                    this.start = System.currentTimeMillis();
                    this.doFade = false;
                }
            } else {
                this.start = -1L;
                this.doFade = true;
            }
        }
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)BlurConfig.fadeTimeMillis, 1.0f);
    }

    public int getBackgroundColor(boolean second) {
        int color = second ? this.colorSecond : this.colorFirst;
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = INSTANCE.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }
}

