/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.config.BlurConfig;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;

@Mod(value="blur")
public class Blur {
    public static final String MODID = "blur";
    public static final Minecraft client = Minecraft.m_91087_();
    public static long start;
    public static String prevScreen;
    public static boolean screenHasBackground;
    private static final ManagedShaderEffect blur;
    private static final Uniform1f blurProgress;
    private static boolean doFade;

    public Blur() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        BlurConfig.init((String)MODID, BlurConfig.class);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> MidnightConfig.getScreen((Screen)screen, (String)MODID)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onShaderEffectRender(ShaderEffectRenderCallback event) {
        if (start > 0L) {
            blurProgress.set(Blur.getProgress(Blur.client.f_91080_ != null));
            blur.render(event.tickDelta);
        }
    }

    public static void onScreenChange(Screen newGui) {
        if (Blur.client.f_91073_ != null) {
            boolean excluded;
            boolean bl = excluded = newGui == null || BlurConfig.blurExclusions.stream().anyMatch(exclusion -> newGui.getClass().getName().contains((CharSequence)exclusion));
            if (!excluded) {
                screenHasBackground = false;
                if (BlurConfig.showScreenTitle) {
                    System.out.println(newGui.getClass().getName());
                }
                blur.setUniformValue("Radius", (float)BlurConfig.radius);
                if (doFade) {
                    start = System.currentTimeMillis();
                    doFade = false;
                }
                prevScreen = newGui.getClass().getName();
            } else if (newGui == null && BlurConfig.fadeOutTimeMillis > 0 && !BlurConfig.blurExclusions.contains(prevScreen)) {
                blur.setUniformValue("Radius", (float)BlurConfig.radius);
                start = System.currentTimeMillis();
                doFade = true;
            } else {
                screenHasBackground = false;
                start = -1L;
                doFade = true;
            }
        }
    }

    private static float getProgress(boolean fadeIn) {
        if (fadeIn) {
            float x = Math.min((float)(System.currentTimeMillis() - start) / (float)BlurConfig.fadeTimeMillis, 1.0f);
            if (BlurConfig.ease) {
                x *= 2.0f - x;
            }
            return x;
        }
        float x = Math.max(1.0f + (float)(start - System.currentTimeMillis()) / (float)BlurConfig.fadeOutTimeMillis, 0.0f);
        if (BlurConfig.ease) {
            x *= 2.0f - x;
        }
        if (x <= 0.0f) {
            start = 0L;
            screenHasBackground = false;
        }
        return x;
    }

    public static int getBackgroundColor(boolean second, boolean fadeIn) {
        int a = second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha;
        Color col = MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        int r = col.getRGB() >> 16 & 0xFF;
        int b = col.getRGB() >> 8 & 0xFF;
        int g = col.getRGB() & 0xFF;
        float prog = Blur.getProgress(fadeIn);
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }

    static {
        blur = ShaderEffectManager.getInstance().manage(new ResourceLocation(MODID, "shaders/post/fade_in_blur.json"), shader -> shader.setUniformValue("Radius", (float)BlurConfig.radius));
        blurProgress = blur.findUniform1f("Progress");
        doFade = false;
    }
}

