/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur.config;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class BlurConfig {
    public static final Pair<BlurConfig, ForgeConfigSpec> CONFIG_SPEC_PAIR = new ForgeConfigSpec.Builder().configure(BlurConfig::new);
    public static final BlurConfig INSTANCE = (BlurConfig)CONFIG_SPEC_PAIR.getKey();
    public final ForgeConfigSpec.ConfigValue<List<String>> blurExclusions;
    public final ForgeConfigSpec.IntValue fadeTimeMillis;
    public final ForgeConfigSpec.IntValue fadeOutTimeMillis;
    public final ForgeConfigSpec.BooleanValue ease;
    public final ForgeConfigSpec.IntValue radius;
    public final ForgeConfigSpec.ConfigValue<String> gradientStart;
    public final ForgeConfigSpec.IntValue gradientStartAlpha;
    public final ForgeConfigSpec.ConfigValue<String> gradientEnd;
    public final ForgeConfigSpec.IntValue gradientEndAlpha;
    public final ForgeConfigSpec.BooleanValue showScreenTitle;

    public BlurConfig(ForgeConfigSpec.Builder builder) {
        builder.translation("blur.midnightconfig.category.screens").push("screens");
        this.blurExclusions = builder.translation("blur.midnightconfig.blurExclusions").define("blurExclusions", () -> Lists.newArrayList((Object[])new String[]{ChatScreen.class.getName(), "com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay$UserInputGuiScreen", "ai.arcblroth.projectInception.client.InceptionInterfaceScreen", "net.optifine.gui.GuiChatOF", "baritone.", "io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen", "net.coderbot.iris.gui.screen.ShaderPackScreen", "eu.midnightdust.midnightcontrols.client.gui.TouchscreenOverlay"}), o -> o != null && List.class.isAssignableFrom(o.getClass()));
        this.showScreenTitle = builder.translation("blur.midnightconfig.showScreenTitle").define("showScreenTitle", false);
        builder.pop();
        builder.translation("blur.midnightconfig.category.style").push("style");
        this.fadeTimeMillis = builder.translation("blur.midnightconfig.fadeTimeMillis").defineInRange("fadeTimeMillis", 200, 0, 5000);
        this.fadeOutTimeMillis = builder.translation("blur.midnightconfig.fadeOutTimeMillis").defineInRange("fadeOutTimeMillis", 200, 0, 5000);
        this.ease = builder.translation("blur.midnightconfig.ease").define("ease", true);
        this.radius = builder.translation("blur.midnightconfig.radius").defineInRange("radius", 8, 0, 100);
        this.gradientStart = builder.translation("blur.midnightconfig.gradientStart").define("gradientStart", (Object)"#000000", BlurConfig::isValidColor);
        this.gradientStartAlpha = builder.translation("blur.midnightconfig.gradientStartAlpha").defineInRange("gradientStartAlpha", 75, 0, 255);
        this.gradientEnd = builder.translation("blur.midnightconfig.gradientEnd").define("gradientEnd", (Object)"#000000", BlurConfig::isValidColor);
        this.gradientEndAlpha = builder.translation("blur.midnightconfig.gradientEndAlpha").defineInRange("gradientEndAlpha", 75, 0, 255);
        builder.pop();
    }

    private static boolean isValidColor(Object val) {
        try {
            Color.decode((String)val);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static {
        ModContainer activeContainer = (ModContainer)ModList.get().getModContainerById("blur").get();
        activeContainer.addConfig(new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_SPEC_PAIR.getValue(), activeContainer));
    }
}

