/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.mob.mobs.lich;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.mob.utils.IEntity;
import net.barribob.boss.mob.utils.IEntityStats;
import net.barribob.maelstrom.static_utilities.MathUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/barribob/boss/mob/mobs/lich/LichUtils;", "", "()V", "hpPercentRageModes", "", "", "getHpPercentRageModes", "()Ljava/util/List;", "textureSize", "", "cappedHeal", "", "iEntity", "Lnet/barribob/boss/mob/utils/IEntity;", "stats", "Lnet/barribob/boss/mob/utils/IEntityStats;", "healingStrength", "heal", "Lkotlin/Function1;", "timeToNighttime", "", "currentTime", "BOMD"})
public final class LichUtils {
    @NotNull
    private static final List<Float> hpPercentRageModes;
    public static final int textureSize = 256;
    @NotNull
    public static final LichUtils INSTANCE;

    @NotNull
    public final List<Float> getHpPercentRageModes() {
        return hpPercentRageModes;
    }

    public final long timeToNighttime(long currentTime) {
        long dayLength = 24000L;
        long midnight = 16000L;
        return currentTime - currentTime % dayLength + midnight;
    }

    public final void cappedHeal(@NotNull IEntity iEntity, @NotNull IEntityStats stats, @NotNull List<Float> hpPercentRageModes, float healingStrength, @NotNull Function1<? super Float, Unit> heal) {
        Intrinsics.checkNotNullParameter((Object)iEntity, (String)"iEntity");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(hpPercentRageModes, (String)"hpPercentRageModes");
        Intrinsics.checkNotNullParameter(heal, (String)"heal");
        if (iEntity.isAlive() && iEntity.target() == null) {
            float targetHealthRatio = MathUtils.roundedStep$default((MathUtils)MathUtils.INSTANCE, (float)(stats.getHealth() / stats.getMaxHealth()), hpPercentRageModes, (boolean)false, (int)4, null);
            if ((stats.getHealth() + healingStrength) / stats.getMaxHealth() < targetHealthRatio) {
                heal.invoke((Object)Float.valueOf(healingStrength));
            }
        }
    }

    private LichUtils() {
    }

    static {
        LichUtils lichUtils;
        INSTANCE = lichUtils = new LichUtils();
        hpPercentRageModes = CollectionsKt.listOf((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f)});
    }
}

