/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.render;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/barribob/boss/render/FrameLimiter;", "", "framesPerUnit", "", "timer", "Lnet/barribob/boss/animation/IAnimationTimer;", "(FLnet/barribob/boss/animation/IAnimationTimer;)V", "minimumFrameDelta", "previousTime", "", "getPreviousTime", "()D", "setPreviousTime", "(D)V", "canDoFrame", "", "BOMD"})
public final class FrameLimiter {
    private final float minimumFrameDelta;
    private double previousTime;
    private final IAnimationTimer timer;

    public final double getPreviousTime() {
        return this.previousTime;
    }

    public final void setPreviousTime(double d) {
        this.previousTime = d;
    }

    public final boolean canDoFrame() {
        double currentTick = this.timer.getCurrentTick();
        double frameDelta = currentTick - this.previousTime;
        if (frameDelta >= (double)this.minimumFrameDelta) {
            this.previousTime = currentTick;
            return true;
        }
        return false;
    }

    public FrameLimiter(float framesPerUnit, @NotNull IAnimationTimer timer) {
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.timer = timer;
        this.minimumFrameDelta = 1.0f / framesPerUnit;
    }
}

