/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.nicguzzo.wands.PaletteItem;
import net.nicguzzo.wands.WandsMod;

public class PaletteScreenHandler
extends AbstractContainerMenu {
    public ItemStack palette;
    private final SimpleContainer simplecontainer;
    public final Inventory playerInventory;

    public PaletteScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packetByteBuf) {
        this(syncId, playerInventory, packetByteBuf.m_130267_());
    }

    public PaletteScreenHandler(int syncId, Inventory playerInventory, final ItemStack palette) {
        super((MenuType)WandsMod.PALETTE_SCREEN_HANDLER.get(), syncId);
        this.palette = palette;
        this.playerInventory = playerInventory;
        ListTag tag = palette.m_41784_().m_128437_("Palette", 10);
        this.simplecontainer = new SimpleContainer(27){

            public void m_6596_() {
                palette.m_41784_().m_128365_("Palette", (Tag)PaletteScreenHandler.toTag(this));
                super.m_6596_();
            }
        };
        PaletteScreenHandler.fromTag(tag, this.simplecontainer);
        if (palette.m_41720_() instanceof PaletteItem) {
            int n;
            int o;
            for (o = 0; o < 3; ++o) {
                for (n = 0; n < 9; ++n) {
                    this.m_38897_(new Slot((Container)this.simplecontainer, n + o * 9, 8 + n * 18, 18 + o * 18));
                }
            }
            for (o = 0; o < 3; ++o) {
                for (n = 0; n < 9; ++n) {
                    this.m_38897_(new Slot((Container)playerInventory, n + o * 9 + 9, 8 + n * 18, 84 + o * 18));
                }
            }
            for (o = 0; o < 9; ++o) {
                this.m_38897_(new Slot((Container)playerInventory, o, 8 + o * 18, 142));
            }
        } else {
            Player player = playerInventory.f_35978_;
            this.m_6877_(player);
        }
    }

    public void m_6877_(Player player) {
        Inventory inventory = player.m_150109_();
        if (!inventory.m_36056_().m_41619_()) {
            this.m_142503_(ItemStack.f_41583_);
        }
    }

    public boolean m_6875_(Player player) {
        return this.palette.m_41720_() instanceof PaletteItem;
    }

    boolean can_pickup(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        Block blk = Block.m_49814_((Item)item);
        return itemStack.m_41753_() && blk != Blocks.f_50016_;
    }

    void insert(ItemStack itemStack) {
        for (int o = 0; o < 27; ++o) {
            Slot slot = (Slot)this.f_38839_.get(o);
            if (!slot.m_7993_().m_41619_()) continue;
            slot.m_5852_(itemStack);
            slot.m_6654_();
            break;
        }
    }

    public void m_150399_(int slotIndex, int button, ClickType actionType, Player player) {
        try {
            if (actionType != ClickType.QUICK_CRAFT && button == 1) {
                this.m_142503_(ItemStack.f_41583_);
            }
            if (slotIndex >= 0 && slotIndex < 63) {
                Slot slot = (Slot)this.f_38839_.get(slotIndex);
                if (actionType == ClickType.QUICK_CRAFT && slotIndex < 27) {
                    ItemStack itemStack = this.playerInventory.m_36056_();
                    slot.m_5852_(itemStack);
                    return;
                }
                if (slot != null) {
                    ItemStack itemStack;
                    ItemStack itemStack2;
                    if (actionType == ClickType.CLONE && this.can_pickup(itemStack2 = (itemStack = slot.m_7993_()).m_41777_())) {
                        itemStack2.m_41764_(1);
                        this.m_142503_(itemStack2);
                    }
                    if (button == 1) {
                        if (slotIndex < 27 && actionType == ClickType.PICKUP && !(itemStack = slot.m_7993_()).m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                            slot.m_6654_();
                        }
                        return;
                    }
                    if (button == 0) {
                        if (slotIndex < 27) {
                            if (actionType == ClickType.PICKUP || actionType == ClickType.QUICK_CRAFT) {
                                itemStack = slot.m_7993_();
                                if (!itemStack.m_41619_()) {
                                    itemStack2 = itemStack.m_41777_();
                                    if (this.can_pickup(itemStack2)) {
                                        itemStack2.m_41764_(1);
                                        this.m_142503_(itemStack2);
                                    }
                                } else {
                                    itemStack = this.m_142621_();
                                    if (!itemStack.m_41619_()) {
                                        slot.m_5852_(itemStack);
                                        this.m_142503_(ItemStack.f_41583_);
                                    }
                                }
                                slot.m_6654_();
                            }
                        } else if ((actionType == ClickType.PICKUP || actionType == ClickType.QUICK_MOVE) && this.can_pickup(itemStack2 = (itemStack = slot.m_7993_()).m_41777_())) {
                            itemStack2.m_41764_(1);
                            if (actionType == ClickType.PICKUP) {
                                this.m_142503_(itemStack2);
                            } else {
                                this.insert(itemStack2);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)var8, (String)"Container click");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Click info");
            crashReportCategory.m_128165_("Menu Type", () -> this.m_6772_() != null ? Registry.f_122863_.m_7981_((Object)this.m_6772_()).toString() : "<no type>");
            crashReportCategory.m_128165_("Menu Class", () -> ((Object)((Object)this)).getClass().getCanonicalName());
            crashReportCategory.m_128159_("Slot Count", (Object)this.f_38839_.size());
            crashReportCategory.m_128159_("Slot", (Object)slotIndex);
            crashReportCategory.m_128159_("Button", (Object)button);
            crashReportCategory.m_128159_("Type", (Object)actionType);
            throw new ReportedException(crashReport);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        return itemStack;
    }

    public static ListTag toTag(SimpleContainer inventory) {
        ListTag tag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("Slot", i);
            stackTag.m_128365_("Block", (Tag)inventory.m_8020_(i).m_41739_(new CompoundTag()));
            tag.add((Object)stackTag);
        }
        return tag;
    }

    public static void fromTag(ListTag tag, SimpleContainer inventory) {
        inventory.m_6211_();
        tag.forEach(element -> {
            CompoundTag stackTag = (CompoundTag)element;
            int slot = stackTag.m_128451_("Slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Block"));
            inventory.m_6836_(slot, stack);
        });
    }
}

