/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nicguzzo.wands.BlockBuffer;
import net.nicguzzo.wands.CircularBuffer;
import net.nicguzzo.wands.PaletteItem;
import net.nicguzzo.wands.WandItem;
import net.nicguzzo.wands.WandUtils;
import net.nicguzzo.wands.WandsConfig;
import net.nicguzzo.wands.WandsMod;

public class Wand {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public float x1 = 0.0f;
    public float y1 = 0.0f;
    public float z1 = 0.0f;
    public float x2 = 0.0f;
    public float y2 = 0.0f;
    public float z2 = 0.0f;
    public BlockPos p1 = null;
    public boolean p2 = false;
    public BlockState p1_state = null;
    public boolean valid = false;
    public static final int MAX_UNDO = 2048;
    public static final int MAX_LIMIT = 32768;
    Player player;
    Level level;
    BlockState block_state;
    BlockState offhand_state = null;
    Block offhand_block = null;
    BlockPos pos;
    public Direction side = Direction.UP;
    Vec3 hit;
    WandItem wand_item;
    ItemStack wand_stack;
    public float y0 = 0.0f;
    public float block_height = 1.0f;
    boolean is_stair = false;
    Rotation stair_rotation = Rotation.NONE;
    boolean is_slab_top = false;
    boolean is_slab_bottom = false;
    boolean is_alt_pressed = false;
    boolean is_shift_pressed = false;
    boolean destroy;
    boolean stop = false;
    ItemStack bucket = null;
    public boolean is_double_slab = false;
    public int grid_voxel_index = 0;
    public ItemStack palette = null;
    boolean has_palette = false;
    boolean has_bucket = false;
    boolean has_offhand = false;
    public boolean force_render = false;
    public int slot = 0;
    public Vector<PaletteSlot> palette_slots = new Vector();
    public Map<Item, BlockAccounting> block_accounting = new HashMap<Item, BlockAccounting>();
    public BlockBuffer block_buffer = new BlockBuffer(32768);
    public CircularBuffer undo_buffer = new CircularBuffer(2048);
    private BlockPos.MutableBlockPos tmp_pos = new BlockPos.MutableBlockPos();
    int MAX_COPY_VOL = 8000;
    Vector<CopyPasteBuffer> copy_paste_buffer = new Vector();
    public BlockPos copy_pos1 = null;
    public BlockPos copy_pos2 = null;
    public int copy_x1 = 0;
    public int copy_y1 = 0;
    public int copy_z1 = 0;
    public int copy_x2 = 0;
    public int copy_y2 = 0;
    public int copy_z2 = 0;
    boolean preview;
    public int mode;
    boolean prnt = false;

    private void log(String s) {
        WandsMod.log(s, this.prnt);
    }

    public void clear() {
        this.p1 = null;
        this.p1_state = null;
        this.valid = false;
        this.block_height = 1.0f;
        this.y0 = 0.0f;
        this.copy_pos1 = null;
        this.copy_pos2 = null;
        this.copy_paste_buffer.clear();
        if (this.player != null) {
            this.player.m_5661_((Component)new TextComponent("Wand Cleared").m_130940_(ChatFormatting.GREEN), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void do_or_preview(Player player, Level level, BlockState block_state, BlockPos pos, Direction side, Vec3 hit, ItemStack wand_stack, boolean prnt) {
        this.player = player;
        this.level = level;
        this.block_state = block_state;
        this.pos = pos;
        this.side = side;
        this.hit = hit;
        this.wand_stack = wand_stack;
        this.prnt = prnt;
        this.y0 = 0.0f;
        this.block_height = 1.0f;
        this.is_slab_top = false;
        this.is_double_slab = false;
        this.is_slab_bottom = false;
        this.is_stair = false;
        this.preview = level.m_5776_();
        this.offhand_state = null;
        this.stop = false;
        if (block_state == null || pos == null || side == null || level == null || player == null || hit == null || wand_stack == null) {
            return;
        }
        boolean creative = player.m_150110_().f_35937_;
        boolean is_copy_paste = this.mode == 6 || this.mode == 7;
        this.wand_item = (WandItem)wand_stack.m_41720_();
        this.mode = WandItem.getMode(wand_stack);
        if (block_state.m_60734_() instanceof SlabBlock) {
            if (!this.preview) {
                this.is_double_slab = block_state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE;
            }
            this.is_slab_top = block_state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP;
            this.is_slab_bottom = block_state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM;
        } else if (block_state.m_60734_() instanceof SnowLayerBlock) {
            int layers = (Integer)block_state.m_61143_((Property)SnowLayerBlock.f_56581_);
            this.block_height = (float)layers / 8.0f;
            if (layers < 8) {
                // empty if block
            }
        }
        if (this.is_slab_top || this.is_slab_bottom) {
            this.block_height = 0.5f;
            if (this.is_slab_top) {
                this.y0 = 0.5f;
            }
        }
        this.valid = false;
        this.destroy = WandUtils.can_destroy(player, block_state, false);
        ItemStack offhand = player.m_21206_();
        this.has_offhand = false;
        ItemStack item_stack = null;
        if (offhand != null && WandUtils.is_shulker(offhand)) {
            offhand = null;
        }
        this.palette = null;
        this.has_palette = false;
        this.has_bucket = false;
        if (offhand != null && offhand.m_41720_() instanceof PaletteItem && this.mode > 0) {
            this.palette = offhand;
            this.has_palette = true;
        }
        if (offhand != null && offhand.m_41720_() instanceof BucketItem && this.mode > 0) {
            this.bucket = offhand;
            this.has_bucket = true;
        }
        if (item_stack == null) {
            item_stack = Item.m_41439_((Block)block_state.m_60734_()).m_7968_();
        }
        if (offhand != null) {
            this.offhand_block = Block.m_49814_((Item)offhand.m_41720_());
            if (this.offhand_block != Blocks.f_50016_) {
                this.has_offhand = true;
            }
        }
        if (!(offhand == null || this.has_palette || this.has_bucket || this.destroy)) {
            if (offhand.m_41783_() != null) {
                if (!this.preview) {
                    player.m_5661_((Component)new TextComponent("Wand offhand can't have tag! ").m_130940_(ChatFormatting.RED), false);
                }
                offhand = null;
                return;
            }
            if (!offhand.m_41753_()) {
                if (!this.preview) {
                    player.m_5661_((Component)new TextComponent("Wand offhand must be stackable! ").m_130940_(ChatFormatting.RED), false);
                }
                offhand = null;
                return;
            }
        }
        if (!this.has_palette && !this.has_bucket && this.offhand_block != null && Blocks.f_50016_ != this.offhand_block) {
            this.offhand_state = this.offhand_block.m_49966_();
            if (this.offhand_block instanceof SlabBlock) {
                hity = WandUtils.unitCoord(hit.f_82480_);
                this.offhand_state = this.mode == 0 ? (!this.offhand_state.m_60713_(block_state.m_60734_()) ? (this.is_alt_pressed ? (BlockState)this.offhand_block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP) : (BlockState)this.offhand_block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)) : block_state) : (hity > 0.5 ? (BlockState)this.offhand_block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP) : (BlockState)this.offhand_block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM));
            } else if (this.offhand_block instanceof StairBlock) {
                hity = WandUtils.unitCoord(hit.f_82480_);
                this.offhand_state = this.mode == 0 ? (!this.offhand_state.m_60713_(block_state.m_60734_()) ? (this.is_alt_pressed ? (BlockState)this.offhand_block.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP) : (BlockState)this.offhand_block.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM)) : block_state) : (hity > 0.5 ? (BlockState)this.offhand_block.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP) : (BlockState)this.offhand_block.m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.BOTTOM));
                switch (WandItem.getRotation(wand_stack)) {
                    case 1: {
                        this.offhand_state = this.offhand_state.m_60717_(Rotation.CLOCKWISE_90);
                        break;
                    }
                    case 2: {
                        this.offhand_state = this.offhand_state.m_60717_(Rotation.CLOCKWISE_180);
                        break;
                    }
                    case 3: {
                        this.offhand_state = this.offhand_state.m_60717_(Rotation.COUNTERCLOCKWISE_90);
                    }
                }
            }
        }
        int placed = 0;
        switch (this.mode) {
            case 0: {
                boolean invert = WandItem.isInverted(wand_stack);
                placed += this.mode0(invert);
                break;
            }
            case 1: {
                WandItem.Orientation orientation = WandItem.getOrientation(wand_stack);
                placed += this.mode1(orientation);
                break;
            }
            case 2: {
                placed += this.mode2();
                break;
            }
            case 3: {
                placed += this.mode3();
                break;
            }
            case 4: {
                placed += this.mode4();
                break;
            }
            case 5: {
                int plane = WandItem.getPlane(wand_stack).ordinal();
                boolean fill = WandItem.isCircleFill(wand_stack);
                placed += this.mode5(plane, fill);
                break;
            }
            case 6: {
                placed += this.mode6();
                break;
            }
            case 7: {
                placed += this.mode7();
            }
        }
        if (!this.preview) {
            boolean missing_blocks;
            int a;
            int limit = 32768;
            if (!creative) {
                limit = this.wand_item.limit;
            }
            this.palette_slots.clear();
            this.block_accounting.clear();
            if (this.has_palette && !this.destroy && !is_copy_paste) {
                void var19_32;
                ListTag palette_inv = this.palette.m_41784_().m_128437_("Palette", 10);
                int s = palette_inv.size();
                for (int i = 0; i < s; ++i) {
                    Block blk;
                    CompoundTag stackTag = (CompoundTag)palette_inv.get(i);
                    ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("Block"));
                    if (itemStack.m_41619_() || (blk = Block.m_49814_((Item)itemStack.m_41720_())) == Blocks.f_50016_) continue;
                    PaletteSlot psl = new PaletteSlot(i, blk.m_49966_(), itemStack);
                    if (!this.palette_slots.stream().anyMatch(pp -> pp.stack.m_41656_(stack))) {
                        this.block_accounting.put(itemStack.m_41720_(), new BlockAccounting());
                    }
                    this.palette_slots.add(psl);
                }
                PaletteItem.PaletteMode palette_mode = PaletteItem.getMode(this.palette);
                CompoundTag tag = this.palette.m_41783_();
                this.slot = 0;
                boolean bl = false;
                while (var19_32 < this.block_buffer.get_length() && var19_32 < limit && var19_32 < 32768) {
                    if (!WandUtils.can_place(player.f_19853_.m_8055_(this.block_buffer.get((int)var19_32)), this.wand_item.removes_water, this.wand_item.removes_lava)) {
                        this.block_buffer.state[var19_32] = null;
                    } else {
                        int bound = this.palette_slots.size();
                        if (palette_mode == PaletteItem.PaletteMode.RANDOM) {
                            this.slot = level.f_46441_.nextInt(bound);
                        } else if (palette_mode == PaletteItem.PaletteMode.ROUND_ROBIN) {
                            this.slot = (this.slot + 1) % bound;
                        }
                        PaletteSlot ps = this.palette_slots.get(this.slot);
                        BlockAccounting pa = this.block_accounting.get(ps.stack.m_41720_());
                        if (pa != null) {
                            ++pa.needed;
                            if (!ps.stack.m_41619_()) {
                                this.block_buffer.state[var19_32] = ps.state;
                                this.block_buffer.item[var19_32] = ps.stack.m_41720_();
                                if (ps.state.m_60734_() instanceof SlabBlock && ps.state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
                                    ++pa.needed;
                                }
                                if (palette_mode == PaletteItem.PaletteMode.RANDOM) {
                                    if (ps.state.m_60734_() instanceof SnowLayerBlock) {
                                        int sn = player.f_19853_.f_46441_.nextInt(7);
                                        pa.needed += sn;
                                        this.block_buffer.state[var19_32] = (BlockState)ps.state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(sn + 1));
                                    }
                                    if (PaletteItem.getRotate(this.palette)) {
                                        this.block_buffer.state[var19_32] = ps.state.m_60734_().m_6843_(ps.state, Rotation.m_55956_((Random)level.f_46441_));
                                    }
                                }
                            } else {
                                this.block_buffer.state[var19_32] = null;
                                this.block_buffer.item[var19_32] = null;
                            }
                        }
                    }
                    ++var19_32;
                }
            } else if (!is_copy_paste) {
                Block offhand_block;
                if (!this.has_palette && !this.destroy && this.has_offhand && (offhand_block = Block.m_49814_((Item)offhand.m_41720_())) != Blocks.f_50016_) {
                    block_state = offhand_block.m_49966_();
                    item_stack = Item.m_41439_((Block)block_state.m_60734_()).m_7968_();
                }
                if (this.has_bucket) {
                    this.has_bucket = false;
                    if (this.bucket.m_150930_(Fluids.f_76193_.m_6859_())) {
                        this.has_bucket = true;
                        block_state = Blocks.f_49990_.m_49966_();
                    }
                    if (this.bucket.m_41753_()) {
                        this.has_bucket = true;
                        block_state = Blocks.f_50016_.m_49966_();
                    }
                }
                BlockAccounting pa = new BlockAccounting();
                for (a = 0; a < this.block_buffer.get_length() && a < limit && a < 32768; ++a) {
                    if (!WandUtils.can_place(player.f_19853_.m_8055_(this.block_buffer.get(a)), this.wand_item.removes_water, this.wand_item.removes_lava)) {
                        this.block_buffer.state[a] = null;
                        this.block_buffer.item[a] = null;
                        continue;
                    }
                    ++pa.needed;
                    this.block_buffer.state[a] = this.offhand_state != null ? this.offhand_state : block_state;
                    this.block_buffer.item[a] = item_stack.m_41720_();
                }
                this.block_accounting.put(item_stack.m_41720_(), pa);
            } else {
                for (int a3 = 0; a3 < this.block_buffer.get_length() && a3 < limit && a3 < 32768; ++a3) {
                    if (!WandUtils.can_place(player.f_19853_.m_8055_(this.block_buffer.get(a3)), this.wand_item.removes_water, this.wand_item.removes_lava)) {
                        this.block_buffer.state[a3] = null;
                        this.block_buffer.item[a3] = null;
                        continue;
                    }
                    BlockAccounting pa = this.block_accounting.get(this.block_buffer.item[a3]);
                    if (pa == null) {
                        pa = new BlockAccounting();
                        ++pa.needed;
                        this.block_accounting.put(this.block_buffer.item[a3], pa);
                        continue;
                    }
                    ++pa.needed;
                }
            }
            boolean bl = missing_blocks = this.block_accounting.size() == 0;
            if (!(creative || this.destroy || this.has_bucket || this.mode == 6)) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    if (WandUtils.is_shulker(stack)) {
                        for (Map.Entry entry : this.block_accounting.entrySet()) {
                            ((BlockAccounting)entry.getValue()).in_player += WandUtils.count_in_shulker(stack, (Item)entry.getKey());
                        }
                        continue;
                    }
                    for (Map.Entry entry : this.block_accounting.entrySet()) {
                        Item item = (Item)entry.getKey();
                        if (stack == null || item == null || stack.m_41619_() || item != stack.m_41720_()) continue;
                        ((BlockAccounting)entry.getValue()).in_player += stack.m_41613_();
                    }
                }
                for (Map.Entry<Item, BlockAccounting> pa : this.block_accounting.entrySet()) {
                    if (pa.getValue().in_player >= pa.getValue().needed) continue;
                    MutableComponent mutableComponent = new TextComponent("Not enough ").m_130940_(ChatFormatting.RED).m_130946_(pa.getKey().m_5524_());
                    mutableComponent.m_130946_(". Needed: " + pa.getValue().needed);
                    mutableComponent.m_130946_(" player: " + pa.getValue().in_player);
                    player.m_5661_((Component)mutableComponent, false);
                    missing_blocks = true;
                }
            }
            placed = 0;
            a = 0;
            if (!missing_blocks || this.destroy || this.has_bucket) {
                AABB bb = player.m_142469_();
                for (a = 0; a < this.block_buffer.get_length() && a < limit && a < 32768; ++a) {
                    this.tmp_pos.m_122178_(this.block_buffer.buffer_x[a], this.block_buffer.buffer_y[a], this.block_buffer.buffer_z[a]);
                    if (!this.destroy && bb.m_82314_((double)this.tmp_pos.m_123341_(), (double)this.tmp_pos.m_123342_(), (double)this.tmp_pos.m_123343_(), (double)(this.tmp_pos.m_123341_() + 1), (double)(this.tmp_pos.m_123342_() + 1), (double)(this.tmp_pos.m_123343_() + 1))) continue;
                    if (this.place_block((BlockPos)this.tmp_pos, this.block_buffer.state[a])) {
                        BlockAccounting blockAccounting;
                        Item item;
                        if (!this.destroy && (item = this.block_buffer.item[a]) != null && (blockAccounting = this.block_accounting.get(item)) != null) {
                            ++blockAccounting.placed;
                        }
                        ++placed;
                    }
                    if (this.stop) break;
                }
                if (!creative && !this.destroy && placed > 0) {
                    ItemStack stack = null;
                    Object var19_37 = null;
                    for (int pi = 0; pi < 36; ++pi) {
                        CompoundTag shulker_tag;
                        stack = player.m_150109_().m_8020_(pi);
                        if (!WandUtils.is_shulker(stack) || (shulker_tag = stack.m_41737_("BlockEntityTag")) == null) continue;
                        ListTag shulker_items = shulker_tag.m_128437_("Items", 10);
                        int len = shulker_items.size();
                        for (int j = 0; j < len; ++j) {
                            BlockAccounting pa;
                            CompoundTag itemTag = shulker_items.m_128728_(j);
                            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
                            if (itemStack == null || itemStack.m_41619_() || (pa = this.block_accounting.get(itemStack.m_41720_())) == null || pa.placed <= 0) continue;
                            this.log(itemStack.m_41778_() + " needed: " + pa.needed + " placed: " + pa.placed);
                            if (pa.placed <= itemStack.m_41613_()) {
                                itemStack.m_41764_(itemStack.m_41613_() - pa.placed);
                                pa.placed = 0;
                            } else {
                                pa.placed -= itemStack.m_41613_();
                                itemStack.m_41764_(0);
                            }
                            shulker_items.set(j, (Tag)itemStack.m_41739_(itemTag));
                        }
                    }
                    for (int i = 0; i < 36; ++i) {
                        BlockAccounting pa;
                        ItemStack itemStack = player.m_150109_().m_8020_(i);
                        if (WandUtils.is_shulker(itemStack) || (pa = this.block_accounting.get(itemStack.m_41720_())) == null || pa.placed <= 0) continue;
                        if (pa.placed <= itemStack.m_41613_()) {
                            itemStack.m_41764_(itemStack.m_41613_() - pa.placed);
                            pa.placed = 0;
                            continue;
                        }
                        pa.placed -= itemStack.m_41613_();
                        itemStack.m_41764_(0);
                    }
                }
            }
            if (placed > 0 && !this.destroy) {
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.m_130064_(pos);
                packet.writeBoolean(this.destroy);
                if (this.p1_state != null) {
                    packet.m_130055_(this.p1_state.m_60734_().m_5456_().m_7968_());
                } else if (block_state != null) {
                    packet.m_130055_(block_state.m_60734_().m_5456_().m_7968_());
                } else {
                    packet.m_130055_(ItemStack.f_41583_);
                }
                NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)WandsMod.SND_PACKET, (FriendlyByteBuf)packet);
            }
        }
        if (this.p2) {
            this.p1 = null;
            this.p2 = false;
            this.valid = false;
        }
    }

    public int mode0(boolean invert) {
        Direction[] dirs = this.getDirMode0(this.side, this.hit.f_82479_, this.hit.f_82480_, this.hit.f_82481_);
        if (invert) {
            if (dirs[0] != null) {
                dirs[0] = dirs[0].m_122424_();
            }
            if (dirs[1] != null) {
                dirs[1] = dirs[1].m_122424_();
            }
        }
        Direction d1 = dirs[0];
        Direction d2 = dirs[1];
        if (this.preview) {
            this.x = this.pos.m_123341_();
            this.y = this.pos.m_123342_();
            this.z = this.pos.m_123343_();
        }
        if (d1 != null) {
            BlockPos dest = null;
            dest = d2 != null ? WandUtils.find_next_diag(this.player.f_19853_, this.block_state, d1, d2, this.pos, this.wand_item, this.destroy, this.offhand_state) : WandUtils.find_next_pos(this.player.f_19853_, this.block_state, d1, this.pos, this.wand_item, this.destroy, this.offhand_state);
            if (dest != null) {
                this.x1 = dest.m_123341_();
                this.y1 = dest.m_123342_();
                this.z1 = dest.m_123343_();
                this.x2 = this.x1 + 1.0f;
                this.y2 = this.y1 + 1.0f;
                this.z2 = this.z1 + 1.0f;
                this.valid = true;
                this.block_buffer.reset();
                BlockState state = null;
                Item item = null;
                if (!this.has_palette) {
                    if (this.offhand_state != null && !this.offhand_state.m_60795_()) {
                        state = this.offhand_state;
                    }
                    if (state != null) {
                        item = state.m_60734_().m_5456_();
                    }
                }
                this.block_buffer.add(dest, state, item);
            }
        }
        return 0;
    }

    public int mode1(WandItem.Orientation orientation) {
        boolean preview = this.player.f_19853_.m_5776_();
        Direction dir = Direction.EAST;
        BlockPos pos_m = this.pos.m_5484_(this.side, 1);
        BlockState state = this.player.f_19853_.m_8055_(pos_m);
        WandItem wand = (WandItem)this.wand_stack.m_41720_();
        if (state.m_60795_() || WandUtils.is_fluid(state, wand.removes_water, wand.removes_lava) || this.destroy) {
            BlockPos pos0 = this.pos;
            BlockPos pos1 = pos_m;
            BlockPos pos2 = this.pos;
            BlockPos pos3 = pos_m;
            int offx = 0;
            int offy = 0;
            int offz = 0;
            block0 : switch (this.side) {
                case UP: 
                case DOWN: {
                    switch (orientation) {
                        case ROW: {
                            dir = Direction.SOUTH;
                            offz = -1;
                            break;
                        }
                        case COL: {
                            dir = Direction.EAST;
                            offx = -1;
                        }
                    }
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    switch (orientation) {
                        case ROW: {
                            dir = Direction.EAST;
                            offx = -1;
                            break;
                        }
                        case COL: {
                            dir = Direction.UP;
                            offy = -1;
                        }
                    }
                    break;
                }
                case EAST: 
                case WEST: {
                    switch (orientation) {
                        case ROW: {
                            dir = Direction.SOUTH;
                            offz = -1;
                            break block0;
                        }
                        case COL: {
                            dir = Direction.UP;
                            offy = -1;
                        }
                    }
                }
            }
            Direction op = dir.m_122424_();
            int i = wand.limit - 1;
            int k = 0;
            boolean stop1 = false;
            boolean stop2 = false;
            boolean dont_check_state = false;
            boolean eq = false;
            while (k < wand.limit && i > 0) {
                if (!stop1 && i > 0) {
                    BlockState bs0 = this.player.f_19853_.m_8055_(pos0.m_142300_(dir));
                    BlockState bs1 = this.player.f_19853_.m_8055_(pos1.m_142300_(dir));
                    eq = dont_check_state ? bs0.m_60734_().equals(this.block_state.m_60734_()) : bs0.equals(this.block_state);
                    if (eq && (bs1.m_60795_() || WandUtils.is_fluid(bs1, wand.removes_water, wand.removes_lava))) {
                        pos0 = pos0.m_142300_(dir);
                        pos1 = pos1.m_142300_(dir);
                        --i;
                    } else {
                        stop1 = true;
                    }
                }
                if (!stop2 && i > 0) {
                    BlockState bs2 = this.player.f_19853_.m_8055_(pos2.m_142300_(op));
                    BlockState bs3 = this.player.f_19853_.m_8055_(pos3.m_142300_(op));
                    eq = dont_check_state ? bs2.m_60734_().equals(this.block_state.m_60734_()) : bs2.equals(this.block_state);
                    if (eq && (bs3.m_60795_() || WandUtils.is_fluid(bs3, wand.removes_water, wand.removes_lava))) {
                        pos2 = pos2.m_142300_(op);
                        pos3 = pos3.m_142300_(op);
                        --i;
                    } else {
                        stop2 = true;
                    }
                }
                ++k;
                if (!stop1 || !stop2) continue;
                k = 1000000;
            }
            if (this.destroy) {
                pos1 = pos1.m_142300_(this.side.m_122424_());
                pos3 = pos3.m_142300_(this.side.m_122424_());
            }
            if (preview) {
                this.x1 = pos1.m_123341_() - offx;
                this.y1 = pos1.m_123342_() - offy;
                this.z1 = pos1.m_123343_() - offz;
                this.x2 = pos3.m_123341_() + offx + 1;
                this.y2 = pos3.m_123342_() + offy + 1;
                this.z2 = pos3.m_123343_() + offz + 1;
                this.valid = true;
            }
            return this.fill(pos1, pos3);
        }
        this.valid = false;
        return 0;
    }

    public int mode2() {
        int placed = 0;
        if (this.p1 != null && (this.p2 || this.preview)) {
            this.valid = true;
            this.x1 = this.p1.m_123341_();
            this.y1 = this.p1.m_123342_();
            this.z1 = this.p1.m_123343_();
            this.x2 = this.pos.m_123341_();
            this.y2 = this.pos.m_123342_();
            this.z2 = this.pos.m_123343_();
            if (!this.p1.equals((Object)this.pos)) {
                if (this.x1 >= this.x2) {
                    this.x1 += 1.0f;
                } else {
                    this.x2 += 1.0f;
                }
                if (this.y1 >= this.y2) {
                    this.y1 += 1.0f;
                } else {
                    this.y2 += 1.0f;
                }
                if (this.z1 >= this.z2) {
                    this.z1 += 1.0f;
                } else {
                    this.z2 += 1.0f;
                }
            } else {
                this.x2 = this.x1 + 1.0f;
                this.y2 = this.y1 + 1.0f;
                this.z2 = this.z1 + 1.0f;
            }
            placed = this.fill(this.p1, this.pos);
            this.valid = true;
        }
        return placed;
    }

    public int mode3() {
        this.block_buffer.reset();
        BlockState st = this.block_state;
        if (this.has_offhand && this.offhand_state != null && !this.offhand_state.m_60795_()) {
            st = this.offhand_state;
        }
        WandUtils.add_neighbour(this.block_buffer, this.wand_item, this.pos, this.block_state, this.player.f_19853_, this.side, st);
        int placed = 0;
        int found = 1;
        for (int i = 0; i < this.wand_item.limit && i < 32768 && found < this.wand_item.limit; ++i) {
            if (i >= this.block_buffer.get_length()) continue;
            BlockPos p = this.block_buffer.get(i).m_5484_(this.side, -1);
            found += WandUtils.find_neighbours(this.block_buffer, this.wand_item, p, this.block_state, this.player.f_19853_, this.side, st);
        }
        if (this.destroy) {
            for (int a = 0; a < this.block_buffer.get_length(); ++a) {
                this.block_buffer.set(a, this.block_buffer.get(a).m_5484_(this.side, -1));
            }
        }
        placed = this.from_buffer();
        return placed;
    }

    public int mode4() {
        block13: {
            this.block_buffer.reset();
            if (this.p1 == null || !this.p2 && !this.preview) break block13;
            int x1 = this.p1.m_123341_();
            int y1 = this.p1.m_123342_();
            int z1 = this.p1.m_123343_();
            int x2 = this.pos.m_123341_();
            int y2 = this.pos.m_123342_();
            int z2 = this.pos.m_123343_();
            int n = 0;
            int dx = Math.abs(x2 - x1);
            int dy = Math.abs(y2 - y1);
            int dz = Math.abs(z2 - z1);
            int xs = x2 > x1 ? 1 : -1;
            int ys = y2 > y1 ? 1 : -1;
            int zs = z2 > z1 ? 1 : -1;
            this.block_buffer.add(x1, y1, z1, this.block_state, null);
            ++n;
            if (dx >= dy && dx >= dz) {
                int lp1 = 2 * dy - dx;
                int lp2 = 2 * dz - dx;
                while (x1 != x2) {
                    x1 += xs;
                    if (lp1 >= 0) {
                        y1 += ys;
                        lp1 -= 2 * dx;
                    }
                    if (lp2 >= 0) {
                        z1 += zs;
                        lp2 -= 2 * dx;
                    }
                    lp1 += 2 * dy;
                    lp2 += 2 * dz;
                    this.block_buffer.add(x1, y1, z1, this.block_state, null);
                    if (++n < this.wand_item.limit) continue;
                    break;
                }
            } else if (dy >= dx && dy >= dz) {
                int lp1 = 2 * dx - dy;
                int lp2 = 2 * dz - dy;
                while (y1 != y2) {
                    y1 += ys;
                    if (lp1 >= 0) {
                        x1 += xs;
                        lp1 -= 2 * dy;
                    }
                    if (lp2 >= 0) {
                        z1 += zs;
                        lp2 -= 2 * dy;
                    }
                    lp1 += 2 * dx;
                    lp2 += 2 * dz;
                    this.block_buffer.add(x1, y1, z1, this.block_state, null);
                    if (++n < this.wand_item.limit) continue;
                    break;
                }
            } else {
                int lp1 = 2 * dy - dz;
                int lp2 = 2 * dx - dz;
                while (z1 != z2) {
                    z1 += zs;
                    if (lp1 >= 0) {
                        y1 += ys;
                        lp1 -= 2 * dz;
                    }
                    if (lp2 >= 0) {
                        x1 += xs;
                        lp2 -= 2 * dz;
                    }
                    lp1 += 2 * dy;
                    lp2 += 2 * dx;
                    this.block_buffer.add(x1, y1, z1, this.block_state, null);
                    if (++n < this.wand_item.limit) continue;
                    break;
                }
            }
        }
        return this.from_buffer();
    }

    public int mode5(int plane, boolean fill) {
        block11: {
            int r;
            int zc;
            int yc;
            int xc;
            block13: {
                block12: {
                    this.block_buffer.reset();
                    if (this.p1 == null || !this.p2 && !this.preview) break block11;
                    xc = this.p1.m_123341_();
                    yc = this.p1.m_123342_();
                    zc = this.p1.m_123343_();
                    int px = this.pos.m_123341_() - xc;
                    int py = this.pos.m_123342_() - yc;
                    int pz = this.pos.m_123343_() - zc;
                    r = (int)Math.sqrt(px * px + py * py + pz * pz);
                    if (plane != 0) break block12;
                    int x = 0;
                    int y = 0;
                    int z = r;
                    int d = 3 - 2 * r;
                    this.drawCircle(xc, yc, zc, x, y, z, plane);
                    while (z >= x) {
                        d = d > 0 ? d + 4 * (x - --z) + 10 : d + 4 * ++x + 6;
                        this.drawCircle(xc, yc, zc, x, y, z, plane);
                    }
                    if (!fill) break block11;
                    int r2 = r * r;
                    for (z = -r; z <= r; ++z) {
                        for (x = -r; x <= r; ++x) {
                            int det = x * x + z * z;
                            if (det > r2) continue;
                            this.block_buffer.add(xc + x, yc, zc + z, this.block_state, null);
                        }
                    }
                    break block11;
                }
                if (plane != 1) break block13;
                int x = 0;
                int y = r;
                int z = 0;
                int d = 3 - 2 * r;
                this.drawCircle(xc, yc, zc, x, y, z, plane);
                while (y >= x) {
                    d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * ++x + 6;
                    this.drawCircle(xc, yc, zc, x, y, z, plane);
                }
                if (!fill) break block11;
                int r2 = r * r;
                for (y = -r; y <= r; ++y) {
                    for (x = -r; x <= r; ++x) {
                        if (x * x + y * y > r2) continue;
                        this.block_buffer.add(xc + x, yc + y, zc, this.block_state, null);
                    }
                }
                break block11;
            }
            if (plane == 2) {
                int x = 0;
                int y = 0;
                int z = r;
                int d = 3 - 2 * r;
                this.drawCircle(xc, yc, zc, x, y, z, plane);
                while (z >= y) {
                    d = d > 0 ? d + 4 * (y - --z) + 10 : d + 4 * ++y + 6;
                    this.drawCircle(xc, yc, zc, x, y, z, plane);
                }
                if (fill) {
                    int r2 = r * r;
                    for (z = -r; z <= r; ++z) {
                        for (y = -r; y <= r; ++y) {
                            if (y * y + z * z > r2) continue;
                            this.block_buffer.add(xc, yc + y, zc + z, this.block_state, null);
                        }
                    }
                }
            }
        }
        return this.from_buffer();
    }

    public int mode6() {
        if (!this.preview) {
            // empty if block
        }
        if (this.copy_pos1 != null && this.preview) {
            this.valid = true;
            this.copy_x1 = this.copy_pos1.m_123341_();
            this.copy_y1 = this.copy_pos1.m_123342_();
            this.copy_z1 = this.copy_pos1.m_123343_();
            if (this.copy_pos2 == null) {
                this.copy_x2 = this.pos.m_123341_();
                this.copy_y2 = this.pos.m_123342_();
                this.copy_z2 = this.pos.m_123343_();
            } else {
                this.copy_x2 = this.copy_pos2.m_123341_();
                this.copy_y2 = this.copy_pos2.m_123342_();
                this.copy_z2 = this.copy_pos2.m_123343_();
            }
            if (!this.copy_pos1.equals((Object)this.copy_pos2)) {
                if (this.copy_x1 >= this.copy_x2) {
                    ++this.copy_x1;
                } else {
                    ++this.copy_x2;
                }
                if (this.copy_y1 >= this.copy_y2) {
                    ++this.copy_y1;
                } else {
                    ++this.copy_y2;
                }
                if (this.copy_z1 >= this.copy_z2) {
                    ++this.copy_z1;
                } else {
                    ++this.copy_z2;
                }
            } else {
                this.copy_x2 = this.copy_x1 + 1;
                this.copy_y2 = this.copy_y1 + 1;
                this.copy_z2 = this.copy_z1 + 1;
            }
        }
        if (this.copy_pos1 != null && this.copy_pos2 != null) {
            int ze;
            int zs;
            int ye;
            int ys;
            int xe;
            int xs;
            if (this.copy_pos1.m_123341_() >= this.copy_pos2.m_123341_()) {
                xs = this.copy_pos2.m_123341_();
                xe = this.copy_pos1.m_123341_();
            } else {
                xs = this.copy_pos1.m_123341_();
                xe = this.copy_pos2.m_123341_();
            }
            if (this.copy_pos1.m_123342_() >= this.copy_pos2.m_123342_()) {
                ys = this.copy_pos2.m_123342_();
                ye = this.copy_pos1.m_123342_();
            } else {
                ys = this.copy_pos1.m_123342_();
                ye = this.copy_pos2.m_123342_();
            }
            if (this.copy_pos1.m_123343_() >= this.copy_pos2.m_123343_()) {
                zs = this.copy_pos2.m_123343_();
                ze = this.copy_pos1.m_123343_();
            } else {
                zs = this.copy_pos1.m_123343_();
                ze = this.copy_pos2.m_123343_();
            }
            int ll = (xe - xs + 1) * (ye - ys + 1) * (ze - zs + 1);
            if (ll <= this.MAX_COPY_VOL) {
                BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
                this.copy_paste_buffer.clear();
                int cp = 0;
                for (int z = zs; z <= ze; ++z) {
                    for (int y = ys; y <= ye; ++y) {
                        for (int x = xs; x <= xe; ++x) {
                            bp.m_122178_(x, y, z);
                            BlockState bs = this.level.m_8055_((BlockPos)bp);
                            if (bs == Blocks.f_50016_.m_49966_()) continue;
                            ++cp;
                            this.copy_paste_buffer.add(new CopyPasteBuffer(new BlockPos(x - xs, y - ys, z - zs), bs));
                        }
                    }
                }
                if (!this.preview) {
                    this.player.m_5661_((Component)new TextComponent("Copied: " + cp + " blocks"), false);
                }
            }
        }
        return 0;
    }

    int mode7() {
        if (!this.preview) {
            BlockPos b_pos = this.pos.m_5484_(this.side, 1);
            BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
            this.block_buffer.reset();
            for (CopyPasteBuffer b : this.copy_paste_buffer) {
                int rot = WandItem.getRotation(this.wand_stack);
                Rotation rotation = Rotation.values()[rot];
                BlockPos p = b.pos.m_7954_(rotation);
                this.block_buffer.add(b_pos.m_123341_() + p.m_123341_(), b_pos.m_123342_() + p.m_123342_(), b_pos.m_123343_() + p.m_123343_(), b.state.m_60717_(rotation), Item.m_41439_((Block)b.state.m_60734_()));
            }
        }
        return 0;
    }

    private void drawCircle(int xc, int yc, int zc, int x, int y, int z, int plane) {
        switch (plane) {
            case 0: {
                this.block_buffer.add(xc + x, yc, zc + z, this.block_state, null);
                this.block_buffer.add(xc - x, yc, zc + z, this.block_state, null);
                this.block_buffer.add(xc + x, yc, zc - z, this.block_state, null);
                this.block_buffer.add(xc - x, yc, zc - z, this.block_state, null);
                this.block_buffer.add(xc + z, yc, zc + x, this.block_state, null);
                this.block_buffer.add(xc - z, yc, zc + x, this.block_state, null);
                this.block_buffer.add(xc + z, yc, zc - x, this.block_state, null);
                this.block_buffer.add(xc - z, yc, zc - x, this.block_state, null);
                break;
            }
            case 1: {
                this.block_buffer.add(xc + x, yc + y, zc, this.block_state, null);
                this.block_buffer.add(xc - x, yc + y, zc, this.block_state, null);
                this.block_buffer.add(xc + x, yc - y, zc, this.block_state, null);
                this.block_buffer.add(xc - x, yc - y, zc, this.block_state, null);
                this.block_buffer.add(xc + y, yc + x, zc, this.block_state, null);
                this.block_buffer.add(xc - y, yc + x, zc, this.block_state, null);
                this.block_buffer.add(xc + y, yc - x, zc, this.block_state, null);
                this.block_buffer.add(xc - y, yc - x, zc, this.block_state, null);
                break;
            }
            case 2: {
                this.block_buffer.add(xc, yc + y, zc + z, this.block_state, null);
                this.block_buffer.add(xc, yc - y, zc + z, this.block_state, null);
                this.block_buffer.add(xc, yc + y, zc - z, this.block_state, null);
                this.block_buffer.add(xc, yc - y, zc - z, this.block_state, null);
                this.block_buffer.add(xc, yc + z, zc + y, this.block_state, null);
                this.block_buffer.add(xc, yc - z, zc + y, this.block_state, null);
                this.block_buffer.add(xc, yc + z, zc - y, this.block_state, null);
                this.block_buffer.add(xc, yc - z, zc - y, this.block_state, null);
            }
        }
    }

    public void undo(int n) {
        if (this.undo_buffer != null) {
            for (int i = 0; i < n && i < this.undo_buffer.size(); ++i) {
                CircularBuffer.P p = this.undo_buffer.peek();
                if (p == null) continue;
                if (!p.destroyed) {
                    if (!this.level.m_46597_(p.pos, Blocks.f_50016_.m_49966_())) continue;
                    this.undo_buffer.pop();
                    continue;
                }
                if (!this.level.m_46597_(p.pos, p.state)) continue;
                this.undo_buffer.pop();
            }
        }
    }

    public void redo(int n) {
        if (this.undo_buffer != null) {
            for (int i = 0; i < n && this.undo_buffer.can_go_forward(); ++i) {
                this.undo_buffer.forward();
                CircularBuffer.P p = this.undo_buffer.peek();
                if (p == null || p.pos == null || p.state == null) continue;
                if (!p.destroyed) {
                    this.level.m_46597_(p.pos, p.state);
                    continue;
                }
                this.level.m_46597_(p.pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public int from_buffer() {
        int placed = 0;
        if (this.preview) {
            this.valid = this.block_buffer.get_length() > 0 && this.block_buffer.get_length() <= this.wand_item.limit;
        }
        return placed;
    }

    public int fill(BlockPos from, BlockPos to) {
        int ll;
        int ze;
        int zs;
        int ye;
        int ys;
        int xe;
        int xs;
        int placed = 0;
        if (from.m_123341_() >= to.m_123341_()) {
            xs = to.m_123341_();
            xe = from.m_123341_();
        } else {
            xs = from.m_123341_();
            xe = to.m_123341_();
        }
        if (from.m_123342_() >= to.m_123342_()) {
            ys = to.m_123342_();
            ye = from.m_123342_();
        } else {
            ys = from.m_123342_();
            ye = to.m_123342_();
        }
        if (from.m_123343_() >= to.m_123343_()) {
            zs = to.m_123343_();
            ze = from.m_123343_();
        } else {
            zs = from.m_123343_();
            ze = to.m_123343_();
        }
        int limit = 32768;
        if (!this.player.m_150110_().f_35937_) {
            limit = this.wand_item.limit;
        }
        if ((ll = (xe - xs + 1) * (ye - ys + 1) * (ze - zs + 1)) <= limit) {
            this.block_buffer.reset();
            BlockState state = null;
            if (!this.has_palette) {
                state = this.block_state;
                if (this.mode == 2 && this.p1_state != null) {
                    state = this.p1_state;
                }
            }
            Item item = null;
            for (int z = zs; z <= ze; ++z) {
                for (int y = ys; y <= ye; ++y) {
                    for (int x = xs; x <= xe; ++x) {
                        if (!this.has_palette) {
                            if (this.offhand_state != null && !this.offhand_state.m_60795_()) {
                                state = this.offhand_state;
                            }
                            if (state != null) {
                                item = state.m_60734_().m_5456_();
                            }
                        }
                        this.block_buffer.add(x, y, z, state, item);
                    }
                }
            }
        } else if (!this.preview) {
            this.player.m_5661_((Component)new TextComponent("Wand limit reached: " + ll + "(" + limit + ")"), false);
        }
        return placed;
    }

    public boolean place_block(BlockPos block_pos, BlockState state) {
        boolean placed = false;
        Level level = this.player.f_19853_;
        boolean creative = this.player.m_150110_().f_35937_;
        if (level.f_46443_) {
            return false;
        }
        if (state == null && !this.destroy) {
            return false;
        }
        if (state != null) {
            if (WandsConfig.denied.contains(state.m_60734_())) {
                return false;
            }
        }
        this.p1_state = state;
        if (creative) {
            if (this.undo_buffer != null) {
                // empty if block
            }
            if (this.destroy ? level.m_46961_(block_pos, false) : level.m_46597_(block_pos, state)) {
                return true;
            }
        } else {
            float xp = WandUtils.calc_xp(this.player.f_36078_, this.player.f_36080_);
            float dec = 0.0f;
            float BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
            if (BLOCKS_PER_XP != 0.0f) {
                dec = 1.0f / BLOCKS_PER_XP;
            }
            ItemStack wand_stack = this.player.m_21205_();
            ItemStack offhand = this.player.m_21206_();
            int wand_durability = wand_stack.m_41776_() - wand_stack.m_41773_();
            if ((wand_durability > 1 || WandsMod.config.allow_wand_to_break) && (BLOCKS_PER_XP == 0.0f || xp - dec >= 0.0f)) {
                if (this.destroy) {
                    BlockState st = level.m_8055_(block_pos);
                    if (WandUtils.can_destroy(this.player, st, true)) {
                        int offhand_durability = offhand.m_41776_() - offhand.m_41773_();
                        if (offhand_durability > 1 || WandsMod.config.allow_offhand_to_break) {
                            placed = level.m_46961_(block_pos, false);
                            if (placed && WandsMod.config.destroy_in_survival_drop) {
                                int silk_touch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)offhand);
                                int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)offhand);
                                if (fortune > 0 || silk_touch > 0) {
                                    st.m_60734_().m_6240_(level, this.player, block_pos, st, null, offhand);
                                }
                            }
                        } else {
                            this.player.m_5661_((Component)new TextComponent("tool damaged"), false);
                            this.stop = true;
                        }
                    }
                } else {
                    boolean is_tool;
                    boolean bl = is_tool = offhand != null && !offhand.m_41619_() && offhand.m_41720_() instanceof DiggerItem;
                    if (!is_tool) {
                        Object stack2 = null;
                        if (level.m_46597_(block_pos, state)) {
                            placed = true;
                        }
                    }
                }
            } else {
                if (BLOCKS_PER_XP != 0.0f && xp - dec < 0.0f) {
                    this.player.m_5661_((Component)new TextComponent("not enough xp"), false);
                    this.stop = true;
                }
                if (wand_durability == 1 && !WandsMod.config.allow_wand_to_break) {
                    this.player.m_5661_((Component)new TextComponent("wand damaged"), false);
                    this.stop = true;
                }
            }
            if (placed) {
                if (this.destroy) {
                    offhand.m_41622_(1, (LivingEntity)this.player, p -> p.m_21190_(InteractionHand.OFF_HAND));
                }
                wand_stack.m_41622_(1, (LivingEntity)this.player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                if (BLOCKS_PER_XP != 0.0f) {
                    float diff = WandUtils.calc_xp_to_next_level(this.player.f_36078_);
                    float prog = this.player.f_36080_;
                    if (diff > 0.0f && BLOCKS_PER_XP != 0.0f) {
                        float a = 1.0f / diff / BLOCKS_PER_XP;
                        if (prog - a > 0.0f) {
                            prog -= a;
                        } else {
                            prog = prog > 0.0f ? 1.0f + (a - prog) : 1.0f;
                            if (this.player.f_36078_ > 0) {
                                --this.player.f_36078_;
                                diff = WandUtils.calc_xp_to_next_level(this.player.f_36078_);
                                a = 1.0f / diff / BLOCKS_PER_XP;
                                if (prog - a > 0.0f) {
                                    prog -= a;
                                }
                            }
                        }
                    }
                }
            }
        }
        return placed;
    }

    public Direction[] getDirMode0(Direction side, double hit_x, double hit_y, double hit_z) {
        Direction[] ret = new Direction[]{null, null};
        double a = 0.333333f;
        double b = 0.666666f;
        double x = WandUtils.unitCoord(hit_x);
        double y = WandUtils.unitCoord(hit_y);
        double z = WandUtils.unitCoord(hit_z);
        double xo = x;
        double yo = y;
        double zo = z;
        double last_x = -1.0;
        double last_y = -1.0;
        double last_z = -1.0;
        VoxelShape shape = this.block_state.m_60808_((BlockGetter)this.level, this.pos);
        List list = shape.m_83299_();
        int index = 0;
        for (AABB aabb : list) {
            switch (side) {
                case UP: 
                case DOWN: {
                    if (!(xo > aabb.f_82288_) || !(xo < aabb.f_82291_) || !(zo > aabb.f_82290_) || !(zo < aabb.f_82293_)) break;
                    if (aabb.m_82362_() != 0.0) {
                        x = (float)((x - aabb.f_82288_) / aabb.m_82362_());
                    }
                    if (aabb.m_82385_() != 0.0) {
                        z = (float)((z - aabb.f_82290_) / aabb.m_82385_());
                    }
                    this.grid_voxel_index = index;
                    break;
                }
                case EAST: 
                case WEST: {
                    last_x = aabb.f_82291_;
                    if (!(yo > aabb.f_82289_) || !(yo < aabb.f_82292_) || !(zo > aabb.f_82290_) || !(zo < aabb.f_82293_)) break;
                    if (aabb.m_82376_() != 0.0) {
                        y = (float)((y - aabb.f_82289_) / aabb.m_82376_());
                    }
                    if (aabb.m_82385_() != 0.0) {
                        z = (float)((z - aabb.f_82290_) / aabb.m_82385_());
                    }
                    this.grid_voxel_index = index;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    if (!(xo > aabb.f_82288_) || !(xo < aabb.f_82291_) || !(yo > aabb.f_82289_) || !(yo < aabb.f_82292_)) break;
                    if (aabb.m_82362_() != 0.0) {
                        x = (float)((x - aabb.f_82288_) / aabb.m_82362_());
                    }
                    if (aabb.m_82376_() != 0.0) {
                        y = (float)((y - aabb.f_82289_) / aabb.m_82376_());
                    }
                    this.grid_voxel_index = index;
                }
            }
            ++index;
        }
        switch (side) {
            case UP: 
            case DOWN: {
                if (x >= a && x <= b) {
                    if (z <= a) {
                        ret[0] = Direction.NORTH;
                        break;
                    }
                    if (z >= b) {
                        ret[0] = Direction.SOUTH;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (z >= a && z <= b) {
                    if (x <= a) {
                        ret[0] = Direction.WEST;
                        break;
                    }
                    if (!(x >= b)) break;
                    ret[0] = Direction.EAST;
                    break;
                }
                if (x <= a && z <= a) {
                    ret[0] = Direction.WEST;
                    ret[1] = Direction.NORTH;
                }
                if (x >= b && z <= a) {
                    ret[0] = Direction.EAST;
                    ret[1] = Direction.NORTH;
                }
                if (x >= b && z >= b) {
                    ret[0] = Direction.EAST;
                    ret[1] = Direction.SOUTH;
                }
                if (!(x <= a) || !(z >= b)) break;
                ret[0] = Direction.WEST;
                ret[1] = Direction.SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                if (z >= a && z <= b) {
                    if (y <= a) {
                        ret[0] = Direction.DOWN;
                        break;
                    }
                    if (y >= b) {
                        ret[0] = Direction.UP;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (y >= a && y <= b) {
                    if (z <= a) {
                        ret[0] = Direction.NORTH;
                        return ret;
                    }
                    if (!(z >= b)) break;
                    ret[0] = Direction.SOUTH;
                    return ret;
                }
                if (y <= a && z <= a) {
                    ret[0] = Direction.DOWN;
                    ret[1] = Direction.NORTH;
                }
                if (y >= b && z <= a) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.NORTH;
                }
                if (y >= b && z >= b) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.SOUTH;
                }
                if (!(y <= a) || !(z >= b)) break;
                ret[0] = Direction.DOWN;
                ret[1] = Direction.SOUTH;
                break;
            }
            case SOUTH: 
            case NORTH: {
                if (x >= a && x <= b) {
                    if (y <= a) {
                        ret[0] = Direction.DOWN;
                        break;
                    }
                    if (y >= b) {
                        ret[0] = Direction.UP;
                        break;
                    }
                    ret[0] = side.m_122424_();
                    break;
                }
                if (y >= a && y <= b) {
                    if (x <= a) {
                        ret[0] = Direction.WEST;
                        break;
                    }
                    if (!(x >= b)) break;
                    ret[0] = Direction.EAST;
                    break;
                }
                if (y <= a && x <= a) {
                    ret[0] = Direction.DOWN;
                    ret[1] = Direction.WEST;
                }
                if (y >= b && x <= a) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.WEST;
                }
                if (y >= b && x >= b) {
                    ret[0] = Direction.UP;
                    ret[1] = Direction.EAST;
                }
                if (!(y <= a) || !(x >= b)) break;
                ret[0] = Direction.DOWN;
                ret[1] = Direction.EAST;
            }
        }
        return ret;
    }

    private class PaletteSlot {
        public ItemStack stack = null;
        public BlockState state = null;
        public int slot = 0;

        PaletteSlot(int s, BlockState b, ItemStack stk) {
            this.slot = s;
            this.state = b;
            this.stack = stk;
        }
    }

    private class BlockAccounting {
        public int placed = 0;
        public int needed = 0;
        public int in_player = 0;

        private BlockAccounting() {
        }
    }

    class CopyPasteBuffer {
        public BlockPos pos = null;
        public BlockState state = null;

        public CopyPasteBuffer(BlockPos pos, BlockState state) {
            this.pos = pos;
            this.state = state;
        }
    }
}

