/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.nicguzzo.wands.ClientRender;
import net.nicguzzo.wands.PlayerWand;
import net.nicguzzo.wands.Wand;
import org.jetbrains.annotations.Nullable;

public class WandItem
extends Item {
    public int limit = 0;
    public boolean removes_water;
    public boolean removes_lava;
    private static final int max_mode = 7;

    public WandItem(int limit, boolean removes_water, boolean removes_lava, Item.Properties properties) {
        super(properties);
        this.limit = limit;
        this.removes_lava = removes_lava;
        this.removes_water = removes_water;
    }

    public static int getMode(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            return stack.m_41784_().m_128451_("mode");
        }
        return -1;
    }

    public static String getModeString(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            int mode = stack.m_41784_().m_128451_("mode");
            switch (mode) {
                case 0: {
                    return "Direction";
                }
                case 1: {
                    return "Row/Col";
                }
                case 2: {
                    return "Fill";
                }
                case 3: {
                    return "Area";
                }
                case 4: {
                    return "Line";
                }
                case 5: {
                    return "Circle";
                }
                case 6: {
                    return "Copy";
                }
                case 7: {
                    return "Paste";
                }
            }
        }
        return "";
    }

    public static void nextMode(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int mode = (tag.m_128451_("mode") + 1) % 8;
            tag.m_128405_("mode", mode);
        }
    }

    public static void prevMode(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int mode = tag.m_128451_("mode") - 1;
            if (mode < 0) {
                mode = 7;
            }
            tag.m_128405_("mode", mode);
        }
    }

    public static boolean isInverted(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            return stack.m_41784_().m_128471_("inverted");
        }
        return false;
    }

    public static void invert(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag;
            boolean inverted = (tag = stack.m_41784_()).m_128471_("inverted");
            tag.m_128379_("inverted", !inverted);
        }
    }

    public static Orientation getOrientation(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            int o = stack.m_41784_().m_128451_("orientation");
            return Orientation.values()[o];
        }
        return Orientation.ROW;
    }

    public static void nextOrientation(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int o = (tag.m_128451_("orientation") + 1) % 2;
            tag.m_128405_("orientation", o);
        }
    }

    public static Plane getPlane(ItemStack stack) {
        int p;
        Plane plane = Plane.XZ;
        if (stack != null && !stack.m_41619_() && (p = stack.m_41784_().m_128451_("plane")) >= 0 && p < Plane.values().length) {
            plane = Plane.values()[p];
        }
        return plane;
    }

    public static void nextPlane(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int plane = (tag.m_128451_("plane") + 1) % 3;
            tag.m_128405_("plane", plane);
        }
    }

    public static void toggleCircleFill(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag;
            boolean cfill = (tag = stack.m_41784_()).m_128471_("cfill");
            tag.m_128379_("cfill", !cfill);
        }
    }

    public static boolean isCircleFill(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            return stack.m_41784_().m_128471_("cfill");
        }
        return false;
    }

    public static int getRotation(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            return stack.m_41784_().m_128451_("rotation");
        }
        return 0;
    }

    public static void nextRotation(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag tag = stack.m_41784_();
            int rot = (tag.m_128451_("rotation") + 1) % Rotation.values().length;
            tag.m_128405_("rotation", rot);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Wand wand = null;
        if (!world.m_5776_()) {
            wand = PlayerWand.get(context.m_43723_());
            if (wand == null) {
                PlayerWand.add_player(context.m_43723_());
                wand = PlayerWand.get(context.m_43723_());
                if (wand == null) {
                    return InteractionResult.FAIL;
                }
            }
        } else {
            wand = ClientRender.wand;
        }
        wand.force_render = true;
        ItemStack stack = context.m_43723_().m_21205_();
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem) {
            Vec3 hit = context.m_43720_();
            BlockPos pos = context.m_8083_();
            Direction side = context.m_43719_();
            BlockState block_state = world.m_8055_(pos);
            int mode = WandItem.getMode(stack);
            if (mode == 2 || mode == 4 || mode == 5 || mode == 6) {
                if (wand.is_alt_pressed) {
                    pos = pos.m_5484_(side, 1);
                }
                if (wand.p1 == null) {
                    wand.p1_state = block_state;
                    wand.p2 = false;
                    wand.p1 = pos;
                    wand.x1 = pos.m_123341_();
                    wand.y1 = pos.m_123342_();
                    wand.z1 = pos.m_123343_();
                    wand.copy_pos1 = pos;
                    return InteractionResult.SUCCESS;
                }
                wand.copy_pos2 = pos;
                block_state = wand.p1_state;
                wand.p2 = true;
            }
            wand.do_or_preview(context.m_43723_(), world, block_state, pos, side, hit, stack, true);
            if (mode == 6 && wand.copy_pos1 != null && wand.copy_pos2 != null) {
                wand.copy_pos1 = null;
                wand.copy_pos2 = null;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand interactionHand) {
        Wand wand = null;
        if (!world.m_5776_()) {
            wand = PlayerWand.get(player);
            if (wand == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
                if (wand == null) {
                    return InteractionResultHolder.m_19100_((Object)player.m_21120_(interactionHand));
                }
            }
        } else {
            wand = ClientRender.wand;
            wand.force_render = true;
        }
        wand.clear();
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(interactionHand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag tag = stack.m_41784_();
        list.add((Component)new TextComponent("mode: " + WandItem.getModeString(stack)));
        list.add((Component)new TextComponent("orientation: " + Orientation.values()[tag.m_128451_("orientation")].toString()));
        list.add((Component)new TextComponent("plane: " + Plane.values()[tag.m_128451_("plane")].toString()));
        list.add((Component)new TextComponent("fill circle: " + tag.m_128471_("cfill")));
        list.add((Component)new TextComponent("rotation: " + tag.m_128451_("rotation")));
    }

    public static enum Orientation {
        ROW,
        COL;

    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }

    public static enum BState {
        CLONE,
        DEFAULT;

    }
}

