/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nicguzzo.wands.BlockBuffer;
import net.nicguzzo.wands.WandItem;

class WandUtils {
    WandUtils() {
    }

    public static boolean is_shulker(ItemStack item_stack) {
        return Block.m_49814_((Item)item_stack.m_41720_()) instanceof ShulkerBoxBlock;
    }

    public static int count_in_shulker(ItemStack shulker, Item item) {
        CompoundTag entity_tag;
        ListTag shulker_items = null;
        int n = 0;
        if (item != null && (entity_tag = shulker.m_41737_("BlockEntityTag")) != null && (shulker_items = entity_tag.m_128437_("Items", 10)) != null) {
            int len = shulker_items.size();
            for (int i = 0; i < len; ++i) {
                CompoundTag itemTag = shulker_items.m_128728_(i);
                ItemStack s = ItemStack.m_41712_((CompoundTag)itemTag);
                if (s.m_41619_() || s.m_41720_() != item) continue;
                n += s.m_41613_();
            }
        }
        return n;
    }

    public static int[] count_in_player(Player player, ItemStack item_stack) {
        int[] n = new int[2];
        int count_in_player = 0;
        int count_in_shulker = 0;
        if (!item_stack.m_41619_()) {
            ItemStack stack = null;
            for (int i = 0; i < 36; ++i) {
                stack = player.m_150109_().m_8020_(i);
                if (WandUtils.is_shulker(stack)) {
                    count_in_shulker += WandUtils.count_in_shulker(stack, item_stack.m_41720_());
                    continue;
                }
                if (stack == null || item_stack == null || stack.m_41619_() || item_stack.m_41720_() != stack.m_41720_()) continue;
                count_in_player += stack.m_41613_();
            }
        }
        n[0] = count_in_player;
        n[1] = count_in_shulker;
        return n;
    }

    public static int remove_item_from_shulker(ItemStack shulker, ItemStack item_stack, int n) {
        CompoundTag entity_tag = shulker.m_41737_("BlockEntityTag");
        int removed = 0;
        int m = n;
        if (entity_tag != null) {
            ListTag shulker_items = entity_tag.m_128437_("Items", 10);
            int safe = 1000;
            block0: while (m > 0 && safe > 0) {
                --safe;
                int len = shulker_items.size();
                for (int i = 0; i < len; ++i) {
                    CompoundTag itemTag = shulker_items.m_128728_(i);
                    ItemStack stack_item = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (stack_item == null || stack_item.m_41619_() || stack_item.m_41720_() != item_stack.m_41720_() || stack_item.m_41613_() <= 0) continue;
                    stack_item.m_41764_(stack_item.m_41613_() - 1);
                    ++removed;
                    shulker_items.set(i, (Tag)stack_item.m_41739_(itemTag));
                    if (--m <= 0) continue block0;
                }
            }
        }
        return removed;
    }

    public static boolean can_destroy(Player player, BlockState block_state, boolean check_speed) {
        ItemStack offhand_item = player.m_21206_();
        boolean is_glass = block_state.m_60734_() instanceof AbstractGlassBlock;
        boolean is_snow_layer = false;
        if (block_state.m_60734_() instanceof SnowLayerBlock) {
            boolean bl = is_snow_layer = (Integer)block_state.m_61143_((Property)SnowLayerBlock.f_56581_) == 1;
        }
        if (offhand_item != null && !offhand_item.m_41619_() && offhand_item.m_41720_() instanceof DiggerItem) {
            if (check_speed) {
                DiggerItem mt = (DiggerItem)offhand_item.m_41720_();
                if (mt != null) {
                    return player.m_150110_().f_35937_ || mt.m_8102_(null, block_state) > 1.0f || is_glass || is_snow_layer;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static double unitCoord(double x) {
        double y = x - (double)((int)x);
        if (y < 0.0) {
            y = 1.0 + y;
        }
        return y;
    }

    public static boolean is_plant(BlockState state) {
        return state.m_60734_() instanceof BushBlock;
    }

    public static boolean is_fluid(BlockState state, boolean water, boolean lava) {
        if (water && lava) {
            return state.m_60819_().m_76153_((net.minecraft.tags.Tag)FluidTags.f_13131_) || state.m_60819_().m_76153_((net.minecraft.tags.Tag)FluidTags.f_13132_);
        }
        if (water) {
            return state.m_60819_().m_76153_((net.minecraft.tags.Tag)FluidTags.f_13131_);
        }
        return false;
    }

    public static boolean can_place(BlockState state, boolean water, boolean lava) {
        return state.m_60795_() || WandUtils.is_fluid(state, water, lava) || WandUtils.is_plant(state);
    }

    public static int add_neighbour(BlockBuffer block_buffer, WandItem wand, BlockPos pos, BlockState block_state, Level world, Direction side, BlockState block_state2) {
        BlockPos pos2 = pos.m_142300_(side);
        if (!block_buffer.in_buffer(pos2)) {
            BlockState bs1 = world.m_8055_(pos);
            BlockState bs2 = world.m_8055_(pos2);
            if (bs1.equals(block_state) && WandUtils.can_place(bs2, wand.removes_water, wand.removes_lava)) {
                block_buffer.add(pos2, block_state2);
                return 1;
            }
        }
        return 0;
    }

    public static BlockPos find_next_diag(Level world, BlockState block_state, Direction dir1, Direction dir2, BlockPos pos, WandItem wand, boolean destroy, BlockState offhand_state) {
        BlockPos p0 = pos;
        for (int i = 0; i < wand.limit; ++i) {
            BlockPos p1 = pos.m_142300_(dir1);
            BlockState bs = world.m_8055_(pos = p1.m_142300_(dir2));
            if (bs != null) {
                if (destroy) {
                    if (!(bs.equals(block_state) || offhand_state != null && bs.m_60713_(offhand_state.m_60734_()) || p0 == null)) {
                        return p0;
                    }
                } else {
                    if (WandUtils.can_place(bs, wand.removes_water, wand.removes_lava)) {
                        return pos;
                    }
                    if (!(bs.equals(block_state) || offhand_state != null && bs.m_60713_(offhand_state.m_60734_()))) {
                        return null;
                    }
                }
            }
            p0 = pos;
        }
        return null;
    }

    public static BlockPos find_next_pos(Level world, BlockState block_state, Direction dir, BlockPos pos, WandItem wand, boolean destroy, BlockState offhand_state) {
        for (int i = 0; i < wand.limit; ++i) {
            BlockPos pos2 = pos.m_5484_(dir, i + 1);
            BlockState bs = world.m_8055_(pos2);
            if (bs == null || bs.m_60713_(block_state.m_60734_()) || offhand_state != null && bs.m_60713_(offhand_state.m_60734_())) continue;
            if (destroy) {
                return pos.m_5484_(dir, i);
            }
            if (WandUtils.can_place(bs, wand.removes_water, wand.removes_lava)) {
                return pos2;
            }
            return null;
        }
        return null;
    }

    public static int find_neighbours(BlockBuffer block_buffer, WandItem wand, BlockPos pos, BlockState block_state, Level world, Direction side, BlockState block_state2) {
        int found = 0;
        if (side == Direction.UP || side == Direction.DOWN) {
            BlockPos p0 = pos.m_5484_(Direction.EAST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.EAST, 1);
            BlockPos p1 = p0.m_5484_(Direction.NORTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.NORTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.NORTH, 1);
            p1 = p0.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            p1 = p0.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            p1 = p0.m_5484_(Direction.EAST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
        } else if (side == Direction.EAST || side == Direction.WEST) {
            BlockPos p0 = pos.m_5484_(Direction.UP, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.UP, 1);
            BlockPos p1 = p0.m_5484_(Direction.NORTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.NORTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.NORTH, 1);
            p1 = p0.m_5484_(Direction.DOWN, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.DOWN, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            p1 = p0.m_5484_(Direction.DOWN, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.SOUTH, 1);
            p1 = p0.m_5484_(Direction.UP, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
        } else if (side == Direction.NORTH || side == Direction.SOUTH) {
            BlockPos p0 = pos.m_5484_(Direction.EAST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.EAST, 1);
            BlockPos p1 = p0.m_5484_(Direction.UP, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.UP, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.UP, 1);
            p1 = p0.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.DOWN, 1);
            p1 = p0.m_5484_(Direction.WEST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.DOWN, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p0, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
            p0 = pos.m_5484_(Direction.DOWN, 1);
            p1 = p0.m_5484_(Direction.EAST, 1);
            if ((found += WandUtils.add_neighbour(block_buffer, wand, p1, block_state, world, side, block_state2)) >= wand.limit) {
                return found;
            }
        }
        return found;
    }

    public static float calc_xp(int level, float prog) {
        float xp = WandUtils.calc_xp_level(level);
        if (prog > 0.0f) {
            xp += prog * (WandUtils.calc_xp_level(level + 1) - xp);
        }
        return xp;
    }

    public static float calc_xp_level(int level) {
        float xp_points = 0.0f;
        int level2 = level * level;
        xp_points = level >= 32 ? 4.5f * (float)level2 - 162.5f * (float)level + 2220.0f : (level >= 17 ? 2.5f * (float)level2 - 40.5f * (float)level + 360.0f : (float)(level2 + 6 * level));
        return xp_points;
    }

    public static int calc_xp_to_next_level(int level) {
        int xp = 0;
        xp = level >= 32 ? 9 * level - 158 : (level >= 17 ? 5 * level - 38 : 2 * level + 7);
        return xp;
    }
}

