/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.nicguzzo.wands.WandsExpectPlatform;

public class WandsConfig {
    private static WandsConfig INSTANCE = null;
    public static final String[] default_allowed = new String[]{"minecraft:soul_sand", "minecraft:grass_path"};
    public static final String[] default_denied = new String[0];
    public float blocks_per_xp = 0.0f;
    public int stone_wand_limit = 9;
    public int iron_wand_limit = 49;
    public int diamond_wand_limit = 64;
    public int netherite_wand_limit = 128;
    public int stone_wand_durability = 131;
    public int iron_wand_durability = 250;
    public int diamond_wand_durability = 1561;
    public int netherite_wand_durability = 2031;
    public boolean destroy_in_survival_drop = true;
    public boolean allow_wand_to_break = false;
    public boolean allow_offhand_to_break = false;
    public float wand_mode_display_x_pos = 80.0f;
    public float wand_mode_display_y_pos = 100.0f;
    public String[] str_allowed = default_allowed;
    public String[] str_denied = default_denied;
    public static List<Block> allowed = new ArrayList<Block>();
    public static List<Block> denied = new ArrayList<Block>();

    public void generate_lists() {
        Block blk;
        Item item;
        ResourceLocation res;
        for (String id : this.str_allowed) {
            res = ResourceLocation.m_135820_((String)id);
            item = (Item)Registry.f_122827_.m_7745_(res);
            blk = Block.m_49814_((Item)item);
            if (blk == null) continue;
            allowed.add(blk);
        }
        for (String id : this.str_denied) {
            res = ResourceLocation.m_135820_((String)id);
            item = (Item)Registry.f_122827_.m_7745_(res);
            blk = Block.m_49814_((Item)item);
            if (blk == null) continue;
            denied.add(blk);
        }
    }

    public static void load_config() {
        INSTANCE = new WandsConfig();
        Gson gson = new Gson();
        File configFile = new File(WandsExpectPlatform.getConfigDirectory().toString(), "wands.json");
        try (FileReader reader = new FileReader(configFile);){
            INSTANCE = (WandsConfig)gson.fromJson((Reader)reader, WandsConfig.class);
            System.out.println("Config: " + INSTANCE);
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
                System.out.println("Config updated!");
            }
            catch (IOException e2) {
                System.out.println("Failed to update config file!");
            }
            System.out.println("Config loaded!");
        }
        catch (IOException e) {
            System.out.println("No config found, generating!");
            INSTANCE = new WandsConfig();
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)INSTANCE));
            }
            catch (IOException e2) {
                System.out.println("Failed to generate config file!");
            }
        }
    }

    public static WandsConfig get_instance() {
        if (INSTANCE == null) {
            WandsConfig.load_config();
            INSTANCE.generate_lists();
        }
        return INSTANCE;
    }
}

