/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.nicguzzo.wands.PaletteItem;
import net.nicguzzo.wands.PaletteScreenHandler;
import net.nicguzzo.wands.PlayerWand;
import net.nicguzzo.wands.Wand;
import net.nicguzzo.wands.WandItem;
import net.nicguzzo.wands.WandsConfig;
import net.nicguzzo.wands.WandsExpectPlatform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WandsMod {
    public static WandsConfig config = WandsConfig.get_instance();
    public static final String MOD_ID = "wands";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final LazyLoadedValue<Registries> REGISTRIES = new LazyLoadedValue(() -> Registries.get((String)MOD_ID));
    public static final CreativeModeTab WANDS_TAB = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation("wands", "wands_tab"), (Supplier)new Supplier<ItemStack>(){

        @Override
        public ItemStack get() {
            return new ItemStack((ItemLike)DIAMOND_WAND_ITEM.get());
        }
    });
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"wands", (ResourceKey)Registry.f_122904_);
    public static final DeferredRegister<MenuType<?>> MENUES = DeferredRegister.create((String)"wands", (ResourceKey)Registry.f_122913_);
    public static final RegistrySupplier<Item> STONE_WAND_ITEM = ITEMS.register("stone_wand", () -> new WandItem(WandsMod.config.stone_wand_limit, false, false, new Item.Properties().m_41503_(WandsMod.config.stone_wand_durability).m_41491_(WANDS_TAB)));
    public static final RegistrySupplier<Item> IRON_WAND_ITEM = ITEMS.register("iron_wand", () -> new WandItem(WandsMod.config.iron_wand_limit, false, false, new Item.Properties().m_41503_(WandsMod.config.iron_wand_durability).m_41491_(WANDS_TAB)));
    public static final RegistrySupplier<Item> DIAMOND_WAND_ITEM = ITEMS.register("diamond_wand", () -> new WandItem(WandsMod.config.diamond_wand_limit, true, false, new Item.Properties().m_41503_(WandsMod.config.diamond_wand_durability).m_41491_(WANDS_TAB)));
    public static final RegistrySupplier<Item> NETHERITE_WAND_ITEM = ITEMS.register("netherite_wand", () -> new WandItem(WandsMod.config.netherite_wand_limit, true, true, new Item.Properties().m_41486_().m_41503_(WandsMod.config.netherite_wand_durability).m_41491_(WANDS_TAB)));
    public static final RegistrySupplier<Item> PALETTE_ITEM = ITEMS.register("palette", () -> new PaletteItem(new Item.Properties().m_41487_(1).m_41491_(WANDS_TAB)));
    public static final RegistrySupplier<MenuType<PaletteScreenHandler>> PALETTE_SCREEN_HANDLER = MENUES.register("palette_menu", () -> MenuRegistry.ofExtended(PaletteScreenHandler::new));
    public static ResourceLocation KB_PACKET = new ResourceLocation("wands", "key_packet");
    public static ResourceLocation SND_PACKET = new ResourceLocation("wands", "sound_packet");
    public static ResourceLocation PALETTE_PACKET = new ResourceLocation("wands", "palette_packet");
    public static final int wand_mode_key = 86;
    public static final int wand_orientation_key = 88;
    public static final int wand_invert_key = 73;
    public static final int wand_fill_circle_key = 75;
    public static final int palette_mode_key = 82;
    public static final int wand_undo = 85;

    public static void init() {
        ITEMS.register();
        MENUES.register();
        System.out.println(WandsExpectPlatform.getConfigDirectory().toAbsolutePath().normalize().toString());
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)KB_PACKET, (packet, context) -> {
            int key = packet.readInt();
            boolean shift = packet.readBoolean();
            boolean alt = packet.readBoolean();
            context.queue(() -> WandsMod.process_keys(context.getPlayer(), key, shift, alt));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PALETTE_PACKET, (packet, context) -> {
            boolean mode = packet.readBoolean();
            boolean rotate = packet.readBoolean();
            context.queue(() -> {
                Player player = context.getPlayer();
                ItemStack item_stack = player.m_21205_();
                ItemStack palette = null;
                if (!item_stack.m_41619_() && item_stack.m_41720_() instanceof PaletteItem) {
                    palette = item_stack;
                } else {
                    ItemStack offhand_stack = player.m_21206_();
                    if (!offhand_stack.m_41619_() && offhand_stack.m_41720_() instanceof PaletteItem) {
                        palette = offhand_stack;
                    }
                }
                if (palette != null) {
                    if (mode) {
                        PaletteItem.nextMode(palette);
                    }
                    if (rotate) {
                        PaletteItem.toggleRotate(palette);
                    }
                }
            });
        });
        PlayerEvent.PLAYER_QUIT.register(player -> {
            LOGGER.info("PLAYER_QUIT");
            PlayerWand.remove_player((Player)player);
        });
    }

    public static void process_keys(Player player, int key, boolean shift, boolean alt) {
        ItemStack item_stack = player.m_21205_();
        if (!item_stack.m_41619_() && item_stack.m_41720_() instanceof WandItem) {
            block0 : switch (key) {
                case 86: {
                    if (shift) {
                        WandItem.prevMode(item_stack);
                        break;
                    }
                    WandItem.nextMode(item_stack);
                    break;
                }
                case 88: {
                    switch (WandItem.getMode(item_stack)) {
                        case 5: {
                            WandItem.nextPlane(item_stack);
                            player.m_5661_((Component)new TextComponent("Wand Plane: " + WandItem.getPlane(item_stack)), false);
                            break block0;
                        }
                        case 0: 
                        case 7: {
                            break block0;
                        }
                    }
                    WandItem.nextOrientation(item_stack);
                    player.m_5661_((Component)new TextComponent("Wand Orientation: " + WandItem.getOrientation(item_stack).toString().toLowerCase()), false);
                    break;
                }
                case 73: {
                    WandItem.invert(item_stack);
                    player.m_5661_((Component)new TextComponent("Wand inverted: " + WandItem.isInverted(item_stack)), false);
                    break;
                }
                case 75: {
                    WandItem.toggleCircleFill(item_stack);
                    player.m_5661_((Component)new TextComponent("Wand circle fill: " + WandItem.isCircleFill(item_stack)), false);
                    break;
                }
                case 82: {
                    ItemStack offhand_stack = player.m_21206_();
                    if (!offhand_stack.m_41619_() && offhand_stack.m_41720_() instanceof PaletteItem) {
                        PaletteItem.nextMode(offhand_stack);
                        player.m_5661_((Component)new TextComponent("Palette mode: " + PaletteItem.getMode(offhand_stack)), false);
                        break;
                    }
                    WandItem.nextRotation(item_stack);
                    int r = WandItem.getRotation(item_stack);
                    String rot = "0\u00b0";
                    switch (r) {
                        case 1: {
                            rot = "90\u00b0";
                            break;
                        }
                        case 2: {
                            rot = "180\u00b0";
                            break;
                        }
                        case 3: {
                            rot = "270\u00b0";
                        }
                    }
                    player.m_5661_((Component)new TextComponent("Wand Rotation: " + rot), false);
                    break;
                }
                case 85: {
                    Wand wand;
                    if (!player.m_150110_().f_35937_ || player.f_19853_.m_5776_() || (wand = PlayerWand.get(player)) == null) break;
                    int n = 1;
                    if (alt) {
                        n = 10;
                    }
                    if (shift) {
                        wand.redo(n);
                        break;
                    }
                    wand.undo(n);
                }
            }
        }
        if (!item_stack.m_41619_() && item_stack.m_41720_() instanceof PaletteItem) {
            switch (key) {
                case 82: {
                    PaletteItem.nextMode(item_stack);
                    player.m_5661_((Component)new TextComponent("Palette mode: " + PaletteItem.getMode(item_stack)), false);
                }
            }
        }
        if (key == -1) {
            Wand wand = null;
            if (!player.f_19853_.m_5776_() && (wand = PlayerWand.get(player)) == null) {
                PlayerWand.add_player(player);
                wand = PlayerWand.get(player);
            }
            if (wand != null) {
                wand.is_alt_pressed = alt;
                wand.is_shift_pressed = shift;
            }
        }
    }

    public static void log(String s, boolean b) {
        if (b) {
            LOGGER.info(s);
        }
    }
}

