/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.wands;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.nicguzzo.wands.ClientRender;
import net.nicguzzo.wands.PaletteScreen;
import net.nicguzzo.wands.WandItem;
import net.nicguzzo.wands.WandsMod;

public class WandsModClient {
    static boolean shift = false;
    static boolean alt = false;

    public static void initialize() {
        KeyMapping[] km;
        for (KeyMapping k : km = new KeyMapping[]{new KeyMapping("key.wands.wand_mode", 86, "category.wands"), new KeyMapping("key.wands.wand_orientation", 88, "category.wands"), new KeyMapping("key.wands.wand_invert", 73, "category.wands"), new KeyMapping("key.wands.wand_palette_mode", 82, "category.wands"), new KeyMapping("key.wands.wand_fill_circle", 75, "category.wands"), new KeyMapping("key.wands.wand_undo", 85, "category.wands")}) {
            KeyMappingRegistry.register((KeyMapping)k);
        }
        ClientTickEvent.CLIENT_PRE.register(e -> {
            boolean any = false;
            for (KeyMapping k : km) {
                if (!k.m_90859_()) continue;
                if (!any) {
                    any = true;
                }
                WandsModClient.send_key(k.m_90861_().m_84873_(), Screen.m_96638_(), Screen.m_96639_());
            }
            if (!(any || alt == Screen.m_96639_() && shift == Screen.m_96638_())) {
                alt = Screen.m_96639_();
                shift = Screen.m_96638_();
                ClientRender.wand.is_alt_pressed = alt;
                ClientRender.wand.is_shift_pressed = shift;
                WandsModClient.send_key(-1, shift, alt);
            }
        });
        ClientGuiEvent.RENDER_HUD.register((pose, delta) -> WandsModClient.render_wand_info(pose));
        ClientLifecycleEvent.CLIENT_SETUP.register(e -> MenuRegistry.registerScreenFactory((MenuType)((MenuType)WandsMod.PALETTE_SCREEN_HANDLER.get()), PaletteScreen::new));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WandsMod.SND_PACKET, (packet, context) -> {
            BlockPos pos = packet.m_130135_();
            boolean destroy = packet.readBoolean();
            ItemStack item_stack = packet.m_130267_();
            context.queue(() -> {
                if (!item_stack.m_41619_()) {
                    Block block = Block.m_49814_((Item)item_stack.m_41720_());
                    SoundType sound_type = block.m_49962_(block.m_49966_());
                    SoundEvent sound = destroy ? sound_type.m_56775_() : sound_type.m_56777_();
                    context.getPlayer().f_19853_.m_5594_(context.getPlayer(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        });
    }

    public static void send_key(int key, boolean shift, boolean alt) {
        Minecraft client = Minecraft.m_91087_();
        if (client.m_91403_() != null) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeInt(key);
            packet.writeBoolean(shift);
            packet.writeBoolean(alt);
            NetworkManager.sendToServer((ResourceLocation)WandsMod.KB_PACKET, (FriendlyByteBuf)packet);
        }
    }

    public static void send_palette(boolean next_mode, boolean toggle_rotate) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeBoolean(next_mode);
        packet.writeBoolean(toggle_rotate);
        NetworkManager.sendToServer((ResourceLocation)WandsMod.PALETTE_PACKET, (FriendlyByteBuf)packet);
    }

    public static void render_wand_info(PoseStack poseStack) {
        ItemStack stack;
        Minecraft client = Minecraft.m_91087_();
        if (client != null && client.f_91074_ != null && (stack = client.f_91074_.m_21205_()) != null && !stack.m_41619_() && stack.m_41720_() instanceof WandItem) {
            int screenWidth = client.m_91268_().m_85445_();
            int screenHeight = client.m_91268_().m_85446_();
            Font font = client.f_91062_;
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            String msg = "Mode: " + WandItem.getModeString(stack);
            Objects.requireNonNull(font);
            int h = 9;
            float x = (int)((float)screenWidth * (WandsMod.config.wand_mode_display_x_pos / 100.0f));
            float y = (int)((float)(screenHeight - h) * (WandsMod.config.wand_mode_display_y_pos / 100.0f));
            font.m_92883_(poseStack, msg, x, y, 0xFFFFFF);
        }
    }
}

