/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs;

import com.corgam.cagedmobs.addons.theoneprobe.CagedMobsTOPSupport;
import com.corgam.cagedmobs.configs.ClientConfig;
import com.corgam.cagedmobs.configs.ServerConfig;
import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.env.EnvironmentDataSerializer;
import com.corgam.cagedmobs.serializers.mob.AdditionalLootDataSerializer;
import com.corgam.cagedmobs.serializers.mob.MobDataSerializer;
import com.corgam.cagedmobs.setup.CagedBlocks;
import com.corgam.cagedmobs.setup.CagedItems;
import com.corgam.cagedmobs.setup.CagedTE;
import com.corgam.cagedmobs.setup.ClientSetup;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cagedmobs")
public class CagedMobs {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final UUID CAGEDMOBS_UUID = UUID.nameUUIDFromBytes("cagedmobs".getBytes());
    final IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();

    public CagedMobs() {
        this.eventBus.addListener(ClientSetup::renderLayerSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_CONFIG.getForgeConfigSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG.getForgeConfigSpec());
        this.eventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        CagedBlocks.BLOCKS_REG.register(this.eventBus);
        CagedItems.ITEMS_REG.register(this.eventBus);
        CagedTE.TE_REG.register(this.eventBus);
        this.eventBus.addListener(this::addPropertiesToItems);
        this.eventBus.addListener(this::initTOPSupport);
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(RecipesHelper.MOB_RECIPE.toString()), RecipesHelper.MOB_RECIPE);
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(RecipesHelper.ENV_RECIPE.toString()), RecipesHelper.ENV_RECIPE);
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(RecipesHelper.ADDITIONAL_LOOT_RECIPE.toString()), RecipesHelper.ADDITIONAL_LOOT_RECIPE);
        event.getRegistry().register((IForgeRegistryEntry)EnvironmentDataSerializer.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)MobDataSerializer.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)AdditionalLootDataSerializer.INSTANCE);
    }

    private void addPropertiesToItems(FMLClientSetupEvent event) {
        ItemModelsProperties.func_239418_a_((Item)((Item)CagedItems.DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity) -> DnaSamplerItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)CagedItems.DNA_SAMPLER_DIAMOND.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity) -> DnaSamplerDiamondItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)CagedItems.DNA_SAMPLER_NETHERITE.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity) -> DnaSamplerNetheriteItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
    }

    private void initTOPSupport(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", CagedMobsTOPSupport::new);
        }
    }
}

