/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.corgam.cagedmobs.serializers.env.EnvironmentData;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.cagedmobs.Environment")
public class CTEnvironment {
    private final EnvironmentData data;

    public CTEnvironment(String id, IIngredient item, BlockState renderState, float growModifier, String[] categories) {
        this(new EnvironmentData(ResourceLocation.func_208304_a((String)id), item.asVanillaIngredient(), renderState, growModifier, new HashSet<String>(Arrays.asList(categories))));
    }

    public CTEnvironment(EnvironmentData envData) {
        this.data = envData;
    }

    @ZenCodeType.Method
    public CTEnvironment addCategory(String category) {
        this.data.getEnvironments().add(category);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment removeCategory(String category) {
        this.data.getEnvironments().remove(category);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment clearCategories() {
        this.data.getEnvironments().clear();
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setInputItem(IIngredient ingredient) {
        this.data.setInputItem(ingredient.asVanillaIngredient());
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setDisplay(BlockState state) {
        this.data.setRenderState(state);
        return this;
    }

    @ZenCodeType.Method
    public CTEnvironment setGrowthModifier(float modifier) {
        this.data.setGrowthModifier(modifier);
        return this;
    }

    public EnvironmentData getEnvironmentData() {
        return this.data;
    }
}

