/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.jei;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.addons.jei.BackgroundDrawable;
import com.corgam.cagedmobs.addons.jei.EntityWrapper;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.mob.LootData;
import com.corgam.cagedmobs.setup.CagedItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EntityCategory
implements IRecipeCategory<EntityWrapper> {
    public static final ResourceLocation ID = new ResourceLocation("cagedmobs", "entity");
    private static final BackgroundDrawable ENTITY_BG_DRAWABLE = new BackgroundDrawable("textures/gui/entity.png", 166, 111);
    private final IDrawable icon;
    private final IDrawableStatic slotDrawable;

    public EntityCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((Object)new ItemStack((IItemProvider)CagedItems.MOB_CAGE.get()));
        this.slotDrawable = gui.getSlotDrawable();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends EntityWrapper> getRecipeClass() {
        return EntityWrapper.class;
    }

    public String getTitle() {
        String name = new TranslationTextComponent("jei.category.cagedmobs.entity").getString();
        return name;
    }

    public IDrawable getBackground() {
        return ENTITY_BG_DRAWABLE;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(EntityWrapper entityWrapper, IIngredients iIngredients) {
        entityWrapper.setIngredients(iIngredients);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, EntityWrapper entityWrapper, IIngredients iIngredients) {
        IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
        stacks.init(0, true, 19, 81);
        stacks.set(0, entityWrapper.getSamplers());
        stacks.init(1, true, 39, 81);
        stacks.set(1, entityWrapper.getEnvsItems());
        int nextSlotId = 2;
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData entry : entityWrapper.getDrops()) {
            int relativeSlotId;
            if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                if (blacklistedItems.contains(entry.getItem().func_77973_b())) continue;
                relativeSlotId = nextSlotId - 2;
                stacks.init(nextSlotId, false, 100 + 19 * (relativeSlotId % 4), 5 + 19 * (relativeSlotId / 4));
                if (entry.isCooking() && entityWrapper.getCookedIDs().contains(relativeSlotId)) {
                    stacks.set(nextSlotId, entry.getCookedItem());
                } else {
                    stacks.set(nextSlotId, entry.getItem());
                }
                ++nextSlotId;
                continue;
            }
            if (!blacklistedItems.contains(entry.getItem().func_77973_b())) continue;
            relativeSlotId = nextSlotId - 2;
            stacks.init(nextSlotId, false, 100 + 19 * (relativeSlotId % 4), 5 + 19 * (relativeSlotId / 4));
            if (entry.isCooking() && entityWrapper.getCookedIDs().contains(relativeSlotId)) {
                stacks.set(nextSlotId, entry.getCookedItem());
            } else {
                stacks.set(nextSlotId, entry.getItem());
            }
            ++nextSlotId;
        }
        stacks.addTooltipCallback(entityWrapper::getTooltip);
    }

    public void draw(EntityWrapper recipe, MatrixStack matrix, double mouseX, double mouseY) {
        this.slotDrawable.draw(matrix, 19, 81);
        this.slotDrawable.draw(matrix, 39, 81);
        for (int nextSlotId = 2; nextSlotId < 22; ++nextSlotId) {
            int relativeSlotId = nextSlotId - 2;
            this.slotDrawable.draw(matrix, 100 + 19 * (relativeSlotId % 4), 5 + 19 * (relativeSlotId / 4));
        }
        recipe.drawInfo(this.getBackground().getWidth(), this.getBackground().getHeight(), matrix, mouseX, mouseY);
        matrix.func_227860_a_();
        matrix.func_227861_a_(5.0, 2.0, 0.0);
        if (recipe.getEntity() != null && recipe.getEntity().getEntityType() != null) {
            Minecraft.func_71410_x().field_71466_p.func_243248_b(matrix, recipe.getEntity().getEntityType().func_212546_e(), 0.0f, 0.0f, 8);
        }
        matrix.func_227861_a_(5.0, 100.0, 0.0);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, new TranslationTextComponent("jei.tooltip.cagedmobs.entity.ticks", new Object[]{recipe.getSeconds()}).getString(), 0.0f, 0.0f, 8);
        if (recipe.ifRequiresWater()) {
            matrix.func_227861_a_(-5.0, 10.0, 0.0);
            Minecraft.func_71410_x().field_71466_p.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.requiresWater").func_240699_a_(TextFormatting.BLUE), 0.0f, 0.0f, 8);
        }
        matrix.func_227865_b_();
    }
}

