/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.jei;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.env.EnvironmentData;
import com.corgam.cagedmobs.serializers.mob.AdditionalLootData;
import com.corgam.cagedmobs.serializers.mob.LootData;
import com.corgam.cagedmobs.serializers.mob.MobData;
import com.corgam.cagedmobs.setup.CagedItems;
import com.corgam.cagedmobs.tileEntities.MobCageTE;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityWrapper
implements IRecipeCategoryExtension {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private final MobData entity;
    private final List<ItemStack> envs = NonNullList.func_191196_a();
    private final List<LootData> drops = NonNullList.func_191196_a();
    private final List<ItemStack> samplers = NonNullList.func_191196_a();
    private final List<Integer> cookedIDs = new ArrayList<Integer>();
    private final boolean requiresWater;
    private final int ticks;
    public static float rotation = 0.0f;
    private static double yaw = 0.0;

    public EntityWrapper(MobData entity) {
        this.entity = entity;
        for (EnvironmentData env : RecipesHelper.getEnvsRecipesList(RecipesHelper.getRecipeManager())) {
            if (!RecipesHelper.isEnvValidForEntity(entity, env)) continue;
            this.envs.addAll(Arrays.asList(env.getInputItem().func_193365_a()));
        }
        if (entity.getSamplerTier() >= 3) {
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER_NETHERITE.get()));
        } else if (entity.getSamplerTier() == 2) {
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER_NETHERITE.get()));
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER_DIAMOND.get()));
        } else {
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER_NETHERITE.get()));
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER_DIAMOND.get()));
            this.samplers.add(new ItemStack((IItemProvider)CagedItems.DNA_SAMPLER.get()));
        }
        int lootIndex = 0;
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData lootData : entity.getResults()) {
            if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                if (blacklistedItems.contains(lootData.getItem().func_77973_b()) || this.drops.contains(lootData)) continue;
                this.drops.add(lootData);
                ++lootIndex;
                if (!lootData.isCooking()) continue;
                this.drops.add(lootData);
                this.cookedIDs.add(lootIndex);
                ++lootIndex;
                continue;
            }
            if (!blacklistedItems.contains(lootData.getItem().func_77973_b()) || this.drops.contains(lootData)) continue;
            this.drops.add(lootData);
            ++lootIndex;
            if (!lootData.isCooking()) continue;
            this.drops.add(lootData);
            this.cookedIDs.add(lootIndex);
            ++lootIndex;
        }
        for (IRecipe iRecipe : RecipesHelper.getRecipes(RecipesHelper.ADDITIONAL_LOOT_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            AdditionalLootData additionalLootData;
            if (!(iRecipe instanceof AdditionalLootData) || (additionalLootData = (AdditionalLootData)iRecipe).getEntityType() == null || this.entity.getEntityType() == null || !this.entity.getEntityType().equals(additionalLootData.getEntityType())) continue;
            for (LootData data : additionalLootData.getResults()) {
                if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                    if (blacklistedItems.contains(data.getItem().func_77973_b()) || this.drops.contains(data)) continue;
                    this.drops.add(data);
                    ++lootIndex;
                    if (!data.isCooking()) continue;
                    this.drops.add(data);
                    this.cookedIDs.add(lootIndex);
                    ++lootIndex;
                    continue;
                }
                if (!blacklistedItems.contains(data.getItem().func_77973_b()) || this.drops.contains(data)) continue;
                this.drops.add(data);
                ++lootIndex;
                if (!data.isCooking()) continue;
                this.drops.add(data);
                this.cookedIDs.add(lootIndex);
                ++lootIndex;
            }
        }
        this.ticks = entity.getTotalGrowTicks();
        this.requiresWater = entity.ifRequiresWater();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        LivingEntity livingEntity;
        ClientWorld level;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", Registry.field_212629_r.func_177774_c(this.getEntity().getEntityType()).toString());
        WeightedSpawnerEntity renderedEntity = new WeightedSpawnerEntity(1, nbt);
        if (Minecraft.func_71410_x().func_71401_C() != null) {
            LivingEntity livingEntity2 = (LivingEntity)EntityType.func_220335_a((CompoundNBT)renderedEntity.func_185277_b(), (World)Minecraft.func_71410_x().func_71401_C().func_241755_D_(), Function.identity());
            if (livingEntity2 != null) {
                float scale = this.getScaleForEntityType(livingEntity2);
                int offsetY = this.getOffsetForEntityType(livingEntity2);
                rotation = (rotation + 0.5f) % 360.0f;
                EntityWrapper.renderEntity(matrixStack, 38, 120 - offsetY, scale, 38.0 - yaw, 70 - offsetY, livingEntity2);
                yaw = (yaw + 1.5) % 720.0;
            }
        } else if (Minecraft.func_71410_x().func_147104_D() != null && (level = Minecraft.func_71410_x().field_71441_e) != null && (livingEntity = (LivingEntity)EntityType.func_220335_a((CompoundNBT)renderedEntity.func_185277_b(), (World)level, Function.identity())) != null) {
            float scale = this.getScaleForEntityType(livingEntity);
            int offsetY = this.getOffsetForEntityType(livingEntity);
            rotation = (rotation + 0.5f) % 360.0f;
            EntityWrapper.renderEntity(matrixStack, 38, 120 - offsetY, scale, 38.0 - yaw, 70 - offsetY, livingEntity);
            yaw = (yaw + 1.5) % 720.0;
        }
    }

    public static void renderEntity(MatrixStack matrixStack, int x, int y, float scale, double yaw, double pitch, LivingEntity entity) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 50.0);
        matrixStack.func_227862_a_(-scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        IRenderTypeBuffer.Impl buff = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        try {
            Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, (IRenderTypeBuffer)buff, 0xF000F0);
        }
        catch (Exception e) {
            matrixStack.func_227861_a_((double)x, (double)y, -50.0);
            matrixStack.func_227862_a_(scale, -scale, -scale);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            CagedMobs.LOGGER.error("Error with rendering entity in JEI!(CagedMobs)", (Throwable)e);
        }
        buff.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    private float getScaleForEntityType(LivingEntity entity) {
        float width = entity.func_213311_cf();
        float height = entity.func_213302_cg();
        if (entity.func_200600_R().toString().contains("twilightforest.ur_ghast")) {
            return 2.0f;
        }
        if (entity.func_200600_R().toString().contains("greekfantasy.charybdis")) {
            return 3.0f;
        }
        if (entity.func_200600_R().toString().contains("twilightforest.hydra")) {
            return 3.2f;
        }
        if (entity.func_200600_R().toString().contains("twilightforest.yeti_alpha")) {
            return 6.0f;
        }
        if (entity.func_200600_R().toString().contains("minecraft.ender_dragon")) {
            return 5.0f;
        }
        if (entity.func_200600_R().toString().contains("twilightforest.armored_giant")) {
            return 6.0f;
        }
        if (entity.func_200600_R().toString().contains("twilightforest.giant_miner")) {
            return 6.0f;
        }
        if (entity.func_200600_R().toString().contains("twilightforest.mini_ghast")) {
            return 10.0f;
        }
        if (entity.func_200600_R().toString().contains("outvoted:kraken")) {
            return 2.0f;
        }
        if (entity.func_200600_R().toString().contains("mowziesmobs:frostmaw")) {
            return 10.0f;
        }
        if (entity.func_200600_R().toString().contains("alexsmobs:cachalot_whale")) {
            return 0.2f;
        }
        if (entity.func_200600_R().toString().contains("greekfantasy:giant_boar")) {
            return 10.0f;
        }
        if (entity.func_200600_R().toString().contains("alexsmobs:crocodile")) {
            return 6.0f;
        }
        if (entity.func_200600_R().toString().contains("alexsmobs:hammerhead_shark")) {
            return 6.0f;
        }
        if (entity instanceof ElderGuardianEntity) {
            return 10.0f;
        }
        if (entity instanceof AbstractGroupFishEntity) {
            return 25.0f;
        }
        if (entity instanceof GhastEntity) {
            return 5.2f;
        }
        if (width <= height) {
            if (height >= 3.0f) {
                return 10.0f;
            }
            if ((double)height >= 2.5) {
                return 15.0f;
            }
            if ((double)height >= 1.9) {
                return 18.0f;
            }
        }
        return 20.0f;
    }

    private int getOffsetForEntityType(LivingEntity entity) {
        if (entity instanceof PhantomEntity || entity instanceof AbstractGroupFishEntity || entity instanceof EnderDragonEntity || entity instanceof DolphinEntity || entity instanceof GuardianEntity || entity instanceof TurtleEntity) {
            return 60;
        }
        if (entity instanceof GhastEntity || entity instanceof SquidEntity) {
            return 65;
        }
        return 50;
    }

    public void setIngredients(IIngredients iIngredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(this.envs);
        iIngredients.setInputs(VanillaTypes.ITEM, inputs);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData loot : this.drops) {
            if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                if (blacklistedItems.contains(loot.getItem().func_77973_b())) continue;
                outputs.add(loot.getItem());
                if (loot.getCookedItem().func_190926_b() || !loot.isCooking()) continue;
                outputs.add(loot.getCookedItem());
                continue;
            }
            if (!blacklistedItems.contains(loot.getItem().func_77973_b())) continue;
            outputs.add(loot.getItem());
            if (loot.getCookedItem().func_190926_b() || !loot.isCooking()) continue;
            outputs.add(loot.getCookedItem());
        }
        iIngredients.setOutputs(VanillaTypes.ITEM, outputs);
    }

    public List<LootData> getDrops() {
        return this.drops;
    }

    public List<ItemStack> getEnvsItems() {
        return this.envs;
    }

    public MobData getEntity() {
        return this.entity;
    }

    public List<ItemStack> getSamplers() {
        return this.samplers;
    }

    public List<Integer> getCookedIDs() {
        return this.cookedIDs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getSeconds() {
        return this.ticks / 20;
    }

    public boolean ifRequiresWater() {
        return this.requiresWater;
    }

    public void getTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        if (!ingredient.func_190926_b()) {
            if (slotIndex == 1) {
                EnvironmentData env = MobCageTE.getEnvironmentFromItemStack(ingredient);
                if (env != null) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.growModifier", new Object[]{DECIMAL_FORMAT.format(env.getGrowModifier() * 100.0f - 100.0f)}));
                }
            } else if (slotIndex != 0) {
                LootData loot = this.drops.get(slotIndex - 2);
                tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.chance", new Object[]{DECIMAL_FORMAT.format(loot.getChance() * 100.0f)}));
                if (loot.getMinAmount() == loot.getMaxAmount()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.amountEqual", new Object[]{loot.getMinAmount()}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.amount", new Object[]{loot.getMinAmount(), loot.getMaxAmount()}));
                }
                if (loot.isLighting()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.lightning_upgrade").func_240699_a_(TextFormatting.YELLOW));
                }
                if (loot.isCooking() && ingredient.func_77973_b().equals(loot.getCookedItem().func_77973_b())) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.cooking_upgrade").func_240699_a_(TextFormatting.YELLOW));
                }
                if (loot.isArrow()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.arrow_upgrade").func_240699_a_(TextFormatting.YELLOW));
                }
                if (loot.hasColor()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.cagedmobs.entity.colorItem").func_240699_a_(TextFormatting.YELLOW));
                }
            }
        }
    }
}

