/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.blocks;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.addons.theoneprobe.ITopInfoProvider;
import com.corgam.cagedmobs.items.ArrowUpgradeItem;
import com.corgam.cagedmobs.items.CookingUpgradeItem;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.items.LightningUpgradeItem;
import com.corgam.cagedmobs.items.UpgradeItem;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.setup.CagedItems;
import com.corgam.cagedmobs.tileEntities.MobCageTE;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MobCageBlock
extends ContainerBlock
implements ITopInfoProvider,
IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public MobCageBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new MobCageTE(false);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        FluidState fluidstate = p_196258_1_.func_195991_k().func_204610_c(p_196258_1_.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)super.func_196258_a(p_196258_1_).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)p_196271_4_));
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof MobCageTE) {
            MobCageTE cage = (MobCageTE)tile;
            ItemStack heldItem = player.func_184586_b(handIn);
            if (player.func_213453_ef()) {
                if (cage.isCooking() || cage.isLightning() || cage.isArrow()) {
                    if (cage.isCooking()) {
                        cage.setCooking(false);
                        cage.dropItem(new ItemStack((IItemProvider)CagedItems.COOKING_UPGRADE.get(), 1));
                        return ActionResultType.SUCCESS;
                    }
                    if (cage.isLightning()) {
                        cage.setLightning(false);
                        cage.dropItem(new ItemStack((IItemProvider)CagedItems.LIGHTNING_UPGRADE.get(), 1));
                        return ActionResultType.SUCCESS;
                    }
                    if (cage.isArrow()) {
                        cage.setArrow(false);
                        cage.dropItem(new ItemStack((IItemProvider)CagedItems.ARROW_UPGRADE.get(), 1));
                        return ActionResultType.SUCCESS;
                    }
                }
                if (cage.hasEntity()) {
                    cage.onEntityRemoval();
                    return ActionResultType.SUCCESS;
                }
                if (cage.hasEnvironment()) {
                    if (cage.hasEnvironment()) {
                        cage.dropItem(cage.getEnvItem().func_77946_l());
                    }
                    cage.onEnvironmentRemoval();
                    return ActionResultType.SUCCESS;
                }
            }
            if (!(cage.isCooking() && cage.isLightning() && cage.isArrow() || !(heldItem.func_77973_b() instanceof UpgradeItem))) {
                if (heldItem.func_77973_b() instanceof CookingUpgradeItem && !cage.isCooking()) {
                    cage.setCooking(true);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (heldItem.func_77973_b() instanceof LightningUpgradeItem && !cage.isLightning()) {
                    cage.setLightning(true);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (heldItem.func_77973_b() instanceof ArrowUpgradeItem && !cage.isArrow()) {
                    cage.setArrow(true);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                }
            }
            if (!cage.hasEnvironment()) {
                if (MobCageTE.existsEnvironmentFromItemStack(heldItem)) {
                    cage.setEnvironment(heldItem);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (heldItem.func_77973_b() instanceof DnaSamplerItem) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.envRequired").func_240699_a_(TextFormatting.RED), true);
                }
                return ActionResultType.PASS;
            }
            if (!cage.hasEntity()) {
                if (heldItem.func_77973_b() instanceof DnaSamplerItem) {
                    DnaSamplerItem sampler = (DnaSamplerItem)heldItem.func_77973_b();
                    if (MobCageTE.existsEntityFromType(sampler.getEntityType(heldItem)) && cage.isEnvSuitable(player, sampler.getEntityType(heldItem), state) && !RecipesHelper.isEntityTypeBlacklisted(sampler.getEntityType(heldItem))) {
                        cage.setEntityFromType(sampler.getEntityType(heldItem), heldItem);
                        if (!player.func_184812_l_()) {
                            sampler.removeEntityType(heldItem);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.PASS;
                }
                return ActionResultType.PASS;
            }
            if ((!cage.isHopping() || CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) && cage.isWaitingForHarvest()) {
                cage.onPlayerHarvest();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof MobCageTE) {
            MobCageTE tile = (MobCageTE)tileEntity;
            if (tile.hasEnvironment()) {
                tile.dropItem(tile.getEnvItem().func_77946_l());
            }
            if (tile.isCooking()) {
                tile.dropItem(new ItemStack((IItemProvider)CagedItems.COOKING_UPGRADE.get(), 1));
            }
            if (tile.isLightning()) {
                tile.dropItem(new ItemStack((IItemProvider)CagedItems.LIGHTNING_UPGRADE.get(), 1));
            }
            if (tile.isArrow()) {
                tile.dropItem(new ItemStack((IItemProvider)CagedItems.ARROW_UPGRADE.get(), 1));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.mainInfo").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.envInfo").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.upgrading").func_240699_a_(TextFormatting.GRAY));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        if (!(world.func_175625_s(data.getPos()) instanceof MobCageTE)) {
            return;
        }
        MobCageTE tile = (MobCageTE)world.func_175625_s(data.getPos());
        if (tile != null) {
            if (tile.hasEnvironment() && tile.hasEntity()) {
                probeInfo.progress((int)(tile.getGrowthPercentage() * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
            }
            if (tile.hasEnvironment()) {
                probeInfo.horizontal().text((ITextComponent)new TranslationTextComponent("HWYLA.tooltip.cagedmobs.cage.environment"));
                probeInfo.horizontal().item(tile.getEnvItem()).itemLabel(tile.getEnvItem());
            }
            if (tile.hasEntity()) {
                probeInfo.horizontal().text((ITextComponent)new StringTextComponent(new TranslationTextComponent("HWYLA.tooltip.cagedmobs.cage.entity").func_240699_a_(TextFormatting.GRAY).getString() + new TranslationTextComponent(tile.getEntityType().func_210760_d()).func_240699_a_(TextFormatting.GRAY).getString()));
            }
            if (tile.hasUpgrade()) {
                probeInfo.horizontal().text((ITextComponent)new TranslationTextComponent("TOP.tooltip.cagedmobs.cage.upgrades"));
            }
            if (tile.isLightning() && tile.isArrow() && tile.isCooking()) {
                probeInfo.horizontal().item(((Item)CagedItems.LIGHTNING_UPGRADE.get()).func_190903_i()).item(((Item)CagedItems.COOKING_UPGRADE.get()).func_190903_i()).item(((Item)CagedItems.ARROW_UPGRADE.get()).func_190903_i());
            } else if (tile.isLightning() && tile.isCooking()) {
                probeInfo.horizontal().item(((Item)CagedItems.LIGHTNING_UPGRADE.get()).func_190903_i()).item(((Item)CagedItems.COOKING_UPGRADE.get()).func_190903_i());
            } else if (tile.isLightning() && tile.isArrow()) {
                probeInfo.horizontal().item(((Item)CagedItems.LIGHTNING_UPGRADE.get()).func_190903_i()).item(((Item)CagedItems.ARROW_UPGRADE.get()).func_190903_i());
            } else if (tile.isCooking() && tile.isArrow()) {
                probeInfo.horizontal().item(((Item)CagedItems.COOKING_UPGRADE.get()).func_190903_i()).item(((Item)CagedItems.ARROW_UPGRADE.get()).func_190903_i());
            } else if (tile.isLightning()) {
                probeInfo.horizontal().item(((Item)CagedItems.LIGHTNING_UPGRADE.get()).func_190903_i());
            } else if (tile.isCooking()) {
                probeInfo.item(((Item)CagedItems.COOKING_UPGRADE.get()).func_190903_i());
            } else if (tile.isArrow()) {
                probeInfo.horizontal().item(((Item)CagedItems.ARROW_UPGRADE.get()).func_190903_i());
            }
        }
    }
}

