/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.items;

import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.mob.MobData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DnaSamplerItem
extends Item {
    public DnaSamplerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Hand hand;
        if (target.field_70170_p.func_201670_d() || !(attacker instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        if (player.func_184614_ca().equals(stack)) {
            hand = Hand.MAIN_HAND;
        } else if (player.func_184592_cb().equals(stack)) {
            hand = Hand.OFF_HAND;
        } else {
            return false;
        }
        if (DnaSamplerItem.canBeCached((Entity)target) && !RecipesHelper.isEntityTypeBlacklisted(target.func_200600_R())) {
            if (DnaSamplerItem.samplerTierSufficient(stack, (Entity)target)) {
                CompoundNBT nbt = new CompoundNBT();
                SerializationHelper.serializeEntityTypeNBT(nbt, target.func_200600_R());
                if (target instanceof SheepEntity) {
                    SheepEntity sheep = (SheepEntity)target;
                    DyeColor color = sheep.func_175509_cj();
                    nbt.func_74768_a("Color", color.func_196059_a());
                }
                stack.func_77982_d(nbt);
                player.func_184611_a(hand, stack);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.cagedmobs.dnasampler.not_sufficient").func_240699_a_(TextFormatting.RED), true);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.cagedmobs.dnasampler.not_cachable").func_240699_a_(TextFormatting.RED), true);
        }
        return false;
    }

    private static boolean samplerTierSufficient(ItemStack stack, Entity target) {
        EntityType type = target.func_200600_R();
        boolean sufficient = false;
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.MOB_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            MobData mobData;
            if (!(recipe instanceof MobData) || (mobData = (MobData)recipe).getEntityType() == null || !mobData.getEntityType().equals((Object)type) || mobData.getSamplerTier() > DnaSamplerItem.getSamplerTierInt(stack.func_77973_b())) continue;
            sufficient = true;
            break;
        }
        return sufficient;
    }

    private static int getSamplerTierInt(Item item) {
        if (item instanceof DnaSamplerNetheriteItem) {
            return 3;
        }
        if (item instanceof DnaSamplerDiamondItem) {
            return 2;
        }
        return 1;
    }

    private static boolean canBeCached(Entity clickedEntity) {
        boolean contains = false;
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.MOB_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            MobData mobData;
            if (!(recipe instanceof MobData) || (mobData = (MobData)recipe).getEntityType() == null || !mobData.getEntityType().equals((Object)clickedEntity.func_200600_R())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_213453_ef() && itemstack.func_77942_o()) {
            itemstack.func_196083_e("entity");
            playerIn.func_184609_a(handIn);
            ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.getTooltip(stack));
        tooltip.add((ITextComponent)this.getInformationForTier().func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.cagedmobs.dnasampler.makeEmpty").func_240699_a_(TextFormatting.GRAY));
    }

    private TranslationTextComponent getInformationForTier() {
        if (this instanceof DnaSamplerNetheriteItem) {
            return new TranslationTextComponent("item.cagedmobs.dnasampler.tier3Info");
        }
        if (this instanceof DnaSamplerDiamondItem) {
            return new TranslationTextComponent("item.cagedmobs.dnasampler.tier2Info");
        }
        return new TranslationTextComponent("item.cagedmobs.dnasampler.tier1Info");
    }

    private ITextComponent getTooltip(ItemStack stack) {
        if (!DnaSamplerItem.containsEntityType(stack)) {
            return new TranslationTextComponent("item.cagedmobs.dnasampler.empty").func_240699_a_(TextFormatting.YELLOW);
        }
        EntityType<?> type = SerializationHelper.deserializeEntityTypeNBT(stack.func_77978_p());
        if (type != null) {
            return new TranslationTextComponent(type.func_210760_d()).func_240699_a_(TextFormatting.YELLOW);
        }
        return new TranslationTextComponent("item.cagedmobs.dnasampler.unknown_entity").func_240699_a_(TextFormatting.YELLOW);
    }

    public static boolean containsEntityType(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("entity");
    }

    public void removeEntityType(ItemStack stack) {
        stack.func_196083_e("entity");
    }

    public EntityType<?> getEntityType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p() != null) {
            return SerializationHelper.deserializeEntityTypeNBT(stack.func_77978_p());
        }
        return null;
    }
}

