/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.env.EnvironmentData;
import com.corgam.cagedmobs.serializers.env.RecipeTypeEnvData;
import com.corgam.cagedmobs.serializers.mob.AdditionalLootData;
import com.corgam.cagedmobs.serializers.mob.MobData;
import com.corgam.cagedmobs.serializers.mob.RecipeAdditionalLoot;
import com.corgam.cagedmobs.serializers.mob.RecipeTypeMobData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipesHelper {
    public static final IRecipeType<MobData> MOB_RECIPE = new RecipeTypeMobData();
    public static final IRecipeType<EnvironmentData> ENV_RECIPE = new RecipeTypeEnvData();
    public static final IRecipeType<AdditionalLootData> ADDITIONAL_LOOT_RECIPE = new RecipeAdditionalLoot();

    public static Map<ResourceLocation, IRecipe<?>> getRecipes(IRecipeType<?> recipeType, RecipeManager manager) {
        Map recipesMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RecipeManager.class, (Object)manager, (String)"field_199522_d");
        return (Map)recipesMap.get(recipeType);
    }

    public static List<MobData> getEntitiesRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.func_241447_a_(MOB_RECIPE);
        }
        return Collections.emptyList();
    }

    public static List<EnvironmentData> getEnvsRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.func_241447_a_(ENV_RECIPE);
        }
        return Collections.emptyList();
    }

    public static List<AdditionalLootData> getAdditionalLootRecipesList(RecipeManager manager) {
        if (manager != null) {
            return manager.func_241447_a_(ADDITIONAL_LOOT_RECIPE);
        }
        return Collections.emptyList();
    }

    public static RecipeManager getRecipeManager() {
        try {
            if (EffectiveSide.get().isClient()) {
                return RecipesHelper.getRecipeManagerClient();
            }
            return RecipesHelper.getRecipeManagerServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static RecipeManager getRecipeManagerClient() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            return Minecraft.func_71410_x().field_71439_g.field_71174_a.func_199526_e();
        }
        return null;
    }

    private static RecipeManager getRecipeManagerServer() {
        return ServerLifecycleHooks.getCurrentServer().func_199529_aN();
    }

    public static boolean isEnvValidForEntity(MobData entity, EnvironmentData env) {
        for (String s : entity.getValidEnvs()) {
            for (String s2 : env.getEnvironments()) {
                if (!s.matches(s2)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<EntityType<?>> getEntityTypesFromConfigList() {
        ArrayList blacklisted = new ArrayList(Collections.emptyList());
        List<? extends String> blacklistedEntities = CagedMobs.SERVER_CONFIG.getEntitiesList();
        for (String string : blacklistedEntities) {
            Optional entityType = EntityType.func_220327_a((String)string);
            entityType.ifPresent(blacklisted::add);
        }
        return blacklisted;
    }

    public static boolean isEntityTypeBlacklisted(EntityType<?> type) {
        List<EntityType<?>> list = RecipesHelper.getEntityTypesFromConfigList();
        if (CagedMobs.SERVER_CONFIG.isEntitiesListInWhitelistMode()) {
            return !list.contains(type);
        }
        return list.contains(type);
    }

    public static List<Item> getItemsFromConfigList() {
        ArrayList<Item> blacklisted = new ArrayList<Item>(Collections.emptyList());
        List<? extends String> blacklistedItems = CagedMobs.SERVER_CONFIG.getItemsList();
        for (String string : blacklistedItems) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (i == Items.field_190931_a && i == null) continue;
            blacklisted.add(i);
        }
        return blacklisted;
    }
}

