/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SerializationHelper {
    public static void serializeStringCollection(PacketBuffer buffer, Set<String> categories) {
        buffer.writeInt(categories.size());
        for (String s : categories) {
            buffer.func_180714_a(s);
        }
    }

    public static void deserializeStringCollection(PacketBuffer buffer, Set<String> categories) {
        int len = buffer.readInt();
        for (int i = 0; i < len; ++i) {
            categories.add(buffer.func_218666_n());
        }
    }

    public static void serializeBlockState(PacketBuffer buffer, BlockState renderState) {
        Block block = renderState.func_177230_c();
        String locationString = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString();
        buffer.func_180714_a(locationString);
    }

    public static BlockState deserializeBlockState(PacketBuffer buffer) {
        String locationString = buffer.func_218666_n();
        ResourceLocation location = new ResourceLocation(locationString);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            return block.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static BlockState deserializeBlockState(JsonElement json) {
        ResourceLocation location = new ResourceLocation(json.getAsString());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            return block.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static EntityType<?> deserializeEntityType(ResourceLocation id, PacketBuffer buffer) {
        String entityTypeString = buffer.func_218666_n();
        ResourceLocation res = new ResourceLocation(entityTypeString);
        if (EntityType.func_220327_a((String)res.toString()).isPresent()) {
            return (EntityType)EntityType.func_220327_a((String)res.toString()).get();
        }
        return null;
    }

    public static void serializeEntityType(PacketBuffer buffer, EntityType<?> entityType) {
        String entityTypeString = EntityType.func_200718_a(entityType).toString();
        buffer.func_180714_a(entityTypeString);
    }

    public static CompoundNBT serializeEntityTypeNBT(CompoundNBT nbt, EntityType<?> entityType) {
        nbt.func_74778_a("entity", EntityType.func_200718_a(entityType).toString());
        return nbt;
    }

    public static EntityType<?> deserializeEntityTypeNBT(CompoundNBT nbt) {
        String resString = nbt.func_74779_i("entity");
        if (resString.isEmpty()) {
            return null;
        }
        String[] splitted = resString.split(":");
        ResourceLocation res = new ResourceLocation(splitted[0], splitted[1]);
        return (EntityType)ForgeRegistries.ENTITIES.getValue(res);
    }

    public static EntityType<?> deserializeEntityType(ResourceLocation id, JsonObject json) {
        String entityTypeString = json.getAsJsonPrimitive("entity").getAsString();
        Optional entityType = EntityType.func_220327_a((String)entityTypeString);
        if (entityType.isPresent()) {
            return (EntityType)entityType.get();
        }
        throw new IllegalArgumentException("MobDataRecipe with id: " + id + " has an invalid entity key. No entity with given key exists.");
    }
}

