/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.env;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.env.EnvironmentData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EnvironmentDataSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<EnvironmentData> {
    public static final EnvironmentDataSerializer INSTANCE = new EnvironmentDataSerializer();

    EnvironmentDataSerializer() {
        this.setRegistryName(new ResourceLocation("cagedmobs", "env_data"));
    }

    public EnvironmentData fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient inputItem = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("input"));
        BlockState renderState = SerializationHelper.deserializeBlockState((JsonElement)json.getAsJsonPrimitive("render"));
        float growModifier = JSONUtils.func_151217_k((JsonObject)json, (String)"growModifier");
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement e : json.getAsJsonArray("categories")) {
            categories.add(e.getAsString().toLowerCase());
        }
        if (growModifier <= -1.0f) {
            throw new IllegalArgumentException("Environment " + recipeId.toString() + " has an invalid grow modifier. It must be greater than -1.");
        }
        return new EnvironmentData(recipeId, inputItem, renderState, growModifier, categories);
    }

    public EnvironmentData fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            Ingredient inputItem = Ingredient.func_199566_b((PacketBuffer)buffer);
            BlockState renderState = SerializationHelper.deserializeBlockState(buffer);
            float growModifier = buffer.readFloat();
            HashSet<String> categories = new HashSet<String>();
            SerializationHelper.deserializeStringCollection(buffer, categories);
            return new EnvironmentData(recipeId, inputItem, renderState, growModifier, categories);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read environmentData with id: " + recipeId.toString() + " from packet buffer.");
        }
    }

    public void toNetwork(PacketBuffer buffer, EnvironmentData recipe) {
        try {
            recipe.getInputItem().func_199564_a(buffer);
            SerializationHelper.serializeBlockState(buffer, recipe.getRenderState());
            buffer.writeFloat(recipe.getGrowModifier());
            SerializationHelper.serializeStringCollection(buffer, recipe.getEnvironments());
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write environmentData with id " + recipe.func_199560_c().toString() + " to the packet buffer.");
        }
    }
}

