/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.mob;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.mob.AdditionalLootData;
import com.corgam.cagedmobs.serializers.mob.LootData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AdditionalLootDataSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<AdditionalLootData> {
    public static final AdditionalLootDataSerializer INSTANCE = new AdditionalLootDataSerializer();

    AdditionalLootDataSerializer() {
        this.setRegistryName(new ResourceLocation("cagedmobs", "additional_loot_data"));
    }

    public AdditionalLootData fromJson(ResourceLocation id, JsonObject json) {
        EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, json);
        List<LootData> results = AdditionalLootDataSerializer.deserializeLootData(id, json, entityType);
        return new AdditionalLootData(id, entityType, results);
    }

    public AdditionalLootData fromNetwork(ResourceLocation id, PacketBuffer buffer) {
        try {
            EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, buffer);
            ArrayList<LootData> results = new ArrayList<LootData>();
            int length = buffer.readInt();
            for (int i = 0; i < length; ++i) {
                results.add(LootData.deserializeBuffer(buffer));
            }
            return new AdditionalLootData(id, entityType, results);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read additionalLootData with id: " + id.toString() + " from packet buffer.");
        }
    }

    public void toNetwork(PacketBuffer buffer, AdditionalLootData recipe) {
        try {
            SerializationHelper.serializeEntityType(buffer, recipe.getEntityType());
            buffer.writeInt(recipe.getResults().size());
            for (LootData data : recipe.getResults()) {
                LootData.serializeBuffer(buffer, data);
            }
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write additionalLootData with id: " + recipe.func_199560_c().toString() + " to the packet buffer.");
        }
    }

    private static List<LootData> deserializeLootData(ResourceLocation ownerId, JsonObject json, EntityType<?> entityType) {
        ArrayList<LootData> loots = new ArrayList<LootData>();
        for (JsonElement elem : json.getAsJsonArray("results")) {
            if (!elem.isJsonObject()) continue;
            LootData lootData = LootData.deserialize(elem.getAsJsonObject());
            if (elem.getAsJsonObject().has("nbtName") && elem.getAsJsonObject().has("nbtData")) {
                ItemStack newItem = AdditionalLootDataSerializer.writeNBTtoItem(elem.getAsJsonObject().getAsJsonPrimitive("nbtName").getAsString(), elem.getAsJsonObject().getAsJsonPrimitive("nbtData").getAsString(), lootData.getItem());
                lootData.setItem(newItem);
            }
            loots.add(lootData);
        }
        return loots;
    }

    private static ItemStack writeNBTtoItem(String nbtName, String nbtData, ItemStack stack) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(nbtName, nbtData);
        stack.func_77982_d(nbt);
        return stack;
    }
}

