/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.mob;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class LootData {
    private final float chance;
    private ItemStack item;
    private final ItemStack cookedItem;
    private final int minAmount;
    private final int maxAmount;
    private final boolean lighting;
    private final boolean arrow;
    private int color;

    public LootData(ItemStack item, ItemStack cookedItem, float chance, int min, int max, boolean lighting, boolean arrow, int color) {
        this.chance = chance;
        this.item = item;
        this.cookedItem = cookedItem;
        this.minAmount = min;
        this.maxAmount = max;
        this.lighting = lighting;
        this.arrow = arrow;
        this.color = color;
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException("Amounts must not be negative!");
        }
        if (min > max) {
            throw new IllegalArgumentException("Min amount must not be greater than max amount!");
        }
    }

    public static LootData deserialize(JsonObject json) {
        float chance = JSONUtils.func_151217_k((JsonObject)json, (String)"chance");
        ItemStack item = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("output"));
        int min = JSONUtils.func_151203_m((JsonObject)json, (String)"minAmount");
        int max = JSONUtils.func_151203_m((JsonObject)json, (String)"maxAmount");
        ItemStack cookedItem = ItemStack.field_190927_a;
        if (json.has("output_cooked")) {
            cookedItem = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("output_cooked"));
        }
        boolean isLighting = false;
        if (json.has("lightning")) {
            isLighting = JSONUtils.func_151212_i((JsonObject)json, (String)"lightning");
        }
        boolean isArrow = false;
        if (json.has("needsArrow")) {
            isArrow = JSONUtils.func_151212_i((JsonObject)json, (String)"needsArrow");
        }
        int color = -1;
        if (json.has("color")) {
            color = JSONUtils.func_151203_m((JsonObject)json, (String)"color");
        }
        return new LootData(item, cookedItem, chance, min, max, isLighting, isArrow, color);
    }

    public static LootData deserializeBuffer(PacketBuffer buffer) {
        float chance = buffer.readFloat();
        ItemStack item = buffer.func_150791_c();
        int min = buffer.readInt();
        int max = buffer.readInt();
        boolean isLightning = buffer.readBoolean();
        boolean isArrow = buffer.readBoolean();
        ItemStack cookedItem = buffer.func_150791_c();
        int color = buffer.readInt();
        return new LootData(item, cookedItem, chance, min, max, isLightning, isArrow, color);
    }

    public static void serializeBuffer(PacketBuffer buffer, LootData info) {
        buffer.writeFloat(info.getChance());
        buffer.writeItemStack(info.getItem(), true);
        buffer.writeInt(info.getMinAmount());
        buffer.writeInt(info.getMaxAmount());
        buffer.writeBoolean(info.isLighting());
        buffer.writeBoolean(info.isArrow());
        buffer.writeItemStack(info.getCookedItem(), true);
        buffer.writeInt(info.getColor());
    }

    public String toString() {
        return "Loot data - item: " + this.item.toString() + ", chance: " + this.chance + ", min: " + this.minAmount + ", max: " + this.maxAmount;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getCookedItem() {
        return this.cookedItem;
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public boolean isLighting() {
        return this.lighting;
    }

    public boolean isCooking() {
        return !this.cookedItem.func_190926_b();
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public boolean hasColor() {
        return this.getColor() != -1;
    }

    public int getColor() {
        return this.color;
    }
}

