/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.mob;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.mob.LootData;
import com.corgam.cagedmobs.serializers.mob.MobData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MobDataSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<MobData> {
    public static final MobDataSerializer INSTANCE = new MobDataSerializer();

    MobDataSerializer() {
        this.setRegistryName(new ResourceLocation("cagedmobs", "mob_data"));
    }

    public MobData fromJson(ResourceLocation id, JsonObject json) {
        EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, json);
        Set<String> validEnvs = MobDataSerializer.deserializeEnvsData(id, json);
        int growTicks = JSONUtils.func_151203_m((JsonObject)json, (String)"growTicks");
        boolean requiresWater = false;
        if (json.has("requiresWater")) {
            requiresWater = JSONUtils.func_151212_i((JsonObject)json, (String)"requiresWater");
        }
        List<LootData> results = MobDataSerializer.deserializeLootData(id, json, entityType);
        int samplerTier = JSONUtils.func_151203_m((JsonObject)json, (String)"samplerTier");
        if (growTicks <= 0) {
            throw new IllegalArgumentException("MobDataRecipe with id: " + id.toString() + " has an invalid growth tick rate. It must use a positive integer.");
        }
        if (samplerTier < 1 || samplerTier > 3) {
            throw new IllegalArgumentException("MobDataRecipe with id: " + id.toString() + " has an invalid sampler tier. It must use tiers: 1,2 or 3.");
        }
        return new MobData(id, entityType, validEnvs, growTicks, requiresWater, results, samplerTier);
    }

    public MobData fromNetwork(ResourceLocation id, PacketBuffer buffer) {
        try {
            EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, buffer);
            HashSet<String> validEnvs = new HashSet<String>();
            SerializationHelper.deserializeStringCollection(buffer, validEnvs);
            int growTicks = buffer.readInt();
            boolean requiresWater = buffer.readBoolean();
            ArrayList<LootData> results = new ArrayList<LootData>();
            int length = buffer.readInt();
            for (int i = 0; i < length; ++i) {
                results.add(LootData.deserializeBuffer(buffer));
            }
            int tier = buffer.readInt();
            return new MobData(id, entityType, validEnvs, growTicks, requiresWater, results, tier);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read mobData with id: " + id.toString() + " from packet buffer.", e);
        }
    }

    public void toNetwork(PacketBuffer buffer, MobData recipe) {
        try {
            SerializationHelper.serializeEntityType(buffer, recipe.getEntityType());
            SerializationHelper.serializeStringCollection(buffer, recipe.getValidEnvs());
            buffer.writeInt(recipe.getTotalGrowTicks());
            buffer.writeBoolean(recipe.ifRequiresWater());
            buffer.writeInt(recipe.getResults().size());
            for (LootData data : recipe.getResults()) {
                LootData.serializeBuffer(buffer, data);
            }
            buffer.writeInt(recipe.getSamplerTier());
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write mobData with id: " + recipe.func_199560_c() + " to the packet buffer.", e);
        }
    }

    private static Set<String> deserializeEnvsData(ResourceLocation ownerId, JsonObject json) {
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement elem : json.getAsJsonArray("environments")) {
            categories.add(elem.getAsString().toLowerCase());
        }
        return categories;
    }

    private static List<LootData> deserializeLootData(ResourceLocation ownerId, JsonObject json, EntityType<?> entityType) {
        ArrayList<LootData> loots = new ArrayList<LootData>();
        for (JsonElement elem : json.getAsJsonArray("results")) {
            if (!elem.isJsonObject()) continue;
            LootData lootData = LootData.deserialize(elem.getAsJsonObject());
            if (elem.getAsJsonObject().has("nbtName") && elem.getAsJsonObject().has("nbtData")) {
                ItemStack newItem = MobDataSerializer.writeNBTtoItem(elem.getAsJsonObject().getAsJsonPrimitive("nbtName").getAsString(), elem.getAsJsonObject().getAsJsonPrimitive("nbtData").getAsString(), lootData.getItem());
                lootData.setItem(newItem);
            }
            loots.add(lootData);
        }
        return loots;
    }

    private static ItemStack writeNBTtoItem(String nbtName, String nbtData, ItemStack stack) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(nbtName, nbtData);
        stack.func_77982_d(nbt);
        return stack;
    }
}

