/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.tileEntities;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.tileEntities.MobCageTE;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.DistExecutor;

@OnlyIn(value=Dist.CLIENT)
public class MobCageRenderer
extends TileEntityRenderer<MobCageTE> {
    public MobCageRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(MobCageTE tile, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getEnvironment() != null && CagedMobs.CLIENT_CONFIG.shouldEnvsRender()) {
            matrix.func_227860_a_();
            matrix.func_227862_a_(0.74f, 0.015f, 0.74f);
            matrix.func_227861_a_(0.17, 5.0, 0.17);
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            dispatcher.renderBlock(tile.getEnvironment().getRenderState(), matrix, buffer, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
            matrix.func_227865_b_();
        }
        if (tile.hasEntity() && CagedMobs.CLIENT_CONFIG.shouldEntitiesRender()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.0, 0.5);
            Entity entity = tile.getCachedEntity(tile.func_145831_w());
            if (entity != null) {
                float maxSize = this.getEntitySize(entity);
                float maxEntityDimension = Math.max(entity.func_213311_cf(), entity.func_213302_cg());
                if ((double)maxEntityDimension > 1.0) {
                    maxSize /= maxEntityDimension;
                }
                matrix.func_227861_a_(0.0, (double)0.1f, 0.0);
                if (CagedMobs.CLIENT_CONFIG.shouldGrowthRender()) {
                    float growthPercentage = tile.getGrowthPercentage() * maxSize;
                    matrix.func_227862_a_(growthPercentage, growthPercentage, growthPercentage);
                } else {
                    matrix.func_227862_a_(maxSize, maxSize, maxSize);
                }
                if (entity instanceof SheepEntity) {
                    ((SheepEntity)entity).func_175512_b(DyeColor.func_196056_a((int)tile.getColor()));
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_175598_ae().func_229084_a_(entity, 0.0, 0.0, this.getEntityZ(entity), 0.0f, partialTicks, matrix, buffer, combinedLightIn));
            }
            matrix.func_227865_b_();
        }
    }

    private double getEntityZ(Entity entity) {
        if (entity instanceof DolphinEntity) {
            return 0.25;
        }
        if (entity instanceof ElderGuardianEntity) {
            return 1.2;
        }
        if (entity instanceof GuardianEntity) {
            return 0.7;
        }
        if (entity instanceof HoglinEntity || entity instanceof ZoglinEntity) {
            return -0.3f;
        }
        return 0.0;
    }

    private float getEntitySize(Entity entity) {
        if (entity instanceof DolphinEntity || entity instanceof PandaEntity || entity instanceof PigEntity || entity instanceof PolarBearEntity || entity instanceof SquidEntity || entity instanceof TurtleEntity || entity instanceof HoglinEntity || entity instanceof RavagerEntity || entity instanceof ShulkerEntity || entity instanceof ZoglinEntity) {
            return 0.32f;
        }
        if (entity instanceof AbstractHorseEntity) {
            return 0.4f;
        }
        if (entity instanceof GuardianEntity || entity instanceof PhantomEntity) {
            return 0.25f;
        }
        if (entity instanceof EnderDragonEntity) {
            return 0.8f;
        }
        return 0.5f;
    }
}

