/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.tileEntities;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.env.EnvironmentData;
import com.corgam.cagedmobs.serializers.mob.AdditionalLootData;
import com.corgam.cagedmobs.serializers.mob.LootData;
import com.corgam.cagedmobs.serializers.mob.MobData;
import com.corgam.cagedmobs.setup.CagedTE;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class MobCageTE
extends TileEntity
implements ITickableTileEntity {
    private boolean hopping = false;
    private boolean cooking = false;
    private boolean lightning = false;
    private boolean arrow = false;
    private EnvironmentData environment = null;
    private ItemStack envItem = ItemStack.field_190927_a;
    private MobData entity = null;
    private EntityType<?> entityType = null;
    private int currentGrowTicks = 0;
    private int totalGrowTicks = 0;
    private boolean waitingForHarvest = false;
    private int color = 0;
    private Entity cachedEntity;
    private WeightedSpawnerEntity renderedEntity;

    @OnlyIn(value=Dist.CLIENT)
    public Entity getCachedEntity(World world) {
        if (this.cachedEntity == null) {
            if (this.renderedEntity == null) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("id", Registry.field_212629_r.func_177774_c(this.entityType).toString());
                this.renderedEntity = new WeightedSpawnerEntity(1, nbt);
            }
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)this.renderedEntity.func_185277_b(), (World)world, Function.identity());
        }
        return this.cachedEntity;
    }

    public MobCageTE(boolean hopping) {
        super((TileEntityType)CagedTE.MOB_CAGE.get());
        this.hopping = hopping;
    }

    public MobCageTE() {
        super((TileEntityType)CagedTE.MOB_CAGE.get());
    }

    public void func_73660_a() {
        double d5;
        double d4;
        double d3;
        BlockPos blockpos;
        World world;
        Random rand;
        if (this.hasEnvAndEntity() && !this.waitingForHarvest) {
            if (this.currentGrowTicks >= this.getTotalGrowTicks()) {
                this.attemptHarvest();
            } else if (!this.entity.ifRequiresWater() || ((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                ++this.currentGrowTicks;
            }
        }
        if (this.isCooking() && CagedMobs.CLIENT_CONFIG.shouldUpgradesParticles()) {
            rand = new Random();
            if (!(this.field_145850_b instanceof ServerWorld) && rand.nextInt(10) == 0) {
                world = this.func_145831_w();
                blockpos = this.func_174877_v();
                d3 = (double)blockpos.func_177958_n() + world.field_73012_v.nextDouble();
                d4 = (double)blockpos.func_177956_o() + world.field_73012_v.nextDouble() / 3.0;
                d5 = (double)blockpos.func_177952_p() + world.field_73012_v.nextDouble();
                if (!((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, 0.0, 0.0, 0.0);
                } else {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_239811_B_, d3, d4, d5, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.isLightning() && CagedMobs.CLIENT_CONFIG.shouldUpgradesParticles()) {
            rand = new Random();
            if (!(this.field_145850_b instanceof ServerWorld) && rand.nextInt(30) == 0) {
                world = this.func_145831_w();
                blockpos = this.func_174877_v();
                d3 = (double)blockpos.func_177958_n() + 0.4 + world.field_73012_v.nextDouble() / 5.0;
                d4 = (double)blockpos.func_177956_o() + 0.8;
                d5 = (double)blockpos.func_177952_p() + 0.4 + world.field_73012_v.nextDouble() / 5.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d3, d4, d5, 0.0, 0.0, 0.0);
            }
        }
        if (this.isArrow() && CagedMobs.CLIENT_CONFIG.shouldUpgradesParticles()) {
            rand = new Random();
            if (!(this.field_145850_b instanceof ServerWorld) && rand.nextInt(30) == 0) {
                world = this.func_145831_w();
                blockpos = this.func_174877_v();
                d3 = (double)blockpos.func_177958_n() + 0.4 + world.field_73012_v.nextDouble() / 5.0;
                d4 = (double)blockpos.func_177956_o() + 0.8;
                d5 = (double)blockpos.func_177952_p() + 0.4 + world.field_73012_v.nextDouble() / 5.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197614_g, d3, d4, d5, 0.0, -0.5, 0.0);
            }
        }
    }

    private boolean hasEnvAndEntity() {
        return this.hasEntity() && this.hasEnvironment();
    }

    public int getTotalGrowTicks() {
        return this.totalGrowTicks;
    }

    public int getCurrentGrowTicks() {
        return this.currentGrowTicks;
    }

    public float getGrowthPercentage() {
        if (this.totalGrowTicks != 0) {
            return (float)this.currentGrowTicks / (float)this.totalGrowTicks;
        }
        return 0.0f;
    }

    public boolean isHopping() {
        return this.hopping;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public ItemStack getEnvItem() {
        return this.envItem;
    }

    public void setEnvironment(ItemStack stack) {
        this.func_70296_d();
        this.environment = MobCageTE.getEnvironmentFromItemStack(stack);
        ItemStack itemstack = stack.func_77946_l();
        itemstack.func_190920_e(1);
        this.envItem = itemstack;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public EnvironmentData getEnvironment() {
        return this.environment;
    }

    public boolean hasEnvironment() {
        return this.environment != null;
    }

    public static EnvironmentData getEnvironmentFromItemStack(ItemStack stack) {
        EnvironmentData finalEnvData = null;
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.ENV_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            EnvironmentData envData;
            if (!(recipe instanceof EnvironmentData) || !(envData = (EnvironmentData)recipe).getInputItem().test(stack)) continue;
            finalEnvData = envData;
            break;
        }
        return finalEnvData;
    }

    public static boolean existsEnvironmentFromItemStack(ItemStack stack) {
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.ENV_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            EnvironmentData envData;
            if (!(recipe instanceof EnvironmentData) || !(envData = (EnvironmentData)recipe).getInputItem().test(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnvSuitable(PlayerEntity player, EntityType<?> entityType, BlockState state) {
        MobData recipe = MobCageTE.getMobDataFromType(entityType);
        if (recipe.ifRequiresWater() && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.requiresWater").func_240699_a_(TextFormatting.RED), true);
            return false;
        }
        for (String env : this.environment.getEnvironments()) {
            if (!recipe.getValidEnvs().contains(env)) continue;
            return true;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("block.cagedmobs.mobcage.envNotSuitable").func_240699_a_(TextFormatting.RED), true);
        return false;
    }

    public void onEnvironmentRemoval() {
        this.onEntityRemoval();
        this.environment = null;
        this.envItem = ItemStack.field_190927_a;
        this.color = 0;
    }

    public MobData getEntity() {
        return this.entity;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public void setEntityFromType(EntityType<?> type, ItemStack sampler) {
        MobData mobData;
        this.func_70296_d();
        if (type.toString().contains("sheep") && sampler.func_77942_o() && sampler.func_77978_p() != null && sampler.func_77978_p().func_74764_b("Color")) {
            this.color = sampler.func_77978_p().func_74762_e("Color");
        }
        this.entity = mobData = MobCageTE.getMobDataFromType(type);
        this.entityType = type;
        this.totalGrowTicks = Math.round((float)mobData.getTotalGrowTicks() / this.environment.getGrowModifier());
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public static boolean existsEntityFromType(EntityType<?> entityType) {
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.MOB_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            MobData mobData;
            if (!(recipe instanceof MobData) || (mobData = (MobData)recipe).getEntityType() == null || !mobData.getEntityType().equals(entityType)) continue;
            return true;
        }
        return false;
    }

    private static MobData getMobDataFromType(EntityType<?> type) {
        MobData finalMobData = null;
        for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.MOB_RECIPE, RecipesHelper.getRecipeManager()).values()) {
            MobData mobData;
            if (!(recipe instanceof MobData) || (mobData = (MobData)recipe).getEntityType() == null || !mobData.getEntityType().equals(type)) continue;
            finalMobData = mobData;
            break;
        }
        if (finalMobData != null) {
            for (IRecipe<?> recipe : RecipesHelper.getRecipes(RecipesHelper.ADDITIONAL_LOOT_RECIPE, RecipesHelper.getRecipeManager()).values()) {
                if (!(recipe instanceof AdditionalLootData)) continue;
                AdditionalLootData additionalLootData = (AdditionalLootData)recipe;
                if (finalMobData.getEntityType() == null || !finalMobData.getEntityType().equals(additionalLootData.getEntityType())) continue;
                for (LootData data : additionalLootData.getResults()) {
                    if (finalMobData.getResults().contains(data)) continue;
                    finalMobData.getResults().add(data);
                }
            }
        }
        return finalMobData;
    }

    public void onEntityRemoval() {
        this.entity = null;
        this.entityType = null;
        this.cachedEntity = null;
        this.renderedEntity = null;
        this.currentGrowTicks = 0;
        this.totalGrowTicks = 0;
        this.waitingForHarvest = false;
        this.color = 0;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    private void attemptHarvest() {
        if (this.hopping && !CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) {
            this.currentGrowTicks = this.autoHarvest() ? 0 : this.getTotalGrowTicks();
        } else {
            this.waitingForHarvest = true;
            this.currentGrowTicks = this.getTotalGrowTicks();
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    private boolean autoHarvest() {
        IItemHandler inventory = this.getInv(this.field_145850_b, this.field_174879_c.func_177977_b(), Direction.UP);
        if (inventory != EmptyHandler.INSTANCE && !this.field_145850_b.func_201670_d()) {
            NonNullList<ItemStack> drops = this.createDropsList();
            block0: for (ItemStack item : drops) {
                for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                    if (!inventory.isItemValid(slot, item) || inventory.insertItem(slot, item, true).func_190916_E() == item.func_190916_E()) continue;
                    inventory.insertItem(slot, item, false);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private IItemHandler getInv(World world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            LazyOptional invCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return (IItemHandler)invCap.orElse((Object)EmptyHandler.INSTANCE);
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ISidedInventoryProvider) {
            ISidedInventoryProvider invProvider = (ISidedInventoryProvider)state.func_177230_c();
            ISidedInventory inv = invProvider.func_219966_a(state, (IWorld)world, pos);
            return new SidedInvWrapper(inv, side);
        }
        return EmptyHandler.INSTANCE;
    }

    public boolean isWaitingForHarvest() {
        return this.waitingForHarvest;
    }

    public void onPlayerHarvest() {
        if ((!this.hopping || CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) && this.canPlayerHarvest()) {
            this.currentGrowTicks = 0;
            this.waitingForHarvest = false;
            NonNullList<ItemStack> drops = this.createDropsList();
            for (ItemStack item : drops) {
                this.dropItem(item.func_77946_l());
            }
            this.func_70296_d();
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    private boolean canPlayerHarvest() {
        return this.hasEnvAndEntity() && this.getTotalGrowTicks() > 0 && this.getCurrentGrowTicks() >= this.getTotalGrowTicks();
    }

    private NonNullList<ItemStack> createDropsList() {
        NonNullList drops = NonNullList.func_191196_a();
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData loot : this.entity.getResults()) {
            int range;
            int amount;
            if (CagedMobs.SERVER_CONFIG.isEntitiesListInWhitelistMode() ? !blacklistedItems.contains(loot.getItem().func_77973_b()) : blacklistedItems.contains(loot.getItem().func_77973_b())) continue;
            if (loot.getColor() != -1 && loot.getColor() != this.color || !this.isLightning() && loot.isLighting() || !this.isArrow() && loot.isArrow() || this.field_145850_b == null || !(this.field_145850_b.field_73012_v.nextFloat() <= loot.getChance()) || (amount = this.field_145850_b.field_73012_v.nextInt(range = loot.getMaxAmount() - loot.getMinAmount() + 1) + loot.getMinAmount()) <= 0) continue;
            ItemStack stack = loot.getItem().func_77946_l();
            if (this.isCooking() && loot.isCooking()) {
                stack = loot.getCookedItem().func_77946_l();
            }
            stack.func_190920_e(amount);
            drops.add((Object)stack);
        }
        return drops;
    }

    public void dropItem(ItemStack item) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            double offsetX = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offsetY = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double offsetZ = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + offsetX, (double)this.field_174879_c.func_177956_o() + offsetY, (double)this.field_174879_c.func_177952_p() + offsetZ, item);
            itemEntity.func_174869_p();
            this.field_145850_b.func_217376_c((Entity)itemEntity);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74757_a("cooking", this.cooking);
        tag.func_74757_a("lightning", this.lightning);
        tag.func_74757_a("arrow", this.arrow);
        if (this.hasEnvironment()) {
            tag.func_218657_a("environmentItem", (INBT)this.envItem.serializeNBT());
            if (this.hasEntity()) {
                SerializationHelper.serializeEntityTypeNBT(tag, this.entityType);
                tag.func_74768_a("color", this.color);
                tag.func_74768_a("currentGrowTicks", this.currentGrowTicks);
                tag.func_74757_a("waitingForHarvest", this.waitingForHarvest);
            }
        }
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT tag = packet.func_148857_g();
        ItemStack oldEnv = this.envItem;
        EntityType<?> oldEntityType = this.entityType;
        this.cooking = tag.func_74767_n("cooking");
        this.lightning = tag.func_74767_n("lightning");
        this.arrow = tag.func_74767_n("arrow");
        this.envItem = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("environmentItem"));
        this.environment = MobCageTE.getEnvironmentFromItemStack(this.envItem);
        this.entityType = SerializationHelper.deserializeEntityTypeNBT(tag);
        this.entity = MobCageTE.getMobDataFromType(this.entityType);
        if (this.entityType == null) {
            this.renderedEntity = null;
            this.cachedEntity = null;
        }
        this.color = tag.func_74762_e("color");
        this.waitingForHarvest = tag.func_74767_n("waitingForHarvest");
        this.currentGrowTicks = tag.func_74762_e("currentGrowTicks");
        if (this.hasEntity()) {
            this.totalGrowTicks = Math.round((float)this.entity.getTotalGrowTicks() / this.environment.getGrowModifier());
        }
        if (!Objects.equals(oldEnv, this.envItem) || !Objects.equals(oldEntityType, this.entityType)) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            if (this.field_145850_b != null) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.hopping = nbt.func_74767_n("hopping");
        this.cooking = nbt.func_74767_n("cooking");
        this.lightning = nbt.func_74767_n("lightning");
        this.arrow = nbt.func_74767_n("arrow");
        this.envItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("environmentItem"));
        this.environment = MobCageTE.getEnvironmentFromItemStack(this.envItem);
        this.entityType = SerializationHelper.deserializeEntityTypeNBT(nbt);
        this.entity = MobCageTE.getMobDataFromType(this.entityType);
        this.color = nbt.func_74762_e("color");
        this.waitingForHarvest = nbt.func_74767_n("waitingForHarvest");
        this.currentGrowTicks = nbt.func_74762_e("currentGrowTicks");
        if (this.hasEnvAndEntity()) {
            this.totalGrowTicks = Math.round((float)this.entity.getTotalGrowTicks() / this.environment.getGrowModifier());
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT dataTag) {
        dataTag.func_74757_a("hopping", this.hopping);
        dataTag.func_74757_a("cooking", this.cooking);
        dataTag.func_74757_a("lightning", this.lightning);
        dataTag.func_74757_a("arrow", this.arrow);
        if (this.hasEnvironment()) {
            dataTag.func_218657_a("environmentItem", (INBT)this.envItem.serializeNBT());
            if (this.hasEntity()) {
                SerializationHelper.serializeEntityTypeNBT(dataTag, this.entityType);
                dataTag.func_74768_a("color", this.color);
                dataTag.func_74768_a("currentGrowTicks", this.currentGrowTicks);
                dataTag.func_74757_a("waitingForHarvest", this.waitingForHarvest);
            }
        }
        return super.func_189515_b(dataTag);
    }

    public boolean isCooking() {
        return this.cooking;
    }

    public boolean isLightning() {
        return this.lightning;
    }

    public boolean isArrow() {
        return this.arrow;
    }

    public boolean hasUpgrade() {
        return this.isArrow() || this.isCooking() || this.isLightning();
    }

    public int getColor() {
        return this.color;
    }

    public void setCooking(boolean cooking) {
        this.cooking = cooking;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void setLightning(boolean lightning) {
        this.lightning = lightning;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void setArrow(boolean arrow) {
        this.arrow = arrow;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }
}

