/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.candylands.entity;

import net.mcreator.candylands.CandylandsModElements;
import net.mcreator.candylands.item.CinnamonItem;
import net.mcreator.candylands.item.GingerbreadItem;
import net.mcreator.candylands.itemgroup.CandylandsMiscItemGroup;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@CandylandsModElements.ModElement.Tag
public class GingerpigEntity
extends CandylandsModElements.ModElement {
    public static EntityType entity = null;

    public GingerpigEntity(CandylandsModElements instance) {
        super(instance, 303);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.9f, 0.9f).func_206830_a("gingerpig").setRegistryName("gingerpig");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -3368449, -14411776, new Item.Properties().func_200916_a(CandylandsMiscItemGroup.tab)).setRegistryName("gingerpig_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("candylands:coldcandylands").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 2, 2, 3));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.2);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class CustomEntity
    extends AnimalEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 6;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)GingerbreadItem.block, 1));
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.pig.ambient"));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.pig.step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.pig.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.pig.death"));
        }

        public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
            CustomEntity retval = (CustomEntity)entity.func_200721_a((World)serverWorld);
            retval.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(new BlockPos((Vector3i)retval.func_233580_cy_())), SpawnReason.BREEDING, null, null);
            return retval;
        }

        public boolean func_70877_b(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return new ItemStack((IItemProvider)CinnamonItem.block, 1).func_77973_b() == stack.func_77973_b();
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, (EntityModel)new PigModel(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("candylands:textures/pig.png");
                }
            });
        }
    }
}

