/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coc;

import java.util.function.Supplier;
import net.mcreator.coc.CocMod;
import net.mcreator.coc.CocModElements;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CocModVariables {
    public static double PiecesNUM = 0.0;
    public static double RandX = 0.0;
    public static double RandY = 0.0;
    public static double RandZ = 0.0;
    @CapabilityInject(value=PlayerVariables.class)
    public static Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = null;

    public CocModVariables(CocModElements elements) {
        elements.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
        elements.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    private void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(PlayerVariables.class, (Capability.IStorage)new PlayerVariablesStorage(), PlayerVariables::new);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
            WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
            if (mapdata != null) {
                CocMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                CocMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
            CocMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("coc", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ((PlayerVariables)event.getPlayer().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
        clone.healthAmount = original.healthAmount;
        if (!event.isWasDeath()) {
            // empty if block
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(PacketBuffer buffer) {
            this.data = new PlayerVariables();
            new PlayerVariablesStorage().readNBT(null, this.data, null, (INBT)buffer.func_150793_b());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, PacketBuffer buffer) {
            buffer.func_150786_a((CompoundNBT)new PlayerVariablesStorage().writeNBT(null, message.data, null));
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.func_71410_x().field_71439_g.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.healthAmount = message.data.healthAmount;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double healthAmount = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayerEntity) {
                CocMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new PlayerVariablesSyncMessage(this));
            }
        }
    }

    private static class PlayerVariablesStorage
    implements Capability.IStorage<PlayerVariables> {
        private PlayerVariablesStorage() {
        }

        public INBT writeNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74780_a("healthAmount", instance.healthAmount);
            return nbt;
        }

        public void readNBT(Capability<PlayerVariables> capability, PlayerVariables instance, Direction side, INBT inbt) {
            CompoundNBT nbt = (CompoundNBT)inbt;
            instance.healthAmount = nbt.func_74769_h("healthAmount");
        }
    }

    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<INBT> {
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> PLAYER_VARIABLES_CAPABILITY.getDefaultInstance());

        private PlayerVariablesProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return PLAYER_VARIABLES_CAPABILITY.getStorage().writeNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_VARIABLES_CAPABILITY.getStorage().readNBT(PLAYER_VARIABLES_CAPABILITY, this.instance.orElseThrow(RuntimeException::new), null, nbt);
        }
    }

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            this.data.func_76184_a(buffer.func_150793_b());
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(WorldSavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "coc_mapvars";
        public double spreadspeed = 35.0;
        public double placeX = 0.0;
        public double placeY = 0.0;
        public double placeZ = 0.0;
        public boolean activestructures = true;
        public boolean doBiomes = true;
        public boolean spawnmobs = true;
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.spreadspeed = nbt.func_74769_h("spreadspeed");
            this.placeX = nbt.func_74769_h("placeX");
            this.placeY = nbt.func_74769_h("placeY");
            this.placeZ = nbt.func_74769_h("placeZ");
            this.activestructures = nbt.func_74767_n("activestructures");
            this.doBiomes = nbt.func_74767_n("doBiomes");
            this.spawnmobs = nbt.func_74767_n("spawnmobs");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("spreadspeed", this.spreadspeed);
            nbt.func_74780_a("placeX", this.placeX);
            nbt.func_74780_a("placeY", this.placeY);
            nbt.func_74780_a("placeZ", this.placeZ);
            nbt.func_74757_a("activestructures", this.activestructures);
            nbt.func_74757_a("doBiomes", this.doBiomes);
            nbt.func_74757_a("spawnmobs", this.spawnmobs);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                CocMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new WorldSavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (MapVariables)world.func_201672_e().func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "coc_worldvars";
        public double genNum = 0.0;
        public double globalBiomeTimer = 0.0;
        public double CrabHurtX = 0.0;
        public double CrabHurtY = 0.0;
        public double CrabHurtZ = 0.0;
        public double takeOrbX = 0.0;
        public double takeOrbY = 0.0;
        public double takeOrbZ = 0.0;
        public double flyX = 0.0;
        public double flyY = 0.0;
        public double flyZ = 0.0;
        public double EntSpawnX = 0.0;
        public double EntSpawnY = 0.0;
        public double EntSpawnZ = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.genNum = nbt.func_74769_h("genNum");
            this.globalBiomeTimer = nbt.func_74769_h("globalBiomeTimer");
            this.CrabHurtX = nbt.func_74769_h("CrabHurtX");
            this.CrabHurtY = nbt.func_74769_h("CrabHurtY");
            this.CrabHurtZ = nbt.func_74769_h("CrabHurtZ");
            this.takeOrbX = nbt.func_74769_h("takeOrbX");
            this.takeOrbY = nbt.func_74769_h("takeOrbY");
            this.takeOrbZ = nbt.func_74769_h("takeOrbZ");
            this.flyX = nbt.func_74769_h("flyX");
            this.flyY = nbt.func_74769_h("flyY");
            this.flyZ = nbt.func_74769_h("flyZ");
            this.EntSpawnX = nbt.func_74769_h("EntSpawnX");
            this.EntSpawnY = nbt.func_74769_h("EntSpawnY");
            this.EntSpawnZ = nbt.func_74769_h("EntSpawnZ");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("genNum", this.genNum);
            nbt.func_74780_a("globalBiomeTimer", this.globalBiomeTimer);
            nbt.func_74780_a("CrabHurtX", this.CrabHurtX);
            nbt.func_74780_a("CrabHurtY", this.CrabHurtY);
            nbt.func_74780_a("CrabHurtZ", this.CrabHurtZ);
            nbt.func_74780_a("takeOrbX", this.takeOrbX);
            nbt.func_74780_a("takeOrbY", this.takeOrbY);
            nbt.func_74780_a("takeOrbZ", this.takeOrbZ);
            nbt.func_74780_a("flyX", this.flyX);
            nbt.func_74780_a("flyY", this.flyY);
            nbt.func_74780_a("flyZ", this.flyZ);
            nbt.func_74780_a("EntSpawnX", this.EntSpawnX);
            nbt.func_74780_a("EntSpawnY", this.EntSpawnY);
            nbt.func_74780_a("EntSpawnZ", this.EntSpawnZ);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (!world.func_201672_e().field_72995_K) {
                CocMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.func_201672_e().field_73011_w).func_186058_p()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world.func_201672_e() instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world.func_201672_e()).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

