/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mcreator.coc.CocModElements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

@CocModElements.ModElement.Tag
public class PlaceHelper
extends CocModElements.ModElement {
    public PlaceHelper(CocModElements instance) {
        super(instance, 789);
    }

    public static void carveArea(World world, BlockPos pos, int sizeX, int sizeY, int sizeZ) {
        int x = pos.func_177958_n() - sizeX;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ;
        int lengthX = sizeX;
        int lengthY = sizeY;
        int lengthZ = sizeZ;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 1.0) {
                        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_201941_jj.func_176223_P(), 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void carveAreaHollow(World world, BlockState paint, BlockPos pos, int sizeX, int sizeY, int sizeZ, List replaceblocks, boolean blacklist) {
        int x = pos.func_177958_n() - sizeX - 1;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ - 1;
        int lengthX = sizeX + 2;
        int lengthY = sizeY;
        int lengthZ = sizeZ + 2;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) > 0.85 && Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 1.2 && (!blacklist && replaceblocks.contains(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) || blacklist && !replaceblocks.contains(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c()))) {
                        world.func_180501_a(new BlockPos(x, y, z), paint, 2);
                    } else if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 0.85) {
                        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void carveAreaHollow(World world, BlockState paint, BlockPos pos, int sizeX, int sizeY, int sizeZ, Material material) {
        int x = pos.func_177958_n() - sizeX;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ;
        int lengthX = sizeX;
        int lengthY = sizeY;
        int lengthZ = sizeZ;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) > 0.85 && Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 1.25 && world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == material) {
                        world.func_180501_a(new BlockPos(x, y, z), paint, 2);
                    } else if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 0.85) {
                        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_201941_jj.func_176223_P(), 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void carveSolidHollow(World world, BlockState paint, BlockPos pos, int sizeX, int sizeY, int sizeZ) {
        int x = pos.func_177958_n() - sizeX;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ;
        int lengthX = sizeX;
        int lengthY = sizeY;
        int lengthZ = sizeZ;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) > 0.85 && Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 1.25 && world.func_180495_p(new BlockPos(x, y, z)).func_215686_e((IBlockReader)world, pos)) {
                        world.func_180501_a(new BlockPos(x, y, z), paint, 2);
                    } else if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 0.85) {
                        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_201941_jj.func_176223_P(), 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void fillAreaList(World world, BlockState block, BlockPos pos, int sizeX, int sizeY, int sizeZ, List replace) {
        int x = pos.func_177958_n() - sizeX;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ;
        int lengthX = sizeX;
        int lengthY = sizeY;
        int lengthZ = sizeZ;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    if (Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0) <= 1.0 && replace.contains(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c())) {
                        world.func_180501_a(new BlockPos(x, y, z), block, 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void fillGradient(World world, BlockState block, BlockPos pos, int sizeX, int sizeY, int sizeZ, List replace, int density) {
        int x = pos.func_177958_n() - sizeX;
        int y = pos.func_177956_o() - sizeY;
        int z = pos.func_177952_p() - sizeZ;
        int lengthX = sizeX;
        int lengthY = sizeY;
        int lengthZ = sizeZ;
        for (int xr = 0; xr < lengthX * 2; ++xr) {
            for (int yr = 0; yr < lengthY * 2; ++yr) {
                for (int zr = 0; zr < lengthZ * 2; ++zr) {
                    double sphereFactor = Math.pow(x - pos.func_177958_n(), 2.0) / Math.pow(sizeX, 2.0) + Math.pow(y - pos.func_177956_o(), 2.0) / Math.pow(sizeY, 2.0) + Math.pow(z - pos.func_177952_p(), 2.0) / Math.pow(sizeZ, 2.0);
                    if (sphereFactor <= 1.0 && replace.contains(world.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) && Math.random() < 1.0 - sphereFactor + ((double)(density / 100) - 0.5)) {
                        world.func_180501_a(new BlockPos(x, y, z), block, 2);
                    }
                    ++z;
                }
                z = pos.func_177952_p() - sizeZ;
                ++y;
            }
            y = pos.func_177956_o() - sizeY;
            ++x;
        }
    }

    public static void fillArea(World world, BlockState block, BlockPos pos, int sizeX, int sizeY, int sizeZ, Block replace) {
        Block[] replaces = new Block[]{replace};
        List<Block> blocklist = Arrays.asList(replaces);
        PlaceHelper.fillAreaList(world, block, pos, sizeX, sizeY, sizeZ, blocklist);
    }

    public static void carveArea(World world, BlockPos pos, int size) {
        PlaceHelper.carveArea(world, pos, size, size, size);
    }

    public boolean noAir(World world, BlockPos startPos, int length, int height, int width, Rotation rotation, String structureName) {
        boolean foundAir;
        block19: {
            int temp;
            int z;
            int y;
            int x;
            block22: {
                int temp2;
                block21: {
                    int temp3;
                    block20: {
                        int temp4;
                        foundAir = false;
                        x = startPos.func_177958_n();
                        y = startPos.func_177956_o();
                        z = startPos.func_177952_p();
                        Template template = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h().func_200220_a(new ResourceLocation("coc", structureName));
                        if (length == -1) {
                            length = template.func_186259_a().func_177958_n();
                        }
                        if (height == -1) {
                            height = template.func_186259_a().func_177956_o();
                        }
                        if (width == -1) {
                            width = template.func_186259_a().func_177952_p();
                        }
                        if (rotation != Rotation.NONE) break block20;
                        int x2 = x + length;
                        int y2 = y + height;
                        int z2 = z + width;
                        if (x > x2) {
                            temp4 = x2;
                            x2 = x;
                            x = temp4;
                        }
                        if (y > y2) {
                            temp4 = y2;
                            y2 = y;
                            y = temp4;
                        }
                        if (z > z2) {
                            temp4 = z2;
                            z2 = z;
                            z = temp4;
                        }
                        for (BlockPos blockpos : BlockPos.func_191531_b((int)x, (int)y, (int)z, (int)x2, (int)y2, (int)z2)) {
                            if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150350_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_204546_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_207212_b) continue;
                            foundAir = true;
                            break block19;
                        }
                        break block19;
                    }
                    if (rotation != Rotation.CLOCKWISE_90) break block21;
                    int x2 = x - width;
                    int y2 = y + height;
                    int z2 = z + length;
                    if (x > x2) {
                        temp3 = x2;
                        x2 = x;
                        x = temp3;
                    }
                    if (y > y2) {
                        temp3 = y2;
                        y2 = y;
                        y = temp3;
                    }
                    if (z > z2) {
                        temp3 = z2;
                        z2 = z;
                        z = temp3;
                    }
                    for (BlockPos blockpos : BlockPos.func_191531_b((int)x, (int)y, (int)z, (int)x2, (int)y2, (int)z2)) {
                        if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150350_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_204546_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_207212_b) continue;
                        foundAir = true;
                        break block19;
                    }
                    break block19;
                }
                if (rotation != Rotation.CLOCKWISE_180) break block22;
                int x2 = x - length;
                int y2 = y + height;
                int z2 = z - width;
                if (x > x2) {
                    temp2 = x2;
                    x2 = x;
                    x = temp2;
                }
                if (y > y2) {
                    temp2 = y2;
                    y2 = y;
                    y = temp2;
                }
                if (z > z2) {
                    temp2 = z2;
                    z2 = z;
                    z = temp2;
                }
                for (BlockPos blockpos : BlockPos.func_191531_b((int)x, (int)y, (int)z, (int)x2, (int)y2, (int)z2)) {
                    if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150350_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_204546_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_207212_b) continue;
                    foundAir = true;
                    break block19;
                }
                break block19;
            }
            if (rotation != Rotation.COUNTERCLOCKWISE_90) break block19;
            int x2 = x + width;
            int y2 = y + height;
            int z2 = z - length;
            if (x > x2) {
                temp = x2;
                x2 = x;
                x = temp;
            }
            if (y > y2) {
                temp = y2;
                y2 = y;
                y = temp;
            }
            if (z > z2) {
                temp = z2;
                z2 = z;
                z = temp;
            }
            for (BlockPos blockpos : BlockPos.func_191531_b((int)x, (int)y, (int)z, (int)x2, (int)y2, (int)z2)) {
                if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_150350_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_204546_a && world.func_204610_c(blockpos).func_206886_c() != Fluids.field_207212_b) continue;
                foundAir = true;
                break;
            }
        }
        return !foundAir;
    }

    public boolean touchingAir(World world, BlockPos testPos) {
        return world.func_175623_d(testPos.func_177982_a(1, 0, 0)) || world.func_175623_d(testPos.func_177982_a(-1, 0, 0)) || world.func_175623_d(testPos.func_177982_a(0, 1, 0)) || world.func_175623_d(testPos.func_177982_a(0, -1, 0)) || world.func_175623_d(testPos.func_177982_a(0, 0, 1)) || world.func_175623_d(testPos.func_177982_a(0, 0, -1));
    }

    public Direction touchingSolid(World world, BlockPos testPos) {
        if (world.func_180495_p(testPos.func_177982_a(1, 0, 0)).func_200132_m()) {
            return Direction.EAST;
        }
        if (world.func_180495_p(testPos.func_177982_a(-1, 0, 0)).func_200132_m()) {
            return Direction.WEST;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 1, 0)).func_200132_m()) {
            return Direction.UP;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, -1, 0)).func_200132_m()) {
            return Direction.DOWN;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, 1)).func_200132_m()) {
            return Direction.SOUTH;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, -1)).func_200132_m()) {
            return Direction.NORTH;
        }
        return null;
    }

    public Direction touchingBlock(World world, BlockPos testPos, Block block) {
        if (world.func_180495_p(testPos.func_177982_a(1, 0, 0)).func_177230_c() == block) {
            return Direction.EAST;
        }
        if (world.func_180495_p(testPos.func_177982_a(-1, 0, 0)).func_177230_c() == block) {
            return Direction.WEST;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 1, 0)).func_177230_c() == block) {
            return Direction.UP;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, -1, 0)).func_177230_c() == block) {
            return Direction.DOWN;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, 1)).func_177230_c() == block) {
            return Direction.SOUTH;
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, -1)).func_177230_c() == block) {
            return Direction.NORTH;
        }
        return null;
    }

    public Direction touchingAny(World world, BlockPos testPos) {
        if (!world.func_175623_d(testPos.func_177982_a(1, 0, 0))) {
            return Direction.EAST;
        }
        if (!world.func_175623_d(testPos.func_177982_a(-1, 0, 0))) {
            return Direction.WEST;
        }
        if (!world.func_175623_d(testPos.func_177982_a(0, 1, 0))) {
            return Direction.UP;
        }
        if (!world.func_175623_d(testPos.func_177982_a(0, -1, 0))) {
            return Direction.DOWN;
        }
        if (!world.func_175623_d(testPos.func_177982_a(0, 0, 1))) {
            return Direction.SOUTH;
        }
        if (!world.func_175623_d(testPos.func_177982_a(0, 0, -1))) {
            return Direction.NORTH;
        }
        return null;
    }

    public List getSolidSides(World world, BlockPos testPos) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (world.func_180495_p(testPos.func_177982_a(1, 0, 0)).func_200132_m()) {
            directions.add(Direction.EAST);
        }
        if (world.func_180495_p(testPos.func_177982_a(-1, 0, 0)).func_200132_m()) {
            directions.add(Direction.WEST);
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 1, 0)).func_200132_m()) {
            directions.add(Direction.UP);
        }
        if (world.func_180495_p(testPos.func_177982_a(0, -1, 0)).func_200132_m()) {
            directions.add(Direction.DOWN);
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, 1)).func_200132_m()) {
            directions.add(Direction.SOUTH);
        }
        if (world.func_180495_p(testPos.func_177982_a(0, 0, -1)).func_200132_m()) {
            directions.add(Direction.NORTH);
        }
        return directions;
    }

    public boolean getClearance(World world, BlockPos bpos, int clearance) {
        int checks = 0;
        int level = 0;
        for (int i = 0; i < clearance; ++i) {
            if (!world.func_180495_p(bpos.func_177981_b(level)).func_200132_m()) {
                ++checks;
            }
            ++level;
        }
        return checks == clearance;
    }
}

